/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import javax.transaction.xa.Xid;

public class MQXid
implements Xid {
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;
    static final char[] Hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MQXid(int n, byte[] byArray, byte[] byArray2) {
        this.formatId = n;
        this.gtrid = byArray;
        this.bqual = byArray2;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("format: " + this.formatId);
        stringBuffer.append(", gtrid: " + MQXid.byteToHex(this.gtrid));
        stringBuffer.append(", bqual: " + MQXid.byteToHex(this.bqual));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        Xid xid = null;
        if (!(object instanceof Xid)) {
            return false;
        }
        xid = (Xid)object;
        if (this.formatId != xid.getFormatId()) {
            return false;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        if (this.gtrid.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.gtrid.length) {
            if (this.gtrid[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        byte[] byArray2 = xid.getBranchQualifier();
        if (this.bqual.length != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.bqual.length) {
            if (this.bqual[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static String byteToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(Hex[byArray[n] >> 4 & 0xF]);
                stringBuffer.append(Hex[byArray[n] & 0xF]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

