/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQXAVerbs;
import com.ibm.mq.MQXid;
import com.ibm.mqservices.Trace;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MQXAResource
implements XAResource {
    private static final String sccsid = "javabase/com/ibm/mq/MQXAResource.java, java, j5306, j5306-11-050701 03/12/11 10:39:00 @(#) 1.18.1.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5639-B43, 5695-137 (c) Copyright IBM Corp. 2001, 2002     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int nextRMID = 0;
    private String qmgrName;
    private int rmid;
    private MQXAVerbs session = null;
    private boolean debugXA = false;
    private boolean impEndFlag = false;
    private boolean closed = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MQXAResource(MQXAVerbs mQXAVerbs, String string) throws XAException {
        try {
            try {
                int n;
                if (Trace.isOn) {
                    Trace.entry(this, "constructor");
                    Trace.trace(2, this, sccsid);
                }
                this.qmgrName = string;
                this.session = mQXAVerbs;
                this.rmid = MQXAResource.getNextRMID();
                try {
                    n = mQXAVerbs.XAOPEN(string, this.rmid, 0);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n != 0) {
                    String string2 = MQException.getNLSMsg(113);
                    XAException xAException = new XAException(string2);
                    xAException.errorCode = n;
                    throw xAException;
                }
                Object var7_9 = null;
                if (!Trace.isOn) return;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor");
            throw throwable;
        }
        Trace.exit(this, "constructor");
    }

    public void finalize() throws Throwable {
        if (this.debugXA) {
            System.out.println(this.toString() + ".finalize()");
        }
        try {
            this.close();
        }
        catch (XAException xAException) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws XAException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "close()");
                }
                if (this.debugXA) {
                    System.out.println(this + " close()");
                }
                if (!this.closed) {
                    int n;
                    try {
                        n = this.session.XACLOSE(this.qmgrName, this.rmid, 0);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw (XAException)exception;
                    }
                    if (n != 0) {
                        String string = MQException.getNLSMsg(114);
                        XAException xAException = new XAException(string);
                        xAException.errorCode = n;
                        throw xAException;
                    }
                    this.closed = true;
                    this.session = null;
                }
                if (this.debugXA) {
                    System.out.println(this + " was already closed");
                }
                Trace.trace(this, " already closed");
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
            Object var5_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close()");
            throw throwable;
        }
        Trace.exit(this, "close()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepare(Xid xid) throws XAException {
        int n;
        try {
            try {
                int n2;
                if (Trace.isOn) {
                    Trace.entry(this, "prepare()");
                    Trace.trace(this, "xid: " + xid);
                }
                if (this.debugXA) {
                    System.out.println(this + " prepare(" + xid + ")");
                }
                if (this.closed) {
                    String string = MQException.getNLSMsg(115);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = -6;
                    throw xAException;
                }
                try {
                    n2 = this.session.XAPREPARE(xid, this.rmid, 0);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n2 != 0 && n2 != 3) {
                    String string = MQException.getNLSMsg(114);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = n2;
                    throw xAException;
                }
                n = n2;
                Object var6_11 = null;
                if (!Trace.isOn) return n;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "prepare()");
            throw throwable;
        }
        Trace.exit(this, "prepare()");
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            try {
                int n;
                if (Trace.isOn) {
                    Trace.entry(this, "commit");
                    Trace.trace(this, "xid: " + xid);
                }
                if (this.debugXA) {
                    System.out.println(this + " commit(" + xid + ", " + bl + ")");
                }
                if (this.closed) {
                    String string = MQException.getNLSMsg(115);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = -6;
                    throw xAException;
                }
                int n2 = bl ? 0x40000000 : 0;
                try {
                    n = this.session.XACOMMIT(xid, this.rmid, n2);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n != 0 && n != 3) {
                    String string = MQException.getNLSMsg(114);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = n;
                    throw xAException;
                }
                Object var8_12 = null;
                if (!Trace.isOn) return;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "commit");
            throw throwable;
        }
        Trace.exit(this, "commit");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback(Xid xid) throws XAException {
        try {
            try {
                int n;
                if (Trace.isOn) {
                    Trace.entry(this, "rollback");
                    Trace.trace(this, "xid: " + xid);
                }
                if (this.debugXA) {
                    System.out.println(this + " rollback(" + xid + ")");
                }
                if (this.closed) {
                    String string = MQException.getNLSMsg(115);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = -6;
                    throw xAException;
                }
                try {
                    n = this.session.XAROLLBACK(xid, this.rmid, 0);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n != 0) {
                    String string = MQException.getNLSMsg(114);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = n;
                    throw xAException;
                }
                Object var6_10 = null;
                if (!Trace.isOn) return;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "rollback");
            throw throwable;
        }
        Trace.exit(this, "rollback");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(Xid xid, int n) throws XAException {
        try {
            try {
                int n2;
                if (Trace.isOn) {
                    Trace.entry(this, "start");
                    Trace.trace(this, "xid: " + xid);
                }
                if (this.debugXA) {
                    System.out.println(this + " start(" + xid + ")");
                }
                if (this.closed) {
                    String string = MQException.getNLSMsg(115);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = -6;
                    throw xAException;
                }
                try {
                    n2 = this.session.XASTART(xid, this.rmid, n);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n2 != 0) {
                    String string = MQException.getNLSMsg(114);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = n2;
                    throw xAException;
                }
                Object var7_11 = null;
                if (!Trace.isOn) return;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "start");
            throw throwable;
        }
        Trace.exit(this, "start");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void end(Xid xid, int n) throws XAException {
        try {
            try {
                int n2;
                if (Trace.isOn) {
                    Trace.entry(this, "end");
                    Trace.trace(this, "xid: " + xid);
                }
                if (this.debugXA) {
                    System.out.println(this + " end(" + xid + ")");
                }
                if (this.closed) {
                    String string = MQException.getNLSMsg(115);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = -6;
                    throw xAException;
                }
                try {
                    n2 = this.session.XAEND(xid, this.rmid, n);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n2 != 0) {
                    String string = MQException.getNLSMsg(114);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = n2;
                    throw xAException;
                }
                Object var7_11 = null;
                if (!Trace.isOn) return;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "end");
            throw throwable;
        }
        Trace.exit(this, "end");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forget(Xid xid) throws XAException {
        try {
            try {
                int n;
                if (Trace.isOn) {
                    Trace.entry(this, "forget");
                }
                if (this.debugXA) {
                    System.out.println(this + " forget(" + xid + ")");
                }
                if (this.closed) {
                    String string = MQException.getNLSMsg(115);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = -6;
                    throw xAException;
                }
                try {
                    n = this.session.XAFORGET(xid, this.rmid, 0);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw (XAException)exception;
                }
                if (n != 0) {
                    String string = MQException.getNLSMsg(114);
                    XAException xAException = new XAException(string);
                    xAException.errorCode = n;
                    throw xAException;
                }
                Object var6_10 = null;
                if (!Trace.isOn) return;
            }
            catch (XAException xAException) {
                if (!Trace.isOn) throw xAException;
                Trace.trace(this, "throwing " + xAException);
                Trace.trace(this, "errorCode=" + xAException.errorCode);
                throw xAException;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "forget");
            throw throwable;
        }
        Trace.exit(this, "forget");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        block17: {
            Xid[] xidArray2;
            block16: {
                Xid[] xidArray3 = new MQXid[10];
                try {
                    try {
                        Xid[] xidArray4;
                        int n2;
                        if (Trace.isOn) {
                            Trace.entry(this, "recover");
                        }
                        if (this.debugXA) {
                            System.out.println(this + " recover()");
                        }
                        if (this.closed) {
                            String string = MQException.getNLSMsg(115);
                            XAException xAException = new XAException(string);
                            xAException.errorCode = -6;
                            throw xAException;
                        }
                        boolean bl = this.impEndFlag;
                        this.impEndFlag = false;
                        try {
                            n2 = this.session.XARECOVER(xidArray3, this.rmid, n);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw (XAException)exception;
                        }
                        if (n2 < 0) {
                            if (bl && n2 == -5 && n == 0) {
                                xidArray2 = new MQXid[]{};
                                Object var9_14 = null;
                                if (!Trace.isOn) return xidArray2;
                                break block16;
                            } else {
                                String string = MQException.getNLSMsg(114);
                                XAException xAException = new XAException(string);
                                xAException.errorCode = n2;
                                throw xAException;
                            }
                        }
                        if (n2 != xidArray3.length) {
                            xidArray4 = new MQXid[n2];
                            System.arraycopy(xidArray3, 0, xidArray4, 0, n2);
                            if ((n & 0x800000) == 0) {
                                this.impEndFlag = true;
                            }
                        } else {
                            xidArray4 = xidArray3;
                        }
                        xidArray = xidArray4;
                        break block17;
                    }
                    catch (XAException xAException) {
                        if (!Trace.isOn) throw xAException;
                        Trace.trace(this, "throwing " + xAException);
                        Trace.trace(this, "errorCode=" + xAException.errorCode);
                        throw xAException;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "recover");
                    throw throwable;
                }
            }
            Trace.exit(this, "recover");
            return xidArray2;
        }
        Object var9_15 = null;
        if (!Trace.isOn) return xidArray;
        Trace.exit(this, "recover");
        return xidArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "isSameRM");
                    }
                    if (this.debugXA) {
                        System.out.println(this + " isSameRM()");
                    }
                    if (this.closed) {
                        String string = MQException.getNLSMsg(115);
                        XAException xAException = new XAException(string);
                        xAException.errorCode = -6;
                        throw xAException;
                    }
                    if (xAResource instanceof MQXAResource) {
                        bl2 = this.qmgrName.equals(((MQXAResource)xAResource).qmgrName);
                        Object var5_6 = null;
                        if (!Trace.isOn) return bl2;
                        break block6;
                    }
                    bl = false;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "isSameRM");
                    throw throwable;
                }
            }
            Trace.exit(this, "isSameRM");
            return bl2;
        }
        Object var5_7 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "isSameRM");
        return bl;
    }

    public void setDebugXA(boolean bl) {
        this.debugXA = bl;
    }

    public String getResourceString() {
        return this.qmgrName;
    }

    static Exception createXAException(int n, String string) {
        XAException xAException = new XAException(string);
        xAException.errorCode = n;
        return xAException;
    }

    private static synchronized int getNextRMID() {
        return nextRMID++;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }
}

