/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolServicesEvent;
import com.ibm.mq.MQPoolServicesEventListener;
import com.ibm.mq.ManagedConnectionStore;
import com.ibm.mq.PoolScavenger;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

public final class MQSimpleConnectionManager
implements MQConnectionManager {
    private static final String sccsid = "javabase/com/ibm/mq/MQSimpleConnectionManager.java, java, j5306, j5306-11-050701  03/12/11 10:41:00 @(#) 1.8.1.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManagedConnectionStore mcs = new ManagedConnectionStore();
    private PoolScavenger scavenger = new PoolScavenger();
    private Vector ownedSMCs = new Vector();
    private boolean active = false;
    private int mode = 0;
    private MQPoolServices poolServices = new MQPoolServices();
    private PSAdapter adapter = new PSAdapter();
    private int maxCons = 0;
    private int gestating = 0;
    public static final int MODE_AUTO = 0;
    public static final int MODE_ACTIVE = 1;
    public static final int MODE_INACTIVE = 2;

    public MQSimpleConnectionManager() {
        this.poolServices.addMQPoolServicesEventListener(this.adapter);
    }

    public Object allocateConnection(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        block15: {
            String string = "allocateConnection";
            Trace.entry(this, string);
            StoredManagedConnection storedManagedConnection = null;
            object = null;
            boolean bl = true;
            while (bl) {
                storedManagedConnection = this.mcs.chooseOne(mQManagedConnectionFactory, connectionRequestInfo);
                if (storedManagedConnection != null && storedManagedConnection.mqManCon != null) {
                    try {
                        object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
                        break;
                    }
                    catch (ResourceException resourceException) {
                        storedManagedConnection.destroy();
                        continue;
                    }
                }
                bl = false;
            }
            if (!bl) {
                int n;
                if (this.maxCons > 0 && (n = 1 + this.currentSize() + this.gestating - this.maxCons) > 0) {
                    Trace.trace(this, "Scavenger asked to lose " + n + " connections");
                    this.scavenger.destroyNext(n);
                }
                storedManagedConnection = null;
                if (this.maxCons == 0 || this.maxCons > this.currentSize() + this.gestating) {
                    ++this.gestating;
                    try {
                        try {
                            storedManagedConnection = new StoredManagedConnection(mQManagedConnectionFactory, connectionRequestInfo, this.mcs, this.scavenger, this);
                            MQSimpleConnectionManager mQSimpleConnectionManager = this;
                            synchronized (mQSimpleConnectionManager) {
                                storedManagedConnection.initializePoolActive(this.active);
                            }
                            object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
                        }
                        catch (ResourceException resourceException) {
                            if (storedManagedConnection != null) {
                                storedManagedConnection.destroy();
                            }
                            Trace.exit(this, string);
                            throw resourceException;
                        }
                        Object var10_12 = null;
                        --this.gestating;
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        --this.gestating;
                        throw throwable;
                    }
                }
                Trace.exit(this, string);
                throw new ResourceException(string);
            }
        }
        Trace.exit(this, "allocateConnection");
        return object;
    }

    public synchronized void setActive(int n) {
        Trace.entry(this, "setActive");
        if (n != 0 && n != 1 && n != 2) {
            Trace.exit(this, "setActive (via exception)");
            throw new IllegalArgumentException();
        }
        this.mode = n;
        switch (n) {
            case 0: {
                if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                    this._setActive(true);
                } else {
                    this._setActive(false);
                }
                this.poolServices.addMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 1: {
                this._setActive(true);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 2: {
                this._setActive(false);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
            }
        }
        Trace.exit(this, "setActive");
    }

    public int getActive() {
        return this.mode;
    }

    public void setTimeout(long l) {
        if (l < 0L) {
            Trace.trace(2, this, "setTimeout called with timeout < 0");
            throw new IllegalArgumentException();
        }
        this.scavenger.setTimeout(l);
    }

    public long getTimeout() {
        return this.scavenger.getTimeout();
    }

    public void setMaxUnusedConnections(int n) {
        if (n < 0) {
            Trace.trace(2, this, "setHighThreshold called with thresdhold < 0");
            throw new IllegalArgumentException();
        }
        this.scavenger.setMaxUnusedConnections(n);
    }

    public void setHighThreshold(int n) {
        if (n < 0) {
            Trace.trace(2, this, "setHighThreshold called with thresdhold < 0");
            throw new IllegalArgumentException();
        }
        this.scavenger.setMaxUnusedConnections(n);
    }

    public int getMaxUnusedConnections() {
        return this.scavenger.getMaxUnusedConnections();
    }

    public int getHighThreshold() {
        return this.scavenger.getMaxUnusedConnections();
    }

    void _setActive(boolean bl) {
        Enumeration enumeration;
        Vector vector;
        Trace.entry(this, "_setActive");
        MQSimpleConnectionManager mQSimpleConnectionManager = this;
        synchronized (mQSimpleConnectionManager) {
            this.active = bl;
            boolean bl2 = false;
            vector = (Vector)this.ownedSMCs.clone();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                StoredManagedConnection storedManagedConnection = (StoredManagedConnection)enumeration.nextElement();
                storedManagedConnection.poolActive(bl);
            }
            if (bl) {
                this.scavenger.start();
            } else {
                this.scavenger.quit();
            }
        }
        if (!bl) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                StoredManagedConnection storedManagedConnection = (StoredManagedConnection)enumeration.nextElement();
                storedManagedConnection.destroyIfMarked();
            }
        }
        Trace.exit(this, "_setActive");
    }

    void addStoredManagedConnection(StoredManagedConnection storedManagedConnection) {
        this.ownedSMCs.addElement(storedManagedConnection);
    }

    void removeStoredManagedConnection(StoredManagedConnection storedManagedConnection) {
        this.ownedSMCs.removeElement(storedManagedConnection);
    }

    private int currentSize() {
        return this.ownedSMCs.size();
    }

    private int inPool() {
        return this.scavenger.inPool();
    }

    public void setMaxConnections(int n) throws IllegalArgumentException {
        String string = "setMaxConnections";
        Trace.entry(this, string);
        if (n < 0) {
            Trace.exit(this, string);
            throw new IllegalArgumentException();
        }
        int n2 = this.currentSize();
        this.maxCons = n;
        int n3 = this.inPool();
        int n4 = 0;
        if (n < n2 - n3) {
            n4 = n2 - n3;
        } else if (n < n2) {
            n4 = n2 - n;
        }
        this.scavenger.destroyNext(n4);
        Trace.exit(this, string);
    }

    public int getMaxConnections() {
        return this.maxCons;
    }

    synchronized void _tokenSetChanged(MQPoolServicesEvent mQPoolServicesEvent) {
        if (this.mode == 0) {
            if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                if (!this.active) {
                    this._setActive(true);
                }
            } else if (this.active) {
                this._setActive(false);
            }
        }
    }

    private class PSAdapter
    implements MQPoolServicesEventListener {
        private PSAdapter() {
        }

        public void tokenAdded(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }

        public void tokenRemoved(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }

        public void defaultConnectionManagerChanged(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }
    }
}

