/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BindingsConnectionRequestInfo;
import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQBindingsManagedConnectionFactory;
import com.ibm.mq.MQBindingsManagedConnectionFactoryJ11;
import com.ibm.mq.MQClientManagedConnectionFactory;
import com.ibm.mq.MQClientManagedConnectionFactoryJ11;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQJDConnectionRequestInfo;
import com.ibm.mq.MQJDManagedConnectionFactory;
import com.ibm.mq.MQJDManagedConnectionFactoryJ11;
import com.ibm.mq.MQMD;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQSESSIONClient;
import com.ibm.mq.MQSESSIONServer;
import com.ibm.mq.Pint;
import com.ibm.mq.Pthrowable;
import com.ibm.mqservices.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.resource.spi.ConnectionRequestInfo;
import javax.sql.XAConnection;

public abstract class MQSESSION {
    private static final String sccsid = "javabase/com/ibm/mq/MQSESSION.java, java, j5306, j5306-11-050701 04/06/08 17:27:07 @(#) 1.61.1.3";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1997, 2004. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String clsName = "MQSESSION";
    private static final String LIBVERSION = "05";
    protected MQManagedConnectionJ11 mqManCon = null;
    protected static final int ENC_ASCII = 1;
    protected static final int ENC_EBCDIC = 2;
    protected static boolean zSeries = false;
    protected static boolean iSeries = false;
    protected boolean authenticateBindings = false;
    private static String libraryName;
    private static final Object libNameLock;
    private static final int CHARINITARRAYSIZE = 100;
    private static char[] charInitArray;

    protected abstract void MQCLOSE(int var1, Pint var2, int var3, Pint var4, Pint var5);

    protected abstract void MQCONN(String var1, Pint var2, Pint var3, Pint var4, Pthrowable var5);

    protected abstract void MQDISC(Pint var1, Pint var2, Pint var3);

    protected abstract void MQGET(int var1, int var2, MQMD var3, MQGetMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8, Pint var9);

    protected abstract void MQGET(int var1, int var2, MQMsg2 var3, MQGetMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8, Pint var9);

    protected abstract void MQINQ(int var1, int var2, int var3, int[] var4, int var5, int[] var6, int var7, byte[] var8, Pint var9, Pint var10);

    protected abstract String MQINQ(int var1, int var2, int var3, int var4, Pint var5, Pint var6);

    protected abstract void MQOPEN(int var1, MQOD var2, int var3, Pint var4, Pint var5, Pint var6);

    protected abstract void MQPUT(int var1, int var2, MQMD var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQPUT(int var1, int var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQPUT1(int var1, MQOD var2, MQMD var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQPUT1(int var1, MQOD var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void MQSET(int var1, int var2, int var3, int[] var4, int var5, int[] var6, int var7, byte[] var8, Pint var9, Pint var10);

    protected abstract void MQSET(int var1, int var2, int var3, String var4, int var5, Pint var6, Pint var7);

    protected abstract void MQCONNX(String var1, int var2, Pint var3, Pint var4, Pint var5, Pthrowable var6);

    protected abstract void MQBACK(int var1, Pint var2, Pint var3);

    protected abstract void MQBEGIN(int var1, Pint var2, Pint var3);

    protected abstract void MQCMIT(int var1, Pint var2, Pint var3);

    protected abstract void spiConnect(String var1, int var2, Pint var3, Pint var4, Pint var5, Pthrowable var6) throws MQException;

    protected abstract boolean spiSupportsDeferred();

    protected abstract void spiDefPut(int var1, int var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, byte[] var6, Pint var7, Pint var8);

    protected abstract void spiDefActivate(int var1, byte[] var2, Pint var3, Pint var4);

    protected abstract void spiDefCancel(int var1, byte[] var2, Pint var3, Pint var4);

    protected abstract boolean spiSupportsInherited();

    protected abstract void spiAsyncCmit(int var1, Pint var2, Pint var3);

    protected void spiBatchedGet(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions, int n3, byte[] byArray, Pint pint, Pint pint2, Pint pint3) throws MQException {
        this.MQGET(n, n2, mQMsg2, mQGetMessageOptions, n3, byArray, pint, pint2, pint3);
    }

    protected abstract void spiGet(int var1, int var2, MQMsg2 var3, MQGetMessageOptions var4, int var5, int var6, byte[] var7, Pint var8, Pint var9, Pint var10) throws MQException;

    protected abstract void spiPut(int var1, int var2, MQMsg2 var3, MQPutMessageOptions var4, int var5, int var6, byte[] var7, Pint var8, Pint var9);

    protected boolean authenticate(int n, String string, String string2, Pint pint, Pint pint2) {
        pint.x = 0;
        pint2.x = 0;
        return true;
    }

    protected int getMaxMessageSizeForBatch() {
        return 0;
    }

    protected abstract void setThreadAccess(String var1, Boolean var2) throws MQException;

    protected abstract void resolveV2Support(int var1, int var2, Pint var3, Pint var4);

    protected abstract boolean supportsV2Structures(int var1);

    final void honourRRS(int n, Pint pint, Pint pint2) {
        Trace.entry(clsName, "honourRRS");
        if (zSeries) {
            if (!MQSESSION.getLibraryName().equals("wmqjrrs")) {
                Trace.trace(1, clsName, "honourRRS called outside WebSphere!");
                pint.x = 2;
                pint2.x = 2012;
            } else {
                this.honourRRSInternal(n, pint, pint2);
            }
        } else {
            pint.x = 2;
            pint2.x = 2012;
            Trace.trace(1, clsName, "honourRRS called outside OS/390!");
        }
        Trace.exit(clsName, "honourRRS");
    }

    protected abstract void honourRRSInternal(int var1, Pint var2, Pint var3);

    static MQSESSION getSession(MQManagedConnectionJ11 mQManagedConnectionJ11) throws MQException {
        MQSESSION mQSESSION = null;
        boolean bl = false;
        String string = mQManagedConnectionJ11.getStringProperty("transport");
        try {
            String string2 = mQManagedConnectionJ11.getStringProperty("hostname", "");
            if (string.equals("MQSeries Bindings") || string.equals("MQSeries") && string2.equals("")) {
                mQSESSION = MQSESSIONServer.getMQSESSION();
                if (zSeries && bl) {
                    mQSESSION.setAuthenticateBindings(true);
                } else {
                    mQSESSION.mqManCon = mQManagedConnectionJ11;
                }
            }
        }
        catch (Exception exception) {
            Trace.trace(1, clsName, "getSESSION exception: " + exception);
            System.err.println(exception);
        }
        if (mQSESSION == null && string.equals("MQJD")) {
            mQSESSION = new com.ibm.mq.mqjd.MQSESSION();
            mQSESSION.mqManCon = mQManagedConnectionJ11;
        }
        if (mQSESSION == null && (!zSeries || string.equals("MQSeries Client") && MQEnvironment.forceAllowClientConnection())) {
            mQSESSION = new MQSESSIONClient();
            mQSESSION.mqManCon = mQManagedConnectionJ11;
        }
        if (mQSESSION == null) {
            Trace.exit(clsName, "getSession - via exception");
            throw new MQException(2, 2012, "static method in MQSESSION");
        }
        mQSESSION.setThreadAccess(mQManagedConnectionJ11.getStringProperty("Thread access"), (Boolean)mQManagedConnectionJ11.getProperty("Thread affinity"));
        return mQSESSION;
    }

    static final MQManagedConnectionFactory getMQManagedConnectionFactory(String string, String string2, Hashtable hashtable, boolean bl) throws MQException {
        if (string.equals("MQSeries Bindings")) {
            if (bl) {
                return new MQBindingsManagedConnectionFactoryJ11(string2, hashtable);
            }
            return new MQBindingsManagedConnectionFactory(string2, hashtable);
        }
        if (string.equals("MQSeries Client")) {
            if (bl) {
                return new MQClientManagedConnectionFactoryJ11(string2, hashtable);
            }
            return new MQClientManagedConnectionFactory(string2, hashtable);
        }
        if (string.equals("MQJD")) {
            if (bl) {
                return new MQJDManagedConnectionFactoryJ11(string2, hashtable);
            }
            return new MQJDManagedConnectionFactory(string2, hashtable);
        }
        throw new MQException(2, 2012, "static method in MQSESSION");
    }

    static final ConnectionRequestInfo getConnectionRequestInfo(String string, Hashtable hashtable) throws MQException {
        if (string.equals("MQSeries Bindings")) {
            return new BindingsConnectionRequestInfo(hashtable);
        }
        if (string.equals("MQSeries Client") && (!zSeries || MQEnvironment.forceAllowClientConnection())) {
            return new ClientConnectionRequestInfo(hashtable);
        }
        if (string.equals("MQJD")) {
            return new MQJDConnectionRequestInfo(hashtable);
        }
        throw new MQException(2, 2012, "static method in MQSESSION");
    }

    protected static final String getLibraryName() {
        String string = "";
        Trace.entry(clsName, "getLibraryName");
        if (iSeries) {
            string = "mqjbnd05";
            Trace.exit(clsName, "getLibraryName");
            return string;
        }
        if (zSeries) {
            return MQSESSION.get390LibraryName();
        }
        string = "mqjbnd05";
        Trace.exit(clsName, "getLibraryName");
        return string;
    }

    private static native String adapter_detect();

    protected static final String get390LibraryName() {
        Object object = libNameLock;
        synchronized (object) {
            if (libraryName == null) {
                String string;
                int n = 0;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            System.loadLibrary("wmqjbind");
                            return null;
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.websphere.ServerType");
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                if (string2 != null) {
                    Trace.trace(3, "getLibraryName", "WebSphere detected - com.ibm.websphere.ServerType is " + string2 + "");
                    n = 2;
                } else {
                    string = MQSESSION.adapter_detect();
                    if (string.equals("wmqjcics")) {
                        Trace.trace(3, "getLibraryName", "CICS detected");
                        n = 1;
                    } else {
                        Trace.trace(3, "getLibraryName", "Neither CICS nor WebSphere detected");
                        n = 0;
                    }
                }
                string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty("com.ibm.mq.adapter");
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                if (string == null) {
                    switch (n) {
                        case 0: {
                            libraryName = "wmqjbatch";
                            break;
                        }
                        case 1: {
                            libraryName = "wmqjcics";
                            break;
                        }
                        case 2: {
                            libraryName = "wmqjrrs";
                        }
                    }
                } else {
                    Trace.trace(3, "getLibraryName", "com.ibm.mq.adapter is " + string);
                    string = string.trim().toLowerCase();
                    if (string.equals("batch")) {
                        if (n == 0 || n == 2) {
                            libraryName = "wmqjbatch";
                        }
                    } else if (string.equals("cics")) {
                        if (n == 1) {
                            libraryName = "wmqjcics";
                        }
                    } else if (string.equals("rrs") && (n == 0 || n == 2)) {
                        libraryName = "wmqjrrs";
                    }
                }
                if (libraryName == null) {
                    Error error = new Error("com.ibm.mq.adapter set to '" + string + "', which is invalid.");
                    Trace.trace(3, "getLibraryName", "Invalid com.ibm.mq.adapter for this environment");
                    Trace.exit(clsName, "getLibraryName (via Error)");
                    throw error;
                }
            }
        }
        Trace.trace(3, "get390LibraryName", libraryName);
        Trace.exit(clsName, "get390LibraryName");
        return libraryName;
    }

    public static final String getLibraryPath() {
        String string = "";
        Trace.entry(clsName, "getLibraryPath");
        if (iSeries) {
            string = "/QSYS.LIB/QMQMJAVA.LIB/";
            Trace.exit(clsName, "getLibraryPath");
            return string;
        }
        if (zSeries) {
            Trace.trace(clsName, "path '" + string + "'");
            Trace.exit(clsName, "getLibraryPath");
            return string;
        }
        Trace.trace(clsName, "path '" + string + "'");
        Trace.exit(clsName, "getLibraryPath");
        return string;
    }

    public static final void loadLib(String string) {
        if (iSeries) {
            Trace.entry(clsName, "loadLib (iSeries)");
            String string2 = string.toUpperCase() + ".SRVPGM";
            Trace.trace(clsName, "  Load this library: '" + string2 + "'");
            System.load(string2);
        } else {
            Trace.entry(clsName, "loadLib");
            Trace.trace(clsName, "  Load this library: '" + string + "'");
            System.loadLibrary(string);
        }
        Trace.exit(clsName, "loadLib");
    }

    protected static final int getDefaultCCSID() {
        if (zSeries) {
            Trace.trace(3, "getDefaultCCSID", "500");
            return 500;
        }
        Trace.trace(3, "getDefaultCCSID", "819");
        return 819;
    }

    protected int getCharEncoding() {
        if (iSeries || zSeries) {
            Trace.trace(3, "getCharEncoding", "ENC_EBCDIC");
            return 2;
        }
        Trace.trace(3, "getCharEncoding", "ENC_ASCII");
        return 1;
    }

    public boolean distributionListCapable(int n) {
        if (zSeries) {
            Trace.trace(3, "distributionListCapable", "false");
            return false;
        }
        Trace.entry(this, "distributionListCapable");
        Trace.exit(this, "distributionListCapable");
        return true;
    }

    protected static final String getProductPrefix() {
        if (zSeries) {
            Trace.trace(3, "getProductPrefix", "CSQ");
            return "CSQ";
        }
        Trace.trace(3, "getProductPrefix", "AMQ");
        return "AMQ";
    }

    protected static final GregorianCalendar getInquireCalendar() {
        if (zSeries) {
            Trace.trace(3, "getInquireCalendar", "GMT");
            return new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return new GregorianCalendar();
    }

    protected static final boolean backoutOnImplicitDisc() {
        if (zSeries) {
            Trace.trace(3, "backoutOnImplicitDisc", "false");
            return false;
        }
        Trace.trace(3, "backoutOnImplicitDisc", "true");
        return true;
    }

    public static String setStringToLength(String string, int n) {
        Trace.entry(clsName, "setStringToLength");
        String string2 = null;
        if (string != null && string.length() == n) {
            Trace.exit(clsName, "setStringToLength");
            return string;
        }
        if (string == null) {
            if (n <= 100) {
                string2 = new String(charInitArray, 0, n);
            } else {
                StringBuffer stringBuffer = new StringBuffer(n);
                int n2 = n;
                while (n2 > 0) {
                    if (n2 > 100) {
                        stringBuffer.append(charInitArray);
                    } else {
                        stringBuffer.append(charInitArray, 0, n2);
                    }
                    n2 -= 100;
                }
                string2 = stringBuffer.toString();
            }
        } else if (string.length() > n) {
            try {
                string2 = string.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                Trace.trace(1, clsName, "setStringToLength - index error");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.ensureCapacity(n);
            int n3 = n - string.length();
            while (n3 > 0) {
                if (n3 > 100) {
                    stringBuffer.append(charInitArray);
                } else {
                    stringBuffer.append(charInitArray, 0, n3);
                }
                n3 -= 100;
            }
            string2 = stringBuffer.toString();
        }
        Trace.exit(clsName, "setStringToLength");
        return string2;
    }

    public void XAREGISTER(XAConnection xAConnection) throws MQException, SQLException, Exception {
        throw new MQException(2, 2012, this);
    }

    public void deregisterResource(XAConnection xAConnection) throws Exception {
        throw new MQException(2, 2012, this);
    }

    protected int getConnectionCCSID() {
        return MQSESSION.getDefaultCCSID();
    }

    public boolean getAuthenticateBindings() {
        return this.authenticateBindings;
    }

    public void setAuthenticateBindings(boolean bl) {
        this.authenticateBindings = bl;
    }

    protected void updateDestinationCounts(MQPutMessageOptions mQPutMessageOptions, Pint pint, Pint pint2) {
        if (zSeries) {
            if (pint.x == 2) {
                mQPutMessageOptions.knownDestCount = 0;
                mQPutMessageOptions.unknownDestCount = 0;
                mQPutMessageOptions.invalidDestCount = 1;
            } else {
                mQPutMessageOptions.knownDestCount = 0;
                mQPutMessageOptions.unknownDestCount = 1;
                mQPutMessageOptions.invalidDestCount = 0;
            }
        }
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("os.name");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string.equals("OS/390") || string.equals("z/OS")) {
            zSeries = true;
        } else if (string.equals("OS/400") || string.equals("OS400")) {
            iSeries = true;
        }
        libraryName = null;
        libNameLock = new Object();
        charInitArray = null;
        charInitArray = new char[100];
        int n = 0;
        while (n < 100) {
            MQSESSION.charInitArray[n] = 32;
            ++n;
        }
    }
}

