/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMessageTracker;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQResponseRecord;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class MQPutMessageOptions {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQPutMessageOptions.java, java, j5306, j5306-11-050701  03/12/11 10:37:57";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final byte[] pmo_bytes = new byte[128];
    private boolean noReadBack = false;
    public int options = 0;
    public int contextReferenceHandle = 0;
    public MQQueue contextReference = null;
    public String resolvedQueueName = "";
    public String resolvedQueueManagerName = "";
    public int knownDestCount = 0;
    public int unknownDestCount = 0;
    public int invalidDestCount = 0;
    public int recordFields = 0;
    protected static final int sizeofMQPutMessageOptionsv1 = 128;
    protected static final int sizeofMQPutMessageOptionsv2 = 152;
    protected int version = 1;
    protected int putMsgRecordFields = 0;
    protected int distListLength = 1;
    protected MQMessageTracker[] putMessageRecords = null;
    protected MQResponseRecord[] responseRecords = null;
    private MQDistributionListItem[] ditems = null;

    public MQPutMessageOptions() {
        if (Trace.isOn) {
            Trace.entry(this, "MQPutMessageOptions constructor");
            Trace.trace(2, this, sccsid);
        }
        this.pmo_bytes[0] = 80;
        this.pmo_bytes[1] = 77;
        this.pmo_bytes[2] = 79;
        this.pmo_bytes[3] = 32;
        this.pmo_bytes[7] = 1;
        this.pmo_bytes[12] = -1;
        this.pmo_bytes[13] = -1;
        this.pmo_bytes[14] = -1;
        this.pmo_bytes[15] = -1;
        Arrays.fill(this.pmo_bytes, 32, 128, (byte)32);
        if (Trace.isOn) {
            Trace.exit(this, "MQPutMessageOptions constructor");
        }
    }

    public MQPutMessageOptions(boolean bl) {
        this();
        if (bl) {
            Trace.trace(2, this, "Setting MQGMO noReadBack option");
            this.noReadBack = true;
        }
    }

    protected final void version2(MQDistributionListItem[] mQDistributionListItemArray) {
        this.version = 2;
        this.pmo_bytes[7] = 2;
        this.putMessageRecords = mQDistributionListItemArray;
        this.ditems = mQDistributionListItemArray;
        this.responseRecords = new MQResponseRecord[mQDistributionListItemArray.length];
        int n = 0;
        while (n < mQDistributionListItemArray.length) {
            this.responseRecords[n] = new MQResponseRecord();
            ++n;
        }
        this.putMsgRecordFields = this.recordFields;
        this.distListLength = mQDistributionListItemArray.length;
    }

    protected final int sizeOfMQPutMessageOptions() {
        if (this.version == 1) {
            return 128;
        }
        int n = 0;
        int n2 = 0;
        if (this.putMessageRecords != null) {
            n2 = this.putMessageRecords.length;
        }
        return 152 + (n += n2 * (MQMessageTracker.sizeof(this.putMsgRecordFields) + MQResponseRecord.sizeOfMQResponseRecord));
    }

    protected final byte[] getV1Bytes() {
        this.pmo_bytes[8] = (byte)(this.options >>> 24 & 0xFF);
        this.pmo_bytes[9] = (byte)(this.options >>> 16 & 0xFF);
        this.pmo_bytes[10] = (byte)(this.options >>> 8 & 0xFF);
        this.pmo_bytes[11] = (byte)(this.options >>> 0 & 0xFF);
        this.pmo_bytes[16] = (byte)(this.contextReferenceHandle >>> 24 & 0xFF);
        this.pmo_bytes[17] = (byte)(this.contextReferenceHandle >>> 16 & 0xFF);
        this.pmo_bytes[18] = (byte)(this.contextReferenceHandle >>> 8 & 0xFF);
        this.pmo_bytes[19] = (byte)(this.contextReferenceHandle >>> 0 & 0xFF);
        this.pmo_bytes[28] = (byte)(this.invalidDestCount >>> 24 & 0xFF);
        this.pmo_bytes[29] = (byte)(this.invalidDestCount >>> 16 & 0xFF);
        this.pmo_bytes[30] = (byte)(this.invalidDestCount >>> 8 & 0xFF);
        this.pmo_bytes[31] = (byte)(this.invalidDestCount >>> 0 & 0xFF);
        return this.pmo_bytes;
    }

    public final DataOutputStream writeTo(DataOutputStream dataOutputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeTo");
        }
        dataOutputStream.write(this.getV1Bytes(), 0, 128);
        if (this.version > 1) {
            int n = 0;
            if (this.putMessageRecords != null) {
                n = this.putMessageRecords.length;
            }
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(this.putMsgRecordFields);
            if (this.putMsgRecordFields == 0) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(152);
            }
            dataOutputStream.writeInt(152 + n * MQMessageTracker.sizeof(this.putMsgRecordFields));
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            int n2 = 0;
            while (n2 < n) {
                if (this.putMessageRecords[n2] == null) {
                    Trace.exit(this, "writeTo (via exception)");
                    throw new MQInternalException(2, 2159, 25);
                }
                dataOutputStream = this.putMessageRecords[n2].writeTo(dataOutputStream, this.putMsgRecordFields);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeLong(0L);
                ++n3;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "writeTo");
        }
        return dataOutputStream;
    }

    public final DataInputStream readFrom(DataInputStream dataInputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "readFrom");
        }
        if (dataInputStream.available() < 128) {
            Trace.exit(this, "readFrom (via exception)");
            throw new MQInternalException(2, 2195, 84);
        }
        dataInputStream.skipBytes(4);
        this.version = dataInputStream.readInt();
        if (this.noReadBack && this.version == 1) {
            dataInputStream.skipBytes(120);
            Trace.exit(this, "readFrom - optimised return");
            return dataInputStream;
        }
        this.options = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        this.contextReferenceHandle = dataInputStream.readInt();
        this.knownDestCount = dataInputStream.readInt();
        this.unknownDestCount = dataInputStream.readInt();
        this.invalidDestCount = dataInputStream.readInt();
        byte[] byArray = new byte[48];
        dataInputStream.read(byArray, 0, 48);
        this.resolvedQueueName = MQEnvironment.stringFromBytes(byArray);
        byte[] byArray2 = new byte[48];
        dataInputStream.read(byArray2, 0, 48);
        this.resolvedQueueManagerName = MQEnvironment.stringFromBytes(byArray2);
        if (this.version > 1) {
            int n = dataInputStream.readInt();
            this.putMsgRecordFields = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            dataInputStream.skipBytes(8);
            if (n2 > 152) {
                dataInputStream.skipBytes(n2 - 152);
            }
            int n4 = MQMessageTracker.sizeof(this.putMsgRecordFields);
            int n5 = 0;
            while (n5 < n) {
                dataInputStream = this.putMessageRecords[n5].readFrom(dataInputStream, this.putMsgRecordFields);
                ++n5;
            }
            if (n2 != 0 && n3 - n2 > n * n4) {
                dataInputStream.skipBytes(n3 - n2 - n * n4);
            }
            int n6 = 0;
            if (this.responseRecords != null) {
                n6 = this.responseRecords.length;
            }
            int n7 = 0;
            while (n7 < n) {
                dataInputStream = this.responseRecords[n7].readFrom(dataInputStream);
                ++n7;
            }
            if (this.ditems != null) {
                int n8 = 0;
                while (n8 < this.ditems.length) {
                    this.ditems[n8].completionCode = this.responseRecords[n8].completionCode;
                    this.ditems[n8].reasonCode = this.responseRecords[n8].reason;
                    ++n8;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "readFrom");
        }
        return dataInputStream;
    }

    public void updateDistributionListItems() {
        if (Trace.isOn) {
            Trace.entry(this, "updateDistributionListItems");
        }
        if (this.ditems != null && this.version > 1) {
            int n = 0;
            while (n < this.ditems.length) {
                this.ditems[n].completionCode = this.responseRecords[n].completionCode;
                this.ditems[n].reasonCode = this.responseRecords[n].reason;
                ++n;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "updateDistributionListItems");
        }
    }

    protected int getNumResponseRecords() {
        int n = 0;
        if (this.responseRecords != null) {
            n = this.responseRecords.length;
        }
        return n;
    }
}

