/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mqservices.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

public class MQObjectInputStream
extends ObjectInputStream {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQObjectInputStream.java, jms, j5306, j5306-12-050907 1.2.1.2 05/08/25 11:25:58";
    ClassLoader cl = null;

    protected MQObjectInputStream(ClassLoader classLoader) throws IOException, SecurityException {
        this.cl = classLoader;
    }

    public MQObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        this.cl = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class<?> clazz;
        if (Trace.isOn) {
            Trace.entry(this, "resolveClass");
            Trace.trace(this, "v = " + objectStreamClass.toString());
        }
        try {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Attempting to resolve class " + objectStreamClass.getName() + " using forName() with the classloader " + this.cl);
                }
                clazz = Class.forName(objectStreamClass.getName(), true, this.cl);
                Object var6_4 = null;
                if (!Trace.isOn) return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class<?> clazz2;
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "forName() failed to resolve the class " + objectStreamClass.getName() + " with the classloader " + this.cl);
                        Trace.trace(this, "exception : " + classNotFoundException.toString());
                        Trace.trace(this, "Now attempting to resolve class " + objectStreamClass.getName() + " using forName() with the classloader " + this.getClass().getClassLoader());
                    }
                    clazz2 = Class.forName(objectStreamClass.getName());
                    Object var6_5 = null;
                    if (!Trace.isOn) return clazz2;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "forName() failed to resolve the class " + objectStreamClass.getName() + " with the classloader " + this.getClass().getClassLoader());
                        Trace.trace(this, "exception : " + classNotFoundException2.toString());
                        Trace.trace(this, "Attempting to resolve class " + objectStreamClass.getName() + " using loadClass() with the classloader  " + this.cl);
                    }
                    Class<?> clazz3 = this.cl.loadClass(objectStreamClass.getName());
                    Object var6_6 = null;
                    if (!Trace.isOn) return clazz3;
                    Trace.exit(this, "resolveClass");
                    return clazz3;
                }
                Trace.exit(this, "resolveClass");
                return clazz2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "resolveClass");
            throw throwable;
        }
        Trace.exit(this, "resolveClass");
        return clazz;
    }
}

