/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MQMessageTracker {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQMessageTracker.java, java, j5306, j5306-11-050701  03/12/11 10:37:29";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public byte[] messageId = new byte[24];
    public byte[] correlationId = new byte[24];
    public byte[] groupId = new byte[24];
    public int feedback = 0;
    public byte[] accountingToken = new byte[32];

    public MQMessageTracker() {
        Trace.entry(this, "MQMessageTracker constructor");
        Trace.trace(2, this, sccsid);
        Trace.exit(this, "MQMessageTracker constructor");
    }

    protected static final int sizeof(int n) {
        Trace.entry("MQMessageTracker", "sizeof");
        int n2 = 0;
        if (n == 0) {
            n2 = 0;
        } else {
            if ((n & 1) != 0) {
                n2 += 24;
            }
            if ((n & 2) != 0) {
                n2 += 24;
            }
            if ((n & 4) != 0) {
                n2 += 24;
            }
            if ((n & 8) != 0) {
                n2 += 4;
            }
            if ((n & 0x10) != 0) {
                n2 += 32;
            }
        }
        if (Trace.isOn()) {
            Trace.trace(2, "MQMessageTracker", "flags = " + n + " size = " + n2);
            Trace.exit("MQMessageTracker", "sizeof");
        }
        return n2;
    }

    protected final DataOutputStream writeTo(DataOutputStream dataOutputStream, int n) throws IOException, MQException {
        Trace.entry(this, "writeTo");
        if (n != 0) {
            if ((n & 1) != 0) {
                this.messageId = this.setArrayToLength(this.messageId, 24);
                dataOutputStream.write(this.messageId, 0, 24);
            }
            if ((n & 2) != 0) {
                this.correlationId = this.setArrayToLength(this.correlationId, 24);
                dataOutputStream.write(this.correlationId, 0, 24);
            }
            if ((n & 4) != 0) {
                this.groupId = this.setArrayToLength(this.groupId, 24);
                dataOutputStream.write(this.groupId, 0, 24);
            }
            if ((n & 8) != 0) {
                dataOutputStream.writeInt(this.feedback);
            }
            if ((n & 0x10) != 0) {
                this.accountingToken = this.setArrayToLength(this.accountingToken, 32);
                dataOutputStream.write(this.accountingToken, 0, 32);
            }
        }
        Trace.exit(this, "writeTo");
        return dataOutputStream;
    }

    protected final DataInputStream readFrom(DataInputStream dataInputStream, int n) throws IOException, MQException {
        Trace.entry(this, "readFrom");
        System.arraycopy(MQC.MQMI_NONE, 0, this.messageId, 0, 24);
        System.arraycopy(MQC.MQCI_NONE, 0, this.correlationId, 0, 24);
        System.arraycopy(MQC.MQGI_NONE, 0, this.groupId, 0, 24);
        this.feedback = 0;
        System.arraycopy(MQC.MQACT_NONE, 0, this.accountingToken, 0, 32);
        if (n != 0) {
            if ((n & 1) != 0) {
                this.messageId = this.setArrayToLength(this.messageId, 24);
                dataInputStream.read(this.messageId, 0, 24);
            }
            if ((n & 2) != 0) {
                this.correlationId = this.setArrayToLength(this.correlationId, 24);
                dataInputStream.read(this.correlationId, 0, 24);
            }
            if ((n & 4) != 0) {
                this.groupId = this.setArrayToLength(this.groupId, 24);
                dataInputStream.read(this.groupId, 0, 24);
            }
            if ((n & 8) != 0) {
                this.feedback = dataInputStream.readInt();
            }
            if ((n & 0x10) != 0) {
                this.accountingToken = this.setArrayToLength(this.accountingToken, 32);
                dataInputStream.read(this.accountingToken, 0, 32);
            }
        }
        Trace.exit(this, "readFrom");
        return dataInputStream;
    }

    protected final byte[] setArrayToLength(byte[] byArray, int n) throws MQException {
        byte[] byArray2;
        try {
            byArray2 = new byte[n];
            if (byArray == null || byArray.length == 0) {
                int n2 = 0;
                while (n2 < n) {
                    byArray2[n2] = 0;
                    ++n2;
                }
            } else if (byArray.length < n) {
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                int n3 = byArray.length;
                while (n3 < n) {
                    byArray2[n3] = 0;
                    ++n3;
                }
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
        }
        catch (Exception exception) {
            throw new MQInternalException(2, 2195, 26);
        }
        return byArray2;
    }
}

