/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mqservices.Trace;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnectionMetaData;

class MQManagedConnectionMetaData
implements ManagedConnectionMetaData {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQManagedConnectionMetaData.java, java, j5306, j5306-11-050701  03/12/11 10:40:25";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MQManagedConnectionJ11 mancon;
    private static final int NLS_PRODUCT_NAME = 109;
    private static final int NLS_COMMAND_LEVEL = 110;
    private final String productName = MQException.getNLSMsg(109);
    private int commandLevel = 0;
    private String productVersion = null;
    private Object productVersionLock = new Object();
    private final int maxConnections = 0;
    private String userName = null;

    MQManagedConnectionMetaData(MQManagedConnectionJ11 mQManagedConnectionJ11) {
        Trace.entry(this, "MQManagedConnectionMetaData constructor");
        this.mancon = mQManagedConnectionJ11;
        this.userName = mQManagedConnectionJ11.getStringProperty("userID");
        if (this.userName == null) {
            this.userName = "";
        }
        Trace.exit(this, "MQManagedConnectionMetaData constructor");
    }

    public String getEISProductName() throws ResourceException {
        Trace.entry(this, "getEISProductName");
        if (this.mancon.isConnected()) {
            Trace.exit(this, "getEISProductName");
            return this.productName;
        }
        Trace.exit(this, "getEISProductName (via exception)");
        String string = MQException.getNLSMsg(106);
        throw new IllegalStateException(string);
    }

    public String getEISProductVersion() throws ResourceException {
        Trace.entry(this, "getEISProductVersion");
        if (!this.mancon.isConnected()) {
            Trace.exit(this, "getEISProductVersion (via exception)");
            String string = MQException.getNLSMsg(106);
            throw new IllegalStateException(string);
        }
        if (this.productVersion == null) {
            int n = this.getCommandLevel();
            this.productVersion = MQException.getNLSMsg(110, "" + n);
        }
        Trace.exit(this, "getEISProductVersion");
        return this.productVersion;
    }

    public int getMaxConnections() throws ResourceException {
        Trace.entry(this, "getMaxConnections");
        if (this.mancon.isConnected()) {
            Trace.exit(this, "getMaxConnections");
            return 0;
        }
        Trace.exit(this, "getEISProductName (via exception)");
        String string = MQException.getNLSMsg(106);
        throw new IllegalStateException(string);
    }

    public String getUserName() throws ResourceException {
        Trace.entry(this, "getUserName");
        if (this.mancon.isConnected()) {
            Trace.exit(this, "getUserName");
            return this.userName;
        }
        Trace.exit(this, "getUserName (via exception)");
        String string = MQException.getNLSMsg(106);
        throw new IllegalStateException(string);
    }

    public int getCommandLevel() throws ResourceException {
        Trace.entry(this, "getCommandLevel");
        if (!this.mancon.isConnected()) {
            Trace.exit(this, "getCommandLevel (via exception)");
            String string = MQException.getNLSMsg(106);
            throw new IllegalStateException(string);
        }
        int n = 0;
        Object object = this.productVersionLock;
        synchronized (object) {
            if (this.commandLevel == 0) {
                MQSESSION mQSESSION = this.mancon.getMQSESSION();
                Pint pint = this.mancon.getHConn();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                Pint pint4 = new Pint();
                Trace.trace(2, this, "Determining Queue Manager command level");
                MQOD mQOD = new MQOD();
                mQOD.ObjectType = 5;
                mQSESSION.MQOPEN(pint.x, mQOD, 32, pint2, pint3, pint4);
                if (pint3.x != 0) {
                    MQException mQException = new MQException(pint3.x, pint4.x, this);
                    ResourceException resourceException = mQException.getResourceException();
                    Trace.exit(this, "getCommandLevel (via exception)");
                    throw resourceException;
                }
                int[] nArray = new int[]{31};
                int[] nArray2 = new int[1];
                byte[] byArray = new byte[1];
                mQSESSION.MQINQ(pint.x, pint2.x, 1, nArray, 1, nArray2, 0, byArray, pint3, pint4);
                if (pint3.x != 0) {
                    MQException mQException = new MQException(pint3.x, pint4.x, this);
                    ResourceException resourceException = mQException.getResourceException();
                    mQSESSION.MQCLOSE(pint.x, pint2, 0, pint3, pint4);
                    Trace.exit(this, "getCommandLevel (via exception)");
                    throw resourceException;
                }
                n = nArray2[0];
                mQSESSION.MQCLOSE(pint.x, pint2, 0, pint3, pint4);
                if (pint3.x != 0) {
                    MQException mQException = new MQException(pint3.x, pint4.x, this);
                    ResourceException resourceException = mQException.getResourceException();
                    Trace.exit(this, "getCommandLevel (via exception)");
                    throw resourceException;
                }
            }
        }
        Trace.exit(this, "getCommandLevel");
        this.commandLevel = n;
        return this.commandLevel;
    }
}

