/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQConnectionEventListener;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionMetaData;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mq.Pthrowable;
import com.ibm.mqservices.Trace;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.transaction.xa.XAResource;

public class MQManagedConnectionJ11 {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQManagedConnectionJ11.java, java, j5306, j5306-11-050701  03/12/11 10:40:19";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String qmgrName;
    private MQSESSION session;
    private Pint Hconn = new Pint();
    private boolean connected = false;
    private Hashtable properties = new Hashtable();
    private boolean reusable = true;
    Vector qmgrs = new Vector();
    ConnectionRequestInfo initialCxReqInf;
    MQManagedConnectionFactory initialMCF;
    PrintWriter logWriter;
    ManagedConnectionMetaData metaData = null;
    Vector mqListeners = new Vector();
    boolean allowErrorEvents = false;

    MQManagedConnectionJ11(String string, Hashtable hashtable, ConnectionRequestInfo connectionRequestInfo, MQManagedConnectionFactory mQManagedConnectionFactory) throws MQException {
        Trace.entry(this, "MQManagedConnection constructor");
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Pthrowable pthrowable = new Pthrowable();
        boolean bl = false;
        if (string == null) {
            string = "";
        }
        this.qmgrName = string;
        if (hashtable == null || connectionRequestInfo == null || mQManagedConnectionFactory == null) {
            Trace.exit(this, "MQManagedConnection constructor (via exception)");
            throw new NullPointerException();
        }
        this.initialCxReqInf = connectionRequestInfo;
        this.initialMCF = (MQManagedConnectionFactory)mQManagedConnectionFactory.clone();
        this.properties = hashtable;
        this.connected = false;
        this.session = MQSESSION.getSession(this);
        int n = this.getIntegerProperty("connectOptions");
        boolean bl2 = "SPI_ENABLE".equals(this.getStringProperty("SPI"));
        if (bl2) {
            this.session.spiConnect(string, n, this.Hconn, pint, pint2, pthrowable);
        }
        if (!bl2 || pint.x != 0) {
            if (n == 0) {
                this.session.MQCONN(string, this.Hconn, pint, pint2, pthrowable);
            } else {
                this.session.MQCONNX(string, n, this.Hconn, pint, pint2, pthrowable);
            }
        }
        if (pint.x != 0 || pint2.x != 0) {
            MQException mQException;
            this.session = null;
            Trace.exit(this, "MQManagedConnection constructor (via exception)");
            if (pthrowable != null && pthrowable.e != null && pthrowable.e instanceof MQException) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Flowing exception message from pCause");
                }
                mQException = new MQException(pint.x, pint2.x, (Object)this, (MQException)pthrowable.e);
            } else {
                if (Trace.isOn) {
                    Trace.trace(2, this, "It was not possible to flow the exception message");
                }
                mQException = new MQException(pint.x, pint2.x, this);
            }
            if (pthrowable != null && pthrowable.e != null) {
                mQException.initCause(pthrowable.e);
            }
            throw mQException;
        }
        this.connected = true;
        Trace.exit(this, "MQManagedConnection constructor");
    }

    public void addMQConnectionEventListener(MQConnectionEventListener mQConnectionEventListener) {
        Trace.entry(this, "addMQConnectionEventListener");
        if (mQConnectionEventListener == null) {
            Trace.exit(this, "addMQConnectionEventListener (via exception)");
            throw new NullPointerException();
        }
        this.mqListeners.addElement(mQConnectionEventListener);
        Trace.exit(this, "addMQConnectionEventListener");
    }

    public void removeMQConnectionEventListener(MQConnectionEventListener mQConnectionEventListener) {
        Trace.entry(this, "removeMQConnectionEventListener");
        if (mQConnectionEventListener == null) {
            Trace.exit(this, "addMQConnectionEventListener (via exception)");
            throw new NullPointerException();
        }
        this.mqListeners.removeElement(mQConnectionEventListener);
        Trace.exit(this, "removeMQConnectionEventListener");
    }

    public synchronized Object getConnection(ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        MQQueueManager mQQueueManager;
        Trace.entry(this, "getConnection");
        if (!this.connected) {
            String string = MQException.getNLSMsg(106);
            IllegalStateException illegalStateException = new IllegalStateException(string);
            Trace.exit(this, "getConnection (via exception)");
            throw illegalStateException;
        }
        if (!this.reusable) {
            String string = MQException.getNLSMsg(108);
            IllegalStateException illegalStateException = new IllegalStateException(string);
            Trace.exit(this, "getConnection (via exception)");
            throw illegalStateException;
        }
        if (!this.isSuitable(connectionRequestInfo, this.initialMCF)) {
            String string = MQException.getNLSMsg(105);
            IllegalStateException illegalStateException = new IllegalStateException(string);
            Trace.exit(this, "getConnection (via exception)");
            throw illegalStateException;
        }
        try {
            mQQueueManager = new MQQueueManager(this);
        }
        catch (MQException mQException) {
            ResourceException resourceException = mQException.getResourceException();
            Trace.exit(this, "getConnection (via exception)");
            throw resourceException;
        }
        this.qmgrs.addElement(mQQueueManager);
        this.allowErrorEvents = true;
        Trace.exit(this, "getConnection");
        return mQQueueManager;
    }

    public synchronized void destroy() throws ResourceException {
        MQQueueManager mQQueueManager;
        Object object;
        Trace.entry(this, "destroy");
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        this.allowErrorEvents = false;
        Enumeration enumeration = this.qmgrs.elements();
        while (enumeration.hasMoreElements()) {
            object = (MQQueueManager)enumeration.nextElement();
            mQQueueManager = object;
            synchronized (mQQueueManager) {
                if (((MQQueueManager)object).isConnected()) {
                    ((MQQueueManager)object).cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        if (!this.connected) {
            Trace.exit(this, "destroy (via exception)");
            object = MQException.getNLSMsg(106);
            throw new IllegalStateException((String)object);
        }
        this.session.MQDISC(this.Hconn, pint, pint2);
        this.connected = false;
        this.session = null;
        if (pint.x != 0 || pint2.x != 0) {
            object = new MQException(pint.x, pint2.x, this);
            mQQueueManager = ((MQException)object).getResourceException();
            Trace.exit(this, "destory (via exception)");
            throw mQQueueManager;
        }
        Trace.exit(this, "destroy");
    }

    public synchronized void cleanup() throws ResourceException {
        Object object;
        Object object2;
        Trace.entry(this, "cleanup()");
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        this.allowErrorEvents = false;
        Enumeration enumeration = this.qmgrs.elements();
        while (enumeration.hasMoreElements()) {
            object = object2 = (MQQueueManager)enumeration.nextElement();
            synchronized (object) {
                if (((MQQueueManager)object2).isConnected()) {
                    ((MQQueueManager)object2).cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        object2 = this.getStringProperty("Thread access");
        if (object2 != null && ((String)object2).equals("SINGLE_THREAD")) {
            Trace.trace(2, this, "cleanup attempted on SINGLE_THREAD MQManagedConnection");
            Trace.exit(this, "cleanup (via exception)");
            object = MQException.getNLSMsg(108);
            throw new IllegalStateException((String)object);
        }
        if (!this.connected) {
            Trace.exit(this, "cleanup (via exception)");
            object = MQException.getNLSMsg(106);
            throw new IllegalStateException((String)object);
        }
        this.session.MQBACK(this.Hconn.x, pint, pint2);
        if (!this.reusable) {
            Trace.exit(this, "cleanup (via exception)");
            object = MQException.getNLSMsg(108);
            throw new IllegalStateException((String)object);
        }
        if ((pint.x != 0 || pint2.x != 0) && pint2.x != 2012) {
            object = new MQException(pint.x, pint2.x, this);
            ResourceException resourceException = ((MQException)object).getResourceException();
            Trace.exit(this, "cleanup (via exception)");
            throw resourceException;
        }
        Trace.exit(this, "cleanup");
    }

    public void associateConnection(Object object) throws ResourceException {
        Trace.entry(this, "associateConnection - NOT SUPPORTED");
        Trace.exit(this, "assoicateConnection (via exception)");
        String string = MQException.getNLSMsg(107, "associateConnection");
        throw new NotSupportedException(string);
    }

    public XAResource getXAResource() throws ResourceException {
        Trace.entry(this, "getXAResource - NOT SUPPORTED");
        Trace.exit(this, "getXAResource (via exception)");
        String string = MQException.getNLSMsg(107, "getXAResource");
        throw new NotSupportedException(string);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        Trace.entry(this, "getLocalTransaction - NOT SUPPORTED");
        Trace.exit(this, "getLocalTransaction (via exception)");
        String string = MQException.getNLSMsg(107, "getLocalTransaction");
        throw new NotSupportedException(string);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        Trace.entry(this, "getMetaData");
        if (this.metaData == null) {
            MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
            synchronized (mQManagedConnectionJ11) {
                if (this.metaData == null) {
                    this.metaData = new MQManagedConnectionMetaData(this);
                }
            }
        }
        Trace.exit(this, "getMetaData");
        return this.metaData;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    void fireConnectionClosedEvent(MQQueueManager mQQueueManager) {
        Vector vector;
        Trace.entry(this, "fireConnectionClosedEvent");
        this.qmgrs.removeElement(mQQueueManager);
        MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
        synchronized (mQManagedConnectionJ11) {
            vector = (Vector)this.mqListeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQConnectionEventListener mQConnectionEventListener = (MQConnectionEventListener)enumeration.nextElement();
            mQConnectionEventListener.connectionClosed(this, mQQueueManager);
        }
        Trace.exit(this, "fireConnectionClosedEvent");
    }

    void fireConnectionErrorEvent(MQQueueManager mQQueueManager, Exception exception) {
        Trace.entry(this, "fireConnectionErrorEvent");
        if (this.allowErrorEvents) {
            Vector vector;
            MQManagedConnectionJ11 mQManagedConnectionJ11 = this;
            synchronized (mQManagedConnectionJ11) {
                vector = (Vector)this.mqListeners.clone();
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MQConnectionEventListener mQConnectionEventListener = (MQConnectionEventListener)enumeration.nextElement();
                mQConnectionEventListener.connectionErrorOccurred(this, mQQueueManager, exception);
            }
            Trace.exit(this, "fireConnectionErrorEvent");
        }
    }

    protected void finalize() {
        Trace.entry(this, "finalize");
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Enumeration enumeration = this.qmgrs.elements();
        while (enumeration.hasMoreElements()) {
            MQQueueManager mQQueueManager;
            MQQueueManager mQQueueManager2 = mQQueueManager = (MQQueueManager)enumeration.nextElement();
            synchronized (mQQueueManager2) {
                if (mQQueueManager.isConnected()) {
                    mQQueueManager.cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        if (this.connected) {
            Trace.trace(2, this, "implicit disconnect");
            try {
                if (MQSESSION.backoutOnImplicitDisc()) {
                    Trace.trace(2, this, "Backout on implicit disconnect");
                    this.session.MQBACK(this.Hconn.x, pint, pint2);
                    if (pint.x != 0) {
                        if (pint2.x == 2012) {
                            Trace.trace(2, this, "Backout on implicit disconnect not performed due to environment");
                        } else {
                            Trace.trace(2, this, "Backout on implicit disconnect failed");
                            Trace.exit(this, "finalize (via exception)");
                            throw new MQException(pint.x, pint2.x, this);
                        }
                    }
                }
                this.destroy();
            }
            catch (MQException mQException) {
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        Trace.exit(this, "finalize");
    }

    boolean isConnected() {
        return this.connected;
    }

    MQSESSION getMQSESSION() {
        return this.session;
    }

    Pint getHConn() {
        return this.Hconn;
    }

    String getQmgrName() {
        return this.qmgrName;
    }

    Object getProperty(Object object) {
        return this.properties.get(object);
    }

    int getIntegerProperty(Object object) {
        return this.getIntegerProperty(object, 0);
    }

    int getIntegerProperty(Object object, int n) {
        Object object2 = this.getProperty(object);
        int n2 = object2 != null && object2 instanceof Integer ? (Integer)object2 : n;
        return n2;
    }

    public String getStringProperty(Object object) {
        return this.getStringProperty(object, null);
    }

    String getStringProperty(Object object, String string) {
        Object object2 = this.getProperty(object);
        String string2 = object2 != null && object2 instanceof String ? (String)object2 : string;
        return string2;
    }

    String getStringProperty(Object object, String string, int n) {
        return MQSESSION.setStringToLength(this.getStringProperty(object, string), n);
    }

    void setNotReusable() {
        this.reusable = false;
        Trace.trace(2, this, "MQManagedConnection set to be non-reusable");
    }

    boolean isReusable() {
        return this.reusable;
    }

    boolean isSuitable(ConnectionRequestInfo connectionRequestInfo, MQManagedConnectionFactory mQManagedConnectionFactory) {
        if (this.connected && this.reusable && this.initialMCF.equals(mQManagedConnectionFactory)) {
            if (connectionRequestInfo instanceof ClientConnectionRequestInfo) {
                return ((ClientConnectionRequestInfo)connectionRequestInfo).isSuitable(this);
            }
            return this.initialCxReqInf.equals((Object)connectionRequestInfo);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean authenticate(Pint pint, Pint pint2) throws MQException {
        boolean bl;
        try {
            try {
                Trace.entry(this, "authenticate");
                MQSESSION mQSESSION = MQSESSION.getSession(this);
                MQManagedConnectionMetaData mQManagedConnectionMetaData = (MQManagedConnectionMetaData)this.getMetaData();
                int n = mQManagedConnectionMetaData.getCommandLevel();
                if (n >= 531) {
                    mQSESSION.setAuthenticateBindings(true);
                } else {
                    mQSESSION.setAuthenticateBindings(false);
                }
                String string = this.getStringProperty("userID", "");
                String string2 = this.getStringProperty("password", "");
                pint.x = 0;
                if (null != string && !string.trim().equals("")) {
                    mQSESSION.authenticate(this.Hconn.x, string, string2, pint, pint2);
                }
                if (pint.x == 2) {
                    Trace.trace(this, "Failed to authenticate userId and Password: rc=" + pint2.x);
                    MQException mQException = new MQException(pint.x, pint2.x, this);
                    throw mQException;
                }
                bl = true;
                Object var10_12 = null;
            }
            catch (Exception exception) {
                if (exception instanceof MQException) {
                    throw (MQException)exception;
                }
                MQException mQException = new MQException(2, 2102, this);
                throw mQException;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            Trace.exit(this, "authenticate");
            throw throwable;
        }
        Trace.exit(this, "authenticate");
        return bl;
    }
}

