/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQQueueManager;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;

public class MQManagedConnection
extends MQManagedConnectionJ11
implements ManagedConnection {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQManagedConnection.java, java, j5306, j5306-11-050701  03/12/11 10:39:13";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Vector listeners = new Vector();

    MQManagedConnection(String string, Hashtable hashtable, ConnectionRequestInfo connectionRequestInfo, MQManagedConnectionFactory mQManagedConnectionFactory) throws MQException {
        super(string, hashtable, connectionRequestInfo, mQManagedConnectionFactory);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return this.getConnection(connectionRequestInfo);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        Trace.entry(this, "addConnectionEventListener");
        if (connectionEventListener == null) {
            Trace.exit(this, "addMQConnectionEventListener (via exception)");
            throw new NullPointerException();
        }
        this.listeners.addElement(connectionEventListener);
        Trace.exit(this, "addConnectionEventListener");
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        Trace.entry(this, "removeConnectionEventListener");
        if (connectionEventListener == null) {
            Trace.exit(this, "addMQConnectionEventListener (via exception)");
            throw new NullPointerException();
        }
        this.listeners.removeElement(connectionEventListener);
        Trace.exit(this, "removeConnectionEventListener");
    }

    void fireConnectionClosedEvent(MQQueueManager mQQueueManager) {
        Vector vector;
        Trace.entry(this, "fireConnectionClosedEvent");
        super.fireConnectionClosedEvent(mQQueueManager);
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)mQQueueManager);
        MQManagedConnection mQManagedConnection = this;
        synchronized (mQManagedConnection) {
            vector = (Vector)this.listeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
            connectionEventListener.connectionClosed(connectionEvent);
        }
        Trace.exit(this, "fireConnectionClosedEvent");
    }

    void fireConnectionErrorEvent(MQQueueManager mQQueueManager, Exception exception) {
        Trace.entry(this, "fireConnectionErrorEvent");
        super.fireConnectionErrorEvent(mQQueueManager, exception);
        if (this.allowErrorEvents) {
            Vector vector;
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
            if (mQQueueManager != null) {
                connectionEvent.setConnectionHandle((Object)mQQueueManager);
            }
            MQManagedConnection mQManagedConnection = this;
            synchronized (mQManagedConnection) {
                vector = (Vector)this.listeners.clone();
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)enumeration.nextElement();
                connectionEventListener.connectionErrorOccurred(connectionEvent);
            }
        }
        Trace.exit(this, "fireConnectionErrorEvent");
    }
}

