/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQC;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQChannelExit;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQExternalReceiveExit;
import com.ibm.mq.MQExternalSecurityExit;
import com.ibm.mq.MQExternalSendExit;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.Pint;
import com.ibm.mq.SSLHelper;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.LinkedList;

final class MQInternalCommunications {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQInternalCommunications.java, java, j5306, j5306-11-050701 1.82.1.8 05/04/27 07:17:20";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1997, 2002   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int TSH_EYECATCHER = 1414744096;
    protected static final int TSH_EBCDIC_EYECATCHER = -471676864;
    protected static final int TST_INITIAL_DATA = 1;
    protected static final int TST_STATUS_DATA = 5;
    protected static final int TST_SECURITY_DATA = 6;
    protected static final int TST_USERID_DATA = 8;
    protected static final int TST_HEARTBEAT = 9;
    protected static final int TST_MQCONN = 129;
    protected static final int TST_MQOPEN = 131;
    protected static final int TST_MQCLOSE = 132;
    protected static final int TST_MQGET = 133;
    protected static final int TST_MQPUT = 134;
    protected static final int TST_MQPUT1 = 135;
    protected static final int TST_MQSET = 136;
    protected static final int TST_MQINQ = 137;
    protected static final int TST_MQCMIT = 138;
    protected static final int TST_MQBACK = 139;
    protected static final int TST_SPI = 140;
    protected static final int TST_MQCONN_REPLY = 145;
    protected static final int TST_MQOPEN_REPLY = 147;
    protected static final int TST_MQCLOSE_REPLY = 148;
    protected static final int TST_MQGET_REPLY = 149;
    protected static final int TST_MQPUT_REPLY = 150;
    protected static final int TST_MQPUT1_REPLY = 151;
    protected static final int TST_MQSET_REPLY = 152;
    protected static final int TST_MQINQ_REPLY = 153;
    protected static final int TST_MQCMIT_REPLY = 154;
    protected static final int TST_MQBACK_REPLY = 155;
    protected static final int TST_SPI_REPLY = 156;
    protected static final int TST_XA_START = 161;
    protected static final int TST_XA_END = 162;
    protected static final int TST_XA_OPEN = 163;
    protected static final int TST_XA_CLOSE = 164;
    protected static final int TST_XA_PREPARE = 165;
    protected static final int TST_XA_COMMIT = 166;
    protected static final int TST_XA_ROLLBACK = 167;
    protected static final int TST_XA_FORGET = 168;
    protected static final int TST_XA_RECOVER = 169;
    protected static final int TST_XA_COMPLETE = 170;
    protected static final int TST_XA_START_REPLY = 177;
    protected static final int TST_XA_END_REPLY = 178;
    protected static final int TST_XA_OPEN_REPLY = 179;
    protected static final int TST_XA_CLOSE_REPLY = 180;
    protected static final int TST_XA_PREPARE_REPLY = 181;
    protected static final int TST_XA_COMMIT_REPLY = 182;
    protected static final int TST_XA_ROLLBACK_REPLY = 183;
    protected static final int TST_XA_FORGET_REPLY = 184;
    protected static final int TST_XA_RECOVER_REPLY = 185;
    protected static final int TST_XA_COMPLETE_REPLY = 186;
    protected static final int TST_SPI_CAN_WAIT = 193;
    protected static final int TST_SPI_CAN_WAIT_REPLY = 209;
    protected static final int TCF_CONFIRM_REQUEST = 1;
    protected static final int TCF_ERROR = 2;
    protected static final int TCF_REQUEST_CLOSE = 4;
    protected static final int TCF_CLOSE_CHANNEL = 8;
    protected static final int TCF_FIRST = 16;
    protected static final int TCF_LAST = 32;
    protected static final int TSH_HEADER_SIZE = 28;
    protected static final int API_HEADER_SIZE = 16;
    protected static final int ICF_MSG_SEQ_NO = 1;
    protected static final int ICF_SPLIT_MESSAGES = 4;
    protected static final int ICF_MQREQUEST = 32;
    protected static final int ICF_RUNTIME_APP = 128;
    protected static final int ICF_SVRCONN_SECURITY = 64;
    protected static final int ICF_DIST_LIST_CAPABLE = 1;
    protected static final int ICF_XAREQUEST = 16;
    protected static final int ICF_XARUNTIME_APP = 32;
    protected static final int ICF_CANCEL_WAIT = 64;
    protected static final int ICF_DEFERRED_MQI = 128;
    protected static final int ICF_SPI_REQUEST = 64;
    protected static final int IEF_CCSID_NOT_SUPPORTED = 1;
    protected static final int IEF_ENCODING_INVALID = 2;
    protected static final int IEF_MAX_TRANSMISSION_SIZE = 4;
    protected static final int IEF_FAP_LEVEL = 8;
    protected static final int IEF_MAX_MSG_SIZE = 16;
    protected static final int IEF_MAX_MSG_PER_BATCH = 32;
    protected static final int IEF_SEQ_WRAP_VALUE = 64;
    private Socket connection;
    private DataInputStream serverIn;
    private DataOutputStream serverOut;
    protected String qManager;
    protected int handle;
    protected int ccsid;
    protected Thread thread;
    protected String hostname;
    protected String channel;
    protected String userID;
    protected String password;
    protected String longUserID;
    protected byte[] userSecurityID;
    protected int port;
    protected MQManagedConnectionJ11 mqManCon;
    protected MQSendExit sendExit = null;
    protected MQReceiveExit receiveExit = null;
    protected MQSecurityExit securityExit = null;
    protected int maxMessageSize = 0x6400000;
    private int maxTransmissionSize = 32766;
    private int IDFlags = 37;
    private int sequenceWrapValue = 999999999;
    private int maxMessagesPerBatch = 50;
    private boolean serverSecurityExit = false;
    protected int fapLevel = 255;
    private int IDFlags2 = 1;
    private int heartbeatInterval = 1;
    protected boolean distListCapable = true;
    protected int transmissionLength = 0;
    protected int socketTimeOutPrimer;
    private int socketTimeOut = this.socketTimeOutPrimer = 120000;
    private int socketResponseTimeout = 60000;
    private int socketGrainTimeout = 10000;
    protected Integer communicationsLock = new Integer(0);
    private boolean exitsInitialised = false;
    private boolean suppressSendExit = false;
    private boolean suppressReceiveExit = false;
    private boolean suppressSecurityExit = false;
    protected MQChannelDefinition channelDefinition = new MQChannelDefinition();
    private MQChannelExit securityExitParms = new MQChannelExit();
    private MQChannelExit sendExitParms = new MQChannelExit();
    private MQChannelExit receiveExitParms = new MQChannelExit();
    private ByteArrayOutputStream sendBytes;
    private DataOutputStream sendData;
    private boolean bitOneOfIDFlags2Set = false;
    private boolean xaRequired = false;
    private boolean shouldAdoptQMgrCcsid = false;
    private boolean qmCcsidKnown = false;
    protected boolean ccsidIsAscii = false;
    private boolean requestSPI = false;
    private String sslCipherSuite;
    public String sslPeername = null;
    public Collection sslCertStores = null;
    public Object sslSocketFactory = null;
    private InetAddress fw_localip = null;
    private int fw_pstart = 0;
    private int fw_pend = 0;

    protected MQInternalCommunications(String string, int n, MQManagedConnectionJ11 mQManagedConnectionJ11) throws MQException {
        Object object;
        Trace.entry(this, "Constructor");
        Trace.trace(1, this, sccsid);
        this.qManager = string;
        this.handle = n;
        this.mqManCon = mQManagedConnectionJ11;
        this.ccsid = this.mqManCon.getIntegerProperty("CCSID", 819);
        this.channel = this.mqManCon.getStringProperty("channel", "", 20);
        this.hostname = this.mqManCon.getStringProperty("hostname", "");
        if (this.hostname.equals("")) {
            this.hostname = "localhost";
        }
        this.password = this.mqManCon.getStringProperty("password", "", 12);
        this.port = this.mqManCon.getIntegerProperty("port", -1);
        if (this.port == -1) {
            this.port = 1414;
        }
        if ((object = this.mqManCon.getProperty("receiveExit")) instanceof MQReceiveExit) {
            this.receiveExit = (MQReceiveExit)object;
        }
        if ((object = this.mqManCon.getProperty("securityExit")) instanceof MQSecurityExit) {
            this.securityExit = (MQSecurityExit)object;
        }
        if ((object = this.mqManCon.getProperty("sendExit")) instanceof MQSendExit) {
            this.sendExit = (MQSendExit)object;
        }
        this.userID = this.mqManCon.getStringProperty("userID", "");
        object = this.mqManCon.getProperty("XAReq");
        if (object instanceof Boolean) {
            this.xaRequired = (Boolean)object;
        }
        if ((object = this.mqManCon.getProperty("Use QM CCSID")) instanceof Boolean) {
            this.shouldAdoptQMgrCcsid = (Boolean)object;
        }
        this.requestSPI = "SPI_ENABLE".equals(mQManagedConnectionJ11.getStringProperty("SPI"));
        this.sslCipherSuite = this.mqManCon.getStringProperty("SSL Cipher Suite");
        this.sslPeername = this.mqManCon.getStringProperty("SSL Peer Name");
        this.sslSocketFactory = this.mqManCon.getProperty("SSL Socket Factory");
        object = this.mqManCon.getProperty("SSL CertStores");
        if (object != null && !(object instanceof Collection)) {
            throw new MQException(2, 2402, (Object)this, 118);
        }
        this.sslCertStores = (Collection)object;
        Object object2 = this.mqManCon.getProperty("FIREWALL_SETTINGS");
        if (object2 != null) {
            this.fw_localip = FWHelper.decodeLocalAddress(object2);
            this.fw_pstart = FWHelper.decodePort(object2, "START_PORT");
            this.fw_pend = FWHelper.decodePort(object2, "END_PORT");
            if (Trace.isOn()) {
                Trace.trace(2, this, "Firewall properties:");
                if (this.fw_localip != null) {
                    Trace.trace(2, this, "  fw_localip: " + this.fw_localip.getHostAddress());
                } else {
                    Trace.trace(2, this, "  fw_localip: null");
                }
                Trace.trace(2, this, "  fw_pstart: " + this.fw_pstart);
                Trace.trace(2, this, "  fw_pend: " + this.fw_pend);
            }
        }
        this.longUserID = MQSESSION.setStringToLength(this.userID, 64);
        this.userID = MQSESSION.setStringToLength(this.userID, 12);
        if (Trace.isOn()) {
            Trace.trace(2, this, "userID = '" + this.userID + "'");
            Trace.trace(2, this, "longUserID = '" + this.longUserID + "'");
        }
        this.userSecurityID = new byte[40];
        this.thread = Thread.currentThread();
        if (Trace.isOn()) {
            Trace.trace(2, this, "Queue Manager = '" + string + "'");
            Trace.trace(2, this, "Connection handle = " + n);
            Trace.trace(2, this, "CCSID = " + this.ccsid);
        }
        this.sendBytes = new ByteArrayOutputStream();
        this.sendData = new DataOutputStream(this.sendBytes);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MQException {
                    MQInternalCommunications.this.createSocketConnection();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (MQException)privilegedActionException.getException();
        }
        try {
            Trace.trace(2, this, "socketGrainTimeout = " + this.socketGrainTimeout);
            this.connection.setSoTimeout(this.socketGrainTimeout);
        }
        catch (SocketException socketException) {
            throw new MQInternalException(2, 2195, 48, "SocketException thrown on setSoTimeOut");
        }
        this.establishChannel();
        try {
            this.socketTimeOut = this.heartbeatInterval == 0 ? 0 : (this.heartbeatInterval < 60 ? this.heartbeatInterval * 2000 : this.heartbeatInterval * 1000 + 60000);
            Trace.trace(2, this, "socketTimeOut :" + this.socketTimeOut);
            if (this.socketTimeOut < this.socketGrainTimeout) {
                this.connection.setSoTimeout(this.socketTimeOut);
            } else {
                this.connection.setSoTimeout(this.socketGrainTimeout);
            }
        }
        catch (SocketException socketException) {
            throw new MQInternalException(2, 2195, 48, "SocketException thrown on setSoTimeOut");
        }
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.tuning.socketResponseTimeout");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (null != string2) {
            try {
                int n2;
                this.socketResponseTimeout = n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.initialiseExits();
        this.suppressSendExit = true;
        this.suppressReceiveExit = true;
        this.sendSecurityFlows();
        this.suppressSendExit = false;
        this.suppressReceiveExit = false;
        this.connectToQueueManager();
        this.ccsidIsAscii = this.isCcsidAscii(this.ccsid);
        Trace.exit(this, "Constructor");
    }

    protected final synchronized void close() {
        Trace.entry(this, "close");
        try {
            try {
                if (this.connection != null) {
                    this.sendStatus(8, 0);
                }
            }
            catch (MQException mQException) {
                Trace.trace(1, this, "MQException during sendStatus");
                Trace.dumpCallStack();
            }
            if (this.exitsInitialised) {
                this.terminateExits();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, this, "IOException during close" + iOException);
            Trace.dumpCallStack();
        }
        Trace.exit(this, "close");
    }

    protected final synchronized void send(int n, int n2, byte[] byArray, byte[] byArray2) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "send");
            Trace.trace(2, this, "TSH type = " + n);
            Trace.trace(3, this, "Control flags = " + n2);
            if (byArray2 != null) {
                Trace.trace(3, this, "API Header follows:");
                Trace.dataTrace(3, this, byArray2);
            }
            if (byArray != null) {
                Trace.trace(4, this, "Message data follows:");
                Trace.dataTrace(4, this, byArray);
            }
        }
        if (this.serverOut == null) {
            Trace.trace(1, this, "Data could not be sent - output stream was null");
            Trace.exit(this, "send (via exception)");
            throw new MQInternalException(2, 2009, 43);
        }
        boolean bl = n >= 129 && n <= 193;
        try {
            int n3 = byArray == null ? 0 : byArray.length;
            int n4 = 28 + n3;
            if (bl) {
                n4 += 16;
            }
            boolean bl2 = true;
            int n5 = n2 | 0x10;
            int n6 = n3;
            int n7 = 0;
            while (bl2 || n6 > 0) {
                int n8;
                int n9;
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Sending data, " + n6 + " bytes of msg data remain");
                }
                this.sendBytes.reset();
                int n10 = 28;
                if (bl && bl2) {
                    n10 += 16;
                }
                if (n7 + (n9 = (n8 = Math.min(n6 + n10, this.maxTransmissionSize)) - n10) >= n3) {
                    n5 |= 0x20;
                    Trace.trace(2, this, "Last segment of message");
                }
                this.sendData = this.writeTSH(this.sendData, n8, n, n5);
                if (bl && bl2) {
                    this.sendData.write(byArray2);
                }
                if (byArray != null) {
                    this.sendData.write(byArray, n7, n9);
                }
                if (this.sendExit != null) {
                    byte[] byArray3 = this.invokeSendExit(this.sendBytes.toByteArray());
                    this.serverOut.write(byArray3);
                } else {
                    this.serverOut.write(this.sendBytes.toByteArray());
                }
                if (bl2) {
                    bl2 = false;
                    n5 -= 16;
                }
                n6 -= n9;
                n7 += n9;
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, this, "IOException occured during send.  The socket connection was\nprobably broken by the other party.");
            Trace.trace(this, iOException.toString());
            Trace.exit(this, "send (via exception)");
            throw new MQInternalException(2, 2009, 44);
        }
        Trace.exit(this, "send");
    }

    protected final synchronized void send(int n, int n2, byte[] byArray, byte[] byArray2, int n3, byte[] byArray3) throws MQException {
        byte[] byArray4 = new byte[]{};
        if (Trace.isOn()) {
            Trace.entry(this, "send");
            Trace.trace(2, this, "TSH type = " + n);
            Trace.trace(3, this, "Control flags = " + n2);
            if (byArray3 != null) {
                Trace.trace(3, this, "API Header follows:");
                Trace.dataTrace(3, this, byArray3);
            }
            if (byArray != null) {
                Trace.trace(4, this, "Message data follows:");
                Trace.dataTrace(4, this, byArray);
            }
        }
        if (this.serverOut == null) {
            Trace.trace(1, this, "Data could not be sent - output stream was null");
            Trace.exit(this, "send (via exception)");
            throw new MQInternalException(2, 2009, 43);
        }
        boolean bl = n >= 129 && n <= 193;
        try {
            int n4 = byArray == null ? 0 : byArray.length + n3;
            int n5 = 28 + n4;
            if (bl) {
                n5 += 16;
            }
            boolean bl2 = true;
            int n6 = n2 | 0x10;
            int n7 = n4;
            int n8 = 0;
            while (bl2 || n7 > 0) {
                int n9;
                int n10;
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Sending data, " + n7 + " bytes of msg data remain");
                }
                this.sendBytes.reset();
                int n11 = 28;
                if (bl && bl2) {
                    n11 += 16;
                }
                if (n8 + (n10 = (n9 = Math.min(n7 + n11, this.maxTransmissionSize)) - n11) >= n4) {
                    n6 |= 0x20;
                    Trace.trace(2, this, "Last segment of message");
                }
                this.sendData = this.writeTSH(this.sendData, n9, n, n6);
                if (bl && bl2) {
                    this.sendData.write(byArray3);
                }
                if (this.sendExit != null) {
                    if (byArray != null) {
                        if (byArray2 == null || n3 == 0) {
                            this.sendData.write(byArray, n8, n10);
                        } else {
                            byte[] byArray5 = new byte[byArray.length + n3];
                            System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
                            System.arraycopy(byArray2, 0, byArray5, byArray.length, n3);
                            this.sendData.write(byArray5, n8, n10);
                        }
                    }
                    Trace.trace(this, "--- PRESEND ---");
                    Trace.dataTrace(4, this, this.sendBytes.toByteArray());
                    byte[] byArray6 = this.invokeSendExit(this.sendBytes.toByteArray());
                    Trace.trace(this, "--- XMITDATA ---");
                    Trace.dataTrace(4, this, byArray6);
                    this.serverOut.write(byArray6);
                } else if (bl2) {
                    this.sendData.write(byArray);
                    byArray4 = this.sendBytes.toByteArray();
                    Trace.dataTrace(4, this, byArray4);
                    this.serverOut.write(byArray4);
                    this.serverOut.write(byArray2, 0, n10 - byArray.length);
                } else {
                    this.serverOut.write(this.sendBytes.toByteArray(), 0, n11);
                    this.serverOut.write(byArray2, n8 - byArray.length, n10);
                }
                if (bl2) {
                    bl2 = false;
                    n6 -= 16;
                }
                n7 -= n10;
                n8 += n10;
            }
        }
        catch (IOException iOException) {
            Trace.trace(1, this, "IOException occured during send.  The socket connection was\nprobably broken by the other party.");
            Trace.trace(this, iOException.toString());
            Trace.exit(this, "send (via exception)");
            throw new MQInternalException(2, 2009, 44);
        }
        Trace.exit(this, "send");
    }

    /*
     * Unable to fully structure code
     */
    protected final synchronized byte[] receiveBytes(Pint var1_1, Pint var2_2, Pint var3_3) throws MQException {
        var5_4 = false;
        var9_5 = new LinkedList<byte[]>();
        var10_6 = 0;
        if (Trace.isOn()) {
            Trace.entry(this, "receiveBytes");
        }
        if (this.serverIn != null) ** GOTO lbl56
        Trace.trace(1, this, "Data could not be received - input stream was null");
        throw new MQInternalException(2, 2009, 45);
lbl-1000:
        // 1 sources

        {
            if (Trace.isOn()) {
                Trace.trace(2, this, "Waiting for data on input stream.");
            }
            try {
                var6_7 = this.timedReadInt(this.socketResponseTimeout);
                if (var6_7 != 1414744096 && var6_7 != -471676864) {
                    if (Trace.isOn()) {
                        Trace.trace(1, this, "Invalid eyecatcher : " + var6_7);
                    }
                    throw new MQInternalException(2, 2195, 46, Integer.toString(var6_7, 16));
                }
            }
            catch (IOException var11_9) {
                if (Trace.isOn()) {
                    Trace.trace(this, var11_9.toString());
                }
                throw new MQInternalException(2, 2195, 48);
            }
            try {
                this.transmissionLength = this.timedReadInt(this.socketResponseTimeout);
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Receiving " + this.transmissionLength + " bytes of data.");
                }
                var7_8 = new byte[this.transmissionLength];
                var7_8[0] = (byte)(var6_7 >>> 24 & 255);
                var7_8[1] = (byte)(var6_7 >>> 16 & 255);
                var7_8[2] = (byte)(var6_7 >>> 8 & 255);
                var7_8[3] = (byte)(var6_7 >>> 0 & 255);
                var7_8[4] = (byte)(this.transmissionLength >>> 24 & 255);
                var7_8[5] = (byte)(this.transmissionLength >>> 16 & 255);
                var7_8[6] = (byte)(this.transmissionLength >>> 8 & 255);
                var7_8[7] = (byte)(this.transmissionLength >>> 0 & 255);
                this.timedReadFully(var7_8, 8, this.transmissionLength - 8, this.socketResponseTimeout);
                var7_8 = this.invokeReceiveExit(var7_8);
                var1_1.x = var7_8[9] & 255;
                var2_2.x = var7_8[10] & 255;
                var3_3.x = var7_8[20] & 255;
                var9_5.add(var7_8);
                var10_6 += var7_8.length - 28;
                var5_4 = true;
                if (var1_1.x >= 145 && var1_1.x <= 156 && (var2_2.x & 32) == 0) {
                    var5_4 = false;
                }
                if (var1_1.x != 9) continue;
                var5_4 = false;
                var9_5.clear();
                var10_6 = 0;
                this.send(9, 0, null, null);
                continue;
            }
            catch (IOException var11_10) {
                if (Trace.isOn()) {
                    Trace.trace(this, var11_10.toString());
                }
                throw new MQInternalException(2, 2195, 48);
            }
lbl56:
            // 3 sources

            ** while (!var5_4)
        }
lbl57:
        // 1 sources

        if (var10_6 > 0) {
            var12_12 = var9_5.size();
            var11_11 = new byte[var10_6];
            var13_13 = 0;
            var14_14 = 0;
            while (var14_14 < var12_12) {
                var15_15 = (byte[])var9_5.removeFirst();
                System.arraycopy(var15_15, 28, var11_11, var13_13, var15_15.length - 28);
                var13_13 += var15_15.length - 28;
                ++var14_14;
            }
        } else {
            var11_11 = new byte[]{};
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "Data received.");
            Trace.trace(4, this, "Received message data follows:");
            Trace.dataTrace(4, this, var11_11);
        }
        if (Trace.isOn()) {
            Trace.exit(this, "receiveBytes");
        }
        return var11_11;
    }

    protected final synchronized DataInputStream receive(Pint pint, Pint pint2, Pint pint3) throws MQException {
        Trace.entry(this, "receive");
        byte[] byArray = null;
        try {
            byArray = this.receiveBytes(pint, pint2, pint3);
        }
        catch (MQInternalException mQInternalException) {
            byArray = new byte[]{};
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        Trace.exit(this, "receive");
        return dataInputStream;
    }

    protected final DataOutputStream writeTSH(DataOutputStream dataOutputStream, int n, int n2, int n3) throws IOException, MQException {
        Trace.entry(this, "writeTSH");
        dataOutputStream.writeInt(1414744096);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(n2);
        dataOutputStream.writeByte(n3);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeInt(273);
        dataOutputStream.writeShort(this.ccsid);
        dataOutputStream.writeShort(0);
        Trace.exit(this, "writeTSH");
        return dataOutputStream;
    }

    protected final DataInputStream readTSH(DataInputStream dataInputStream, Pint pint, Pint pint2, Pint pint3) throws IOException, MQException {
        Trace.entry(this, "readTSH");
        dataInputStream.skipBytes(8);
        dataInputStream.skipBytes(1);
        pint.x = dataInputStream.readUnsignedByte();
        pint2.x = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        dataInputStream.skipBytes(8);
        pint3.x = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(2);
        dataInputStream.skipBytes(2);
        if (Trace.isOn()) {
            Trace.trace(3, this, "Segment type = " + pint.x);
            Trace.trace(3, this, "Control flags = " + pint2.x);
            Trace.trace(3, this, "Encoding = " + pint3.x);
            Trace.exit(this, "readTSH");
        }
        return dataInputStream;
    }

    protected final synchronized void sendStatus(int n, int n2) throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "sendStatus");
            Trace.trace(2, this, "status = " + n);
            Trace.trace(2, this, "errCode = " + n2);
        }
        try {
            if (n2 != 0) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(8);
                dataOutputStream.writeInt(n2);
                this.send(5, n, byteArrayOutputStream.toByteArray(), null);
            } else {
                this.send(5, n, null, null);
            }
        }
        catch (IOException iOException) {
            Trace.exit(this, "sendStatus (via exception)");
            throw new MQInternalException(2, 2195, 49);
        }
        Trace.exit(this, "sendStatus");
    }

    protected final byte[] buildAPIHeader(int n, int n2, int n3, int n4) throws MQException {
        Trace.entry(this, "buildAPIHeader");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n + 16 + 28);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n4);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Trace.trace(4, this, "API header follows:");
            Trace.dataTrace(4, this, byArray);
            Trace.exit(this, "buildAPIHeader");
            return byArray;
        }
        catch (IOException iOException) {
            Trace.exit(this, "buildAPIHeader (via exception)");
            throw new MQInternalException(2, 2071, 50);
        }
    }

    private final void createSocketConnection() throws MQException {
        if (Trace.isOn()) {
            Trace.entry(this, "createSocketConnection");
            Trace.trace(1, this, "Connecting to " + this.hostname + " on port " + this.port);
        }
        try {
            boolean bl;
            boolean bl2 = bl = this.sslCipherSuite != null && !this.sslCipherSuite.equals("");
            if (this.fw_pstart != 0 || this.fw_localip != null) {
                FWHelper.debug("Creating a firewall socket");
                FWHelper.debug("fw_localip: " + this.fw_localip);
                FWHelper.debug("fw_pstart: " + this.fw_pstart);
                FWHelper.debug("fw_pend: " + this.fw_pend);
                int n = 0;
                n = FWHelper.getLastTried(this.fw_localip, this.fw_pstart, this.fw_pend);
                if (n != 0) {
                    if (++n > this.fw_pend) {
                        n = this.fw_pstart;
                    }
                } else {
                    n = this.fw_pstart;
                }
                int n2 = n > this.fw_pstart && n <= this.fw_pend ? n : this.fw_pstart;
                this.connection = bl ? SSLHelper.createExplicitSSLSocket(this.hostname, this.port, this.sslCipherSuite, this.sslPeername, this.sslCertStores, this.sslSocketFactory, this, this.fw_localip, this.fw_pstart, this.fw_pend, n2) : this.createExplicitSocketConnection(this.hostname, this.port, this.fw_localip, this.fw_pstart, this.fw_pend, n2);
                FWHelper.setLastTried(this.fw_localip, this.fw_pstart, this.fw_pend, this.connection.getLocalPort());
                if (Trace.isOn) {
                    Trace.trace(1, this, "Socket created on local port " + this.connection.getLocalPort());
                }
            } else {
                FWHelper.debug("Creating a standard socket");
                this.connection = bl ? SSLHelper.createSSLSocket(this.hostname, this.port, this.sslCipherSuite, this.sslPeername, this.sslCertStores, this.sslSocketFactory, this) : new Socket(this.hostname, this.port);
            }
            this.connection.setTcpNoDelay(true);
            try {
                this.connection.setSendBufferSize(32768);
                this.connection.setReceiveBufferSize(32768);
            }
            catch (Exception exception) {
                Trace.trace(this, "failed to increase socket buffer sizes: " + exception);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace(1, this, "Hostname invalid!");
            Trace.exit(this, "createSocketConnection (via exception)");
            throw new MQInternalException(2, 2059, 51, this.hostname);
        }
        catch (IOException iOException) {
            Trace.trace(1, this, "Exception creating socket " + iOException);
            Trace.exit(this, "createSocketConnection (via exception)");
            throw new MQInternalException(2, 2059, 52);
        }
        catch (SecurityException securityException) {
            Trace.trace(1, this, "SecurityException " + securityException + "\nConsult user guide for information on host access rules.");
            Trace.exit(this, "createSocketConnection (via exception)");
            throw new MQInternalException(2, 2059, 53, this.hostname);
        }
        try {
            this.serverIn = new DataInputStream(new BufferedInputStream(this.connection.getInputStream()));
            this.serverOut = new DataOutputStream(this.connection.getOutputStream());
        }
        catch (IOException iOException) {
            Trace.trace(1, this, "Exception accessing socket streams " + iOException);
            Trace.exit(this, "createSocketConnection (via exception)");
            throw new MQInternalException(2, 2059, 54);
        }
        Trace.exit(this, "createSocketConnection");
    }

    private final void establishChannel() throws MQException {
        Trace.entry(this, "establishChannel");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (this.fapLevel > 2) {
                if (this.xaRequired) {
                    Trace.trace(this, "setting ICF_XAREQUEST");
                    this.IDFlags2 |= 0x10;
                    if (MQEnvironment.runningInWS()) {
                        Trace.trace(this, "setting ICF_XARUNTIME_APP");
                        this.IDFlags2 |= 0x20;
                    }
                }
                if (this.requestSPI) {
                    Trace.trace(this, "setting ICF_SPI_REQUEST");
                    this.IDFlags2 |= 0x40;
                }
            }
            this.buildInitialData(dataOutputStream, this.fapLevel);
            Trace.trace(2, this, "sending TST_INITIAL_DATA");
            this.send(1, 1, byteArrayOutputStream.toByteArray(), null);
            Pint pint = new Pint(0);
            Pint pint2 = new Pint(0);
            Pint pint3 = new Pint(0);
            Trace.trace(2, this, "receiving server reply");
            DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
            if ((pint2.x & 8) != 0) {
                int n = 2;
                int n2 = 2009;
                int n3 = 0;
                if ((pint2.x & 2) != 0) {
                    if (this.transmissionLength > 28) {
                        dataInputStream.skipBytes(4);
                        n3 = dataInputStream.readInt();
                    } else {
                        n3 = 22;
                    }
                }
                Trace.trace(1, this, "server sent TCF_CLOSE_CHANNEL on initial connect:err code = " + n3);
                this.close();
                Trace.exit(this, "establishChannel (via exception)");
                throw new MQInternalException(n, n2, 57, "" + n2);
            }
            switch (pint.x) {
                case 5: {
                    if ((pint2.x & 2) != 0) {
                        dataInputStream.skipBytes(4);
                        int n = dataInputStream.readInt();
                        Trace.trace(1, this, "Server sent TST_STATUS_DATA on initial connect, err code = " + n);
                        this.close();
                        Trace.exit(this, "establishChannel (via exception)");
                        throw new MQInternalException(2, 2059, 58, "" + n);
                    }
                    Trace.trace(1, this, "Bind to server was successful");
                    break;
                }
                case 1: {
                    boolean bl;
                    Trace.trace(1, this, "Server sent TST_INITIAL_DATA");
                    boolean bl2 = bl = (pint2.x & 2) != 0;
                    if (!this.parseInitialDataResponse(dataInputStream, bl)) {
                        this.renegotiateConnectionParameters();
                        break;
                    }
                    Trace.trace(1, this, "Bind to server was successful");
                    break;
                }
                default: {
                    Trace.trace(1, this, "Unexpected segment type sent from server: " + pint.x);
                    this.close();
                    Trace.exit(this, "establishChannel (via exception)");
                    throw new MQInternalException(2, 2195, 59);
                }
            }
        }
        catch (IOException iOException) {
            this.close();
            Trace.exit(this, "establishChannel (via IOException)");
            throw new MQInternalException(2, 2195, 60);
        }
        Trace.exit(this, "establishChannel");
    }

    private final boolean parseInitialDataResponse(DataInputStream dataInputStream, boolean bl) throws IOException, MQException {
        Trace.entry(this, "parseInitialDataResponse");
        byte by = 0;
        byte by2 = 0;
        dataInputStream.skipBytes(4);
        this.fapLevel = dataInputStream.readByte();
        this.IDFlags = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        byte by4 = dataInputStream.readByte();
        dataInputStream.skipBytes(2);
        short s = dataInputStream.readShort();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(20);
        if (this.fapLevel >= 4) {
            by2 = dataInputStream.readByte();
            by = dataInputStream.readByte();
            if (this.shouldAdoptQMgrCcsid && !this.qmCcsidKnown) {
                short s2 = dataInputStream.readShort();
                if (this.isValidJavaCcsid(s2)) {
                    if (this.isCcsidAscii(s2)) {
                        this.ccsid = s2;
                        this.qmCcsidKnown = true;
                        if (Trace.isOn()) {
                            Trace.trace(1, this, "Adopting qmgr CCSID of " + this.ccsid);
                        }
                    } else {
                        this.shouldAdoptQMgrCcsid = false;
                        if (Trace.isOn()) {
                            Trace.trace(1, this, "Failed to adopt qmgr CCSID (" + s2 + ") - not ASCII.");
                        }
                    }
                } else {
                    this.shouldAdoptQMgrCcsid = false;
                    if (Trace.isOn()) {
                        Trace.trace(1, this, "Cannot adopt qmgr CCSID (" + s2 + ")");
                    }
                }
            } else {
                dataInputStream.skipBytes(2);
            }
            dataInputStream.skipBytes(48);
            this.heartbeatInterval = dataInputStream.readInt();
        }
        if (this.xaRequired && bl && (by2 & 0x10) == 0) {
            Trace.trace(this, "TCF_ERROR flag set, XAREQUEST cleared. Closing.");
            this.close();
            Trace.exit(this, "parseInitialDataResponse (via exception)");
            throw new MQException(2, 2012, (Object)this, 119);
        }
        if ((by & 0x10) != 0) {
            Trace.trace(this, "server doesn't support XA client");
            this.close();
            Trace.exit(this, "parseInitialDataResponse (via exception)");
            throw new MQException(2, 2012, (Object)this, 119);
        }
        if (MQEnvironment.runningInWS() && ((by & 0x20) != 0 || (this.IDFlags2 & 0x20) == 0)) {
            Trace.trace(this, "Cannot set ourselves as an XA Runtime app. Attempting XA operations later should fail");
            this.IDFlags2 &= 0xFFFFFFDF;
        }
        if (this.requestSPI && ((by & 0x40) != 0 || (by2 & 0x40) == 0)) {
            Trace.trace(this, "server does not support SPI");
            this.IDFlags2 &= 0xFFFFFFBF;
            this.requestSPI = false;
        }
        if ((by2 & 1) == 0 && this.bitOneOfIDFlags2Set) {
            Trace.trace(4, this, "Server unset IDFlags2 bit one. DistLists unsupported.");
            this.distListCapable = false;
        }
        if ((by3 & 0x40) != 0) {
            this.serverSecurityExit = true;
        }
        if ((by4 & 1) != 0) {
            Trace.trace(1, this, "Remote queue manager cannot support CCSID " + this.ccsid);
            this.close();
            Trace.exit(this, "parseInitialDataResponse (via exception)");
            throw new MQInternalException(2, 2195, 61);
        }
        if ((by4 & 2) != 0) {
            Trace.trace(1, this, "Remote queue manager cannot support my encoding");
            this.close();
            Trace.exit(this, "parseInitialDataResponse (via exception)");
            throw new MQInternalException(2, 2195, 62);
        }
        if ((by4 & 8) != 0) {
            Trace.trace(1, this, "Remote queue manager cannot support FAP level");
            if (this.fapLevel >= 6) {
                this.fapLevel = 6;
            } else if (this.fapLevel >= 4) {
                this.fapLevel = 4;
            } else if (this.fapLevel > 1 && this.fapLevel < 4) {
                Trace.trace(1, this, "Renegotiating at FAP level 2");
                this.fapLevel = 2;
                this.distListCapable = false;
            } else {
                this.sendStatus(8, 2);
                this.connection.close();
                Trace.exit(this, "parseInitialDataResponse (via exception)");
                throw new MQInternalException(2, 2195, 63);
            }
        }
        if ((by4 & 0x10) != 0) {
            this.maxMessageSize = n2;
        }
        if ((by4 & 0x20) != 0) {
            Trace.trace(1, this, "Remote queue manager rejected MaxMsgsPerBatch");
            this.close();
            Trace.exit(this, "parseInitialDataResponse (via exception)");
            throw new MQInternalException(2, 2195, 64);
        }
        if ((by4 & 4) != 0) {
            this.maxTransmissionSize = n;
        }
        if ((by4 & 0x40) != 0) {
            Trace.trace(1, this, "Remote queue manager rejected sequence wrap value");
            this.sendStatus(8, 16);
            this.connection.close();
            Trace.exit(this, "parseInitialDataResponse (via exception)");
            throw new MQInternalException(2, 2195, 65);
        }
        if (this.fapLevel >= 4 && (by & 1) != 0) {
            this.IDFlags2 &= 0xFFFFFFFE;
            this.distListCapable = false;
        }
        Trace.exit(this, "parseInitialDataResponse");
        if (by3 != 0 || by != 0 || by4 != 0) {
            if (Trace.isOn()) {
                Trace.trace(1, this, "Renegotiating at FAPLevel " + this.fapLevel + ": IDEFlags = " + by3 + ", IDEFlags2 = " + by + ", ErrFlags = " + by4);
            }
            return false;
        }
        return true;
    }

    private boolean isValidJavaCcsid(int n) {
        boolean bl;
        String string = String.valueOf(n);
        String string2 = MQCcsidTable.lookup(string);
        if (string2 == null) {
            string2 = string;
        }
        String string3 = "X";
        try {
            byte[] byArray = string3.getBytes(string2);
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        return bl;
    }

    private boolean isCcsidAscii(int n) throws MQException {
        boolean bl;
        String string = String.valueOf(n);
        String string2 = MQCcsidTable.lookup(string);
        if (string2 == null) {
            string2 = string;
        }
        String string3 = "A";
        try {
            byte[] byArray = string3.getBytes(string2);
            bl = byArray.length == 1 && byArray[0] == 65;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MQInternalException(2, 2195, 87, string);
        }
        return bl;
    }

    protected boolean supportsSPI() {
        return this.requestSPI;
    }

    private final void renegotiateConnectionParameters() throws IOException, MQException {
        Trace.entry(this, "renegotiateConnectionParameters");
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byteArrayOutputStream.reset();
        this.buildInitialData(dataOutputStream, this.fapLevel);
        this.send(1, 1, byteArrayOutputStream.toByteArray(), null);
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Pint pint3 = new Pint();
        DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
        switch (pint.x) {
            case 5: {
                if ((pint2.x & 8) != 0) {
                    int n = 2;
                    int n2 = 2009;
                    int n3 = 0;
                    if ((pint2.x & 2) != 0) {
                        if (this.transmissionLength > 28) {
                            dataInputStream.skipBytes(4);
                            n3 = dataInputStream.readInt();
                        } else {
                            n3 = 22;
                        }
                    }
                    Trace.trace(1, this, "Server sent TCF_CLOSE_CHANNEL, reason code " + n3);
                    this.close();
                    Trace.exit(this, "renegotiateConnectionParameters (via exception)");
                    throw new MQInternalException(n, n2, 66);
                }
                if ((pint2.x & 2) == 0) break;
                dataInputStream.skipBytes(4);
                int n = dataInputStream.readInt();
                Trace.trace(1, this, "Server sent TCF_ERROR, error code " + n);
                this.close();
                Trace.exit(this, "renegotiateConnectionParameters (via exception)");
                throw new MQInternalException(2, 2009, 67, "" + n);
            }
            case 1: {
                if ((pint2.x & 2) == 0) break;
                Trace.trace(2, this, "Received TST_INITIAL_DATA with TCF_ERROR. I'll try renegotiating once more!");
                bl = true;
                break;
            }
            default: {
                Trace.trace(1, this, "Server sent unacceptable segment type : " + pint.x);
                this.sendStatus(8, 2);
                this.connection.close();
                Trace.exit(this, "renegotiateConnectionParametersAgain (via exception)");
                throw new MQInternalException(2, 2195, 98);
            }
        }
        if (bl) {
            Trace.trace(1, this, "Not looking good- will try *one more* time at renegotiation...");
            this.renegotiateConnectionParametersAgain();
        }
        Trace.exit(this, "renegotiateConnectionParameters");
    }

    private final void renegotiateConnectionParametersAgain() throws IOException, MQException {
        Trace.entry(this, "renegotiateConnectionParametersAgain");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byteArrayOutputStream.reset();
        this.buildInitialData(dataOutputStream, this.fapLevel);
        this.send(1, 1, byteArrayOutputStream.toByteArray(), null);
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Pint pint3 = new Pint();
        DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
        switch (pint.x) {
            case 5: {
                if ((pint2.x & 8) != 0) {
                    int n = 2;
                    int n2 = 2009;
                    int n3 = 0;
                    if ((pint2.x & 2) != 0) {
                        if (this.transmissionLength > 28) {
                            dataInputStream.skipBytes(4);
                            n3 = dataInputStream.readInt();
                        } else {
                            n3 = 22;
                        }
                    }
                    Trace.trace(1, this, "Server sent TCF_CLOSE_CHANNEL, reason code " + n3);
                    this.close();
                    Trace.exit(this, "renegotiateConnectionParametersAgain (via exception)");
                    throw new MQInternalException(n, n2, 66);
                }
                if ((pint2.x & 2) == 0) break;
                dataInputStream.skipBytes(4);
                int n = dataInputStream.readInt();
                Trace.trace(1, this, "Server sent TCF_ERROR, error code " + n);
                this.close();
                Trace.exit(this, "renegotiateConnectionParametersAgain (via exception)");
                throw new MQInternalException(2, 2009, 67, "" + n);
            }
            case 1: {
                if ((pint2.x & 2) == 0) break;
                Trace.trace(2, this, "Received TST_INITIAL_DATA with TCF_ERROR. Unexpected error!");
                this.sendStatus(8, 2);
                this.connection.close();
                Trace.exit(this, "renegotiateConnectionParametersAgain (via exception)");
                throw new MQInternalException(2, 2195, 98);
            }
            default: {
                Trace.trace(1, this, "Server sent unacceptable segment type : " + pint.x);
                this.sendStatus(8, 2);
                this.connection.close();
                Trace.exit(this, "renegotiateConnectionParametersAgain (via exception)");
                throw new MQInternalException(2, 2195, 98);
            }
        }
        Trace.exit(this, "renegotiateConnectionParametersAgain");
    }

    private final void sendSecurityFlows() throws MQException {
        Trace.entry(this, "sendSecurityFlows");
        try {
            if (this.securityExit == null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(1430864928);
                dataOutputStream.writeBytes(this.userID);
                dataOutputStream.writeBytes(this.password);
                if (this.fapLevel >= 5) {
                    dataOutputStream.writeBytes(this.longUserID);
                    dataOutputStream.write(this.userSecurityID, 0, this.userSecurityID.length);
                }
                Trace.trace(2, this, "No security exit at client, sending id and password");
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Trace.dataTrace(3, this, byArray);
                this.send(8, 0, byArray, null);
                if (this.serverSecurityExit) {
                    boolean bl = false;
                    Pint pint = new Pint(0);
                    Pint pint2 = new Pint(0);
                    Pint pint3 = new Pint(0);
                    while (!bl) {
                        Trace.trace(2, this, "Server has a security exit, awaiting reply...");
                        DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
                        switch (pint.x) {
                            case 6: {
                                Trace.trace(3, this, "Server sent TST_SECURITY_DATA, responding with null security flow.");
                                byteArrayOutputStream.reset();
                                dataOutputStream.writeInt(0);
                                this.send(6, 0, byteArrayOutputStream.toByteArray(), null);
                                break;
                            }
                            case 5: {
                                if ((pint2.x & 2) != 0) {
                                    int n = 0;
                                    if (this.transmissionLength > 28) {
                                        dataInputStream.skipBytes(4);
                                        n = dataInputStream.readInt();
                                    } else {
                                        n = 22;
                                    }
                                    Trace.trace(1, this, "Server sent TCF_ERROR : code = " + n);
                                    this.close();
                                    Trace.exit(this, "sendSecurityFlows (via exception)");
                                    throw new MQInternalException(2, 2063, 68, "" + n);
                                }
                                if ((pint2.x & 8) != 0) {
                                    Trace.trace(1, this, "Server sent TCF_CLOSE_CHANNEL");
                                    this.close();
                                    Trace.exit(this, "sendSecurityFlows (via exception)");
                                    throw new MQInternalException(2, 2009, 69);
                                }
                                bl = true;
                                break;
                            }
                            default: {
                                Trace.trace(1, this, "Unexpected segment type received from server : " + pint.x);
                                this.close();
                                Trace.exit(this, "sendSecurityFlows (via exception)");
                                throw new MQInternalException(2, 2195, 70);
                            }
                        }
                    }
                }
            } else {
                this.invokeSecurityExit();
            }
        }
        catch (IOException iOException) {
            this.close();
            Trace.exit(this, "sendSecurityFlows (via IOException)");
            throw new MQInternalException(2, 2195, 71);
        }
        Trace.exit(this, "sendSecurityFlows");
    }

    private final void invokeSecurityExit() throws MQException, IOException {
        Trace.entry(this, "invokeSecurityExit");
        this.securityExitParms.exitReason = 16;
        this.securityExitParms.exitResponse = 0;
        byte[] byArray = new byte[]{};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        while (!bl) {
            if ((byArray = this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, byArray)) != null) {
                Trace.trace(4, this, "Data returned by security exit follows:");
                Trace.dataTrace(4, this, byArray);
            }
            switch (this.securityExitParms.exitResponse) {
                case -6: 
                case -1: {
                    this.sendStatus(8, 9);
                    this.connection.close();
                    Trace.trace(2, this, "Client security exit closed the channel.");
                    Trace.exit(this, "invokeSecurityExit (via exception)");
                    throw new MQInternalException(2, 2063, 72);
                }
                case -3: {
                    bl2 = true;
                }
                case -4: {
                    bl3 = true;
                    break;
                }
                default: {
                    byArray = null;
                }
            }
            if (!bl3 && !bl4) {
                bl = true;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = byArray != null ? byArray.length : 0;
                dataOutputStream.writeInt(n);
                if (byArray != null) {
                    dataOutputStream.write(byArray);
                }
                Trace.trace(2, this, "Sending security message.");
                this.send(6, 0, byteArrayOutputStream.toByteArray(), null);
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                Trace.trace(2, this, "Waiting for server response.");
                DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
                switch (pint.x) {
                    case 5: {
                        int n2;
                        if ((pint2.x & 2) != 0) {
                            n2 = 0;
                            if (this.transmissionLength > 28) {
                                dataInputStream.skipBytes(4);
                                n2 = dataInputStream.readInt();
                            } else {
                                n2 = 22;
                            }
                            Trace.trace(1, this, "Server sent TCF_ERROR, code : " + n2);
                            this.close();
                            Trace.exit(this, "invokeSecurityExit (via exception)");
                            throw new MQInternalException(2, 2063, 73, "" + n2);
                        }
                        if ((pint2.x & 8) != 0) {
                            Trace.trace(1, this, "Server sent TCF_CLOSE_CHANNEL");
                            this.close();
                            Trace.exit(this, "invokeSecurityExit (via exception)");
                            throw new MQInternalException(2, 2009, 99);
                        }
                        if (bl2) {
                            Trace.trace(1, this, "Server sent unexpected TST_STATUS_DATA");
                            this.close();
                            Trace.exit(this, "invokeSecurityExit (via exception)");
                            throw new MQInternalException(2, 2063, 74);
                        }
                        bl = true;
                        break;
                    }
                    case 6: {
                        this.securityExitParms.exitReason = 15;
                        int n2 = dataInputStream.readInt();
                        byArray = new byte[n2];
                        dataInputStream.read(byArray, 0, n2);
                        bl2 = false;
                        break;
                    }
                    default: {
                        Trace.trace(1, this, "Server sent unexpected segment type: " + pint.x);
                        this.close();
                        Trace.exit(this, "invokeSecurityExit (via exception)");
                        throw new MQInternalException(2, 2195, 75);
                    }
                }
            }
            bl4 = false;
        }
        Trace.exit(this, "invokeSecurityExit");
    }

    private final void connectToQueueManager() throws MQException {
        Trace.entry(this, "connectToQueueManager");
        if (this.maxTransmissionSize < 44) {
            Trace.trace(1, this, "Max transmission size too small to proceed.");
            this.close();
            Trace.exit(this, "connectToQueueManager (via exception)");
            throw new MQInternalException(2, 2005, 76);
        }
        try {
            byte[] byArray;
            int n = 112;
            int n2 = 120;
            switch (this.fapLevel) {
                case 4: 
                case 6: {
                    byArray = this.buildAPIHeader(n2, 0, 0, 0);
                    break;
                }
                default: {
                    byArray = this.buildAPIHeader(n, 0, 0, 0);
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            String string = "Websphere MQ Client for Java";
            dataOutputStream.writeBytes(this.qManager);
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeInt(28);
            dataOutputStream.write(MQC.MQACT_NONE);
            if (this.fapLevel > 2) {
                Trace.trace(2, this, "Sending new MQCONN fields (fap 4)");
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(0);
            }
            Trace.trace(2, this, "Sending MQCONN flow.");
            this.send(129, 0, byteArrayOutputStream.toByteArray(), byArray);
            Pint pint = new Pint();
            Pint pint2 = new Pint();
            Pint pint3 = new Pint();
            Trace.trace(2, this, "Awaiting server reply.");
            DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
            switch (pint.x) {
                case 145: {
                    dataInputStream.skipBytes(4);
                    int n3 = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    if (n3 != 0) {
                        Trace.trace(1, this, "Non-zero completion code from MQCONN: " + n3 + "," + n4);
                        this.close();
                        Trace.exit(this, "connectToQueueManager (via exception)");
                        throw new MQInternalException(n3, n4, 77);
                    }
                    break;
                }
                case 5: {
                    Trace.trace(1, this, "Server sent unexpected status data.");
                    this.close();
                    Trace.exit(this, "connectToQueueManager (via exception)");
                    throw new MQInternalException(2, 2009, 78);
                }
                default: {
                    Trace.trace(1, this, "Server sent unexpected segment type: " + pint.x);
                    this.close();
                    Trace.exit(this, "connectToQueueManager (via exception)");
                    throw new MQInternalException(2, 2195, 79, "" + pint.x);
                }
            }
        }
        catch (IOException iOException) {
            this.close();
            Trace.exit(this, "connectToQueueManager (via IOException)");
            throw new MQInternalException(2, 2195, 80);
        }
        Trace.exit(this, "connectToQueueManager");
    }

    private final void buildInitialData(DataOutputStream dataOutputStream, int n) throws IOException {
        if (Trace.isOn()) {
            Trace.entry(this, "buildInitialData");
            Trace.trace(2, this, "FAP level " + n);
        }
        dataOutputStream.writeBytes("ID  ");
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(this.IDFlags);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(this.maxMessagesPerBatch);
        dataOutputStream.writeInt(this.maxTransmissionSize);
        dataOutputStream.writeInt(this.maxMessageSize);
        dataOutputStream.writeInt(this.sequenceWrapValue);
        dataOutputStream.writeBytes(this.channel);
        if (n > 2) {
            dataOutputStream.writeByte(this.IDFlags2);
            if ((this.IDFlags2 & 1) > 0) {
                Trace.trace(4, this, "Sending IDFlags2 with distLists flag set...");
                this.bitOneOfIDFlags2Set = true;
            }
            dataOutputStream.writeByte(0);
            dataOutputStream.writeShort(this.ccsid);
            String string = MQSESSION.setStringToLength(null, 48);
            dataOutputStream.writeBytes(string);
            dataOutputStream.writeInt(this.heartbeatInterval);
            dataOutputStream.writeShort(0);
        }
        Trace.exit(this, "buildInitialData");
    }

    private final void initialiseExits() throws MQException {
        Trace.entry(this, "initialiseExits");
        this.channelDefinition.channelName = this.channel;
        this.channelDefinition.queueManagerName = this.qManager;
        this.channelDefinition.maxMessageLength = this.maxMessageSize;
        this.channelDefinition.securityUserData = "";
        this.channelDefinition.sendUserData = "";
        this.channelDefinition.receiveUserData = "";
        this.channelDefinition.connectionName = this.hostname;
        this.channelDefinition.remoteUserId = this.fapLevel >= 5 ? this.longUserID : this.userID;
        this.channelDefinition.remotePassword = this.password;
        this.channelDefinition.localAddress = this.connection.getLocalAddress().getHostAddress() + "(" + this.connection.getLocalPort() + ")";
        this.securityExitParms.maxSegmentLength = this.maxTransmissionSize;
        this.securityExitParms.exitID = 11;
        this.securityExitParms.fapLevel = this.fapLevel;
        this.securityExitParms.capabilityFlags = this.IDFlags2;
        this.sendExitParms.maxSegmentLength = this.maxTransmissionSize;
        this.sendExitParms.exitID = 13;
        this.sendExitParms.fapLevel = this.fapLevel;
        this.sendExitParms.capabilityFlags = this.IDFlags2;
        this.receiveExitParms.maxSegmentLength = this.maxTransmissionSize;
        this.receiveExitParms.exitID = 14;
        this.receiveExitParms.fapLevel = this.fapLevel;
        this.receiveExitParms.capabilityFlags = this.IDFlags2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Object object = null;
        if (this.securityExit != null && !bl && !bl2) {
            Trace.trace(2, this, "User security exit provided.");
            this.securityExitParms.exitReason = 11;
            this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, new byte[0]);
            if (this.securityExit instanceof MQExternalSecurityExit && ((n = ((MQExternalSecurityExit)this.securityExit).getReasonCode()) == 2406 || n == 2407)) {
                bl2 = true;
                object = this.securityExit;
            }
            if (this.securityExitParms.exitResponse == -1 || this.securityExitParms.exitResponse == -6) {
                bl = true;
            }
        }
        if (this.sendExit != null) {
            Trace.trace(2, this, "User send exit provided.");
            this.sendExitParms.exitReason = 11;
            this.sendExit.sendExit(this.sendExitParms, this.channelDefinition, new byte[0]);
            if (this.sendExit instanceof MQExternalSendExit && ((n = ((MQExternalSendExit)this.sendExit).getReasonCode()) == 2406 || n == 2407)) {
                bl2 = true;
                object = this.sendExit;
            }
            if (this.sendExitParms.exitResponse == -6) {
                bl = true;
            }
        }
        if (this.receiveExit != null && !bl && !bl2) {
            Trace.trace(2, this, "User receive exit provided.");
            this.receiveExitParms.exitReason = 11;
            this.receiveExit.receiveExit(this.receiveExitParms, this.channelDefinition, new byte[0]);
            if (this.receiveExit instanceof MQExternalReceiveExit && ((n = ((MQExternalReceiveExit)this.receiveExit).getReasonCode()) == 2406 || n == 2407)) {
                bl2 = true;
                object = this.receiveExit;
            }
            if (this.receiveExitParms.exitResponse == -6) {
                bl = true;
            }
        }
        if (bl || bl2) {
            if (bl) {
                Trace.trace(1, this, "User exit requested channel be closed.");
            } else {
                Trace.trace(1, this, "Failure in using non-Java user exit.");
            }
            this.suppressSendExit = true;
            Trace.trace(1, this, "Sending TCF_CLOSE_CHANNEL");
            this.sendStatus(8, 9);
            Trace.exit(this, "initialiseExits (via exception)");
            if (bl) {
                throw new MQInternalException(2, 2195, 81);
            }
            throw new MQException(2, n, object);
        }
        this.exitsInitialised = true;
        Trace.exit(this, "initialiseExits");
    }

    private final void terminateExits() {
        Trace.entry(this, "terminateExits");
        if (this.securityExit != null) {
            Trace.trace(2, this, "Terminating security exit.");
            this.securityExitParms.exitReason = 12;
            this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, new byte[0]);
        }
        if (this.sendExit != null) {
            Trace.trace(2, this, "Terminating send exit.");
            this.sendExitParms.exitReason = 12;
            byte[] byArray = this.sendExit.sendExit(this.sendExitParms, this.channelDefinition, new byte[0]);
            if (byArray != null && this.serverOut != null) {
                try {
                    this.serverOut.write(byArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.receiveExit != null) {
            Trace.trace(2, this, "Terminating receive exit.");
            this.receiveExitParms.exitReason = 12;
            this.receiveExit.receiveExit(this.receiveExitParms, this.channelDefinition, new byte[0]);
        }
        Trace.exit(this, "terminateExits");
    }

    private final byte[] invokeSendExit(byte[] byArray) throws IOException, MQException {
        Trace.entry(this, "invokeSendExit");
        Trace.trace(4, this, "Data passed to exit follows:");
        Trace.dataTrace(4, this, byArray);
        byte[] byArray2 = byArray;
        if (!this.suppressSendExit && this.sendExit != null && this.exitsInitialised) {
            this.sendExitParms.exitResponse = 0;
            this.sendExitParms.exitReason = 14;
            Trace.trace(2, this, "Calling user send exit");
            byArray2 = this.sendExit.sendExit(this.sendExitParms, this.channelDefinition, byArray);
            if (byArray2 == null) {
                Trace.trace(1, this, "Warning : User send exit returned a null data buffer.");
            } else {
                Trace.trace(4, this, "Data returned from user send exit follows:");
                Trace.dataTrace(4, this, byArray2);
            }
            if (this.sendExitParms.exitResponse == -5) {
                this.suppressSendExit = true;
            } else {
                if (this.sendExitParms.exitResponse == -6) {
                    Trace.trace(1, this, "Send exit requested closure of channel.");
                    this.suppressSendExit = true;
                    this.sendStatus(8, 9);
                    this.connection.close();
                    Trace.exit(this, "invokeSenExit (via exception)");
                    throw new MQInternalException(2, 2195, 81);
                }
                if (this.sendExit instanceof MQExternalSendExit) {
                    int n = ((MQExternalSendExit)this.sendExit).getReasonCode();
                    if (n == 2406 || n == 2407) {
                        Trace.trace(1, this, "Failure in using non-Java send exit.");
                        this.suppressSendExit = true;
                        this.sendStatus(8, 9);
                        this.connection.close();
                        Trace.exit(this, "invokeSendExit (via exception)");
                        throw new MQException(2, n, this.sendExit);
                    }
                } else if (byArray2.length != byArray.length) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeInt(byArray2.length);
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    System.arraycopy(byArray3, 0, byArray2, 4, 4);
                }
            }
        } else {
            Trace.trace(2, this, "No user send exit was invoked");
        }
        Trace.exit(this, "invokeSendExit");
        return byArray2;
    }

    private final byte[] invokeReceiveExit(byte[] byArray) throws IOException, MQException {
        Trace.entry(this, "invokeReceiveExit");
        Trace.trace(4, this, "Data passed to receive exit follows:");
        Trace.dataTrace(4, this, byArray);
        byte[] byArray2 = byArray;
        if (!this.suppressReceiveExit && this.receiveExit != null && this.exitsInitialised) {
            this.receiveExitParms.exitResponse = 0;
            this.receiveExitParms.exitReason = 14;
            if ((byArray = this.receiveExit.receiveExit(this.receiveExitParms, this.channelDefinition, byArray)) == null) {
                Trace.trace(1, this, "Warning: User receive exit returned a null buffer");
            } else {
                Trace.trace(4, this, "Data returned from user receive exit follows:");
                Trace.dataTrace(4, this, byArray);
            }
            if (this.receiveExitParms.exitResponse == -5) {
                this.suppressReceiveExit = true;
            } else {
                if (this.receiveExitParms.exitResponse == -6) {
                    Trace.trace(1, this, "Receive exit requested closure of channel.");
                    this.suppressReceiveExit = true;
                    this.sendStatus(8, 9);
                    this.connection.close();
                    Trace.exit(this, "invokeReceiveExit (via exception)");
                    throw new MQInternalException(2, 2195, 81);
                }
                if (this.receiveExit instanceof MQExternalReceiveExit) {
                    int n = ((MQExternalReceiveExit)this.receiveExit).getReasonCode();
                    if (n == 2406 || n == 2407) {
                        Trace.trace(1, this, "Failure in using non-Java receive exit.");
                        this.suppressReceiveExit = true;
                        this.sendStatus(8, 9);
                        this.connection.close();
                        Trace.exit(this, "invokeReceiveExit (via exception)");
                        throw new MQException(2, n, this.receiveExit);
                    }
                } else if (byArray2.length != byArray.length) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeInt(byArray2.length);
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    System.arraycopy(byArray3, 0, byArray2, 4, 4);
                }
            }
        } else {
            Trace.trace(2, this, "No user receive exit was invoked");
        }
        Trace.exit(this, "invokeReceiveExit");
        return byArray;
    }

    private Socket createExplicitSocketConnection(String string, int n, InetAddress inetAddress, int n2, int n3, int n4) throws MQInternalException, IOException {
        if (Trace.isOn()) {
            Trace.entry(this, "createExplicitSocketConnection");
        }
        Socket socket = null;
        int n5 = 0;
        while (n5 <= n3 - n2) {
            try {
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Try to create socket bound locally to " + inetAddress + ", port " + n4);
                }
                FWHelper.debug("Try to create socket bound locally to " + inetAddress + ", port " + n4);
                socket = new Socket(string, n, inetAddress, n4);
                if (socket != null) {
                    String string2 = "Socket created OK: " + inetAddress + ", local port " + socket.getLocalPort();
                    if (Trace.isOn()) {
                        Trace.trace(2, this, string2);
                    }
                    FWHelper.debug(string2);
                } else {
                    String string3 = "Socket create failed - null returned.";
                    if (Trace.isOn()) {
                        Trace.trace(2, this, string3);
                    }
                }
                if (Trace.isOn()) {
                    Trace.exit(this, "createExplicitSocketConnection (success)");
                }
                return socket;
            }
            catch (BindException bindException) {
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Socket created failed due to bind exception (see below): " + inetAddress + ", port " + n4);
                }
                if (Trace.isOn()) {
                    Trace.trace(2, this, "BindException: " + bindException.getMessage());
                }
                FWHelper.debug("BindException: " + inetAddress + ", port " + n4);
            }
            catch (IOException iOException) {
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Socket created failed due to IOException (see below): " + inetAddress + ", port " + n4);
                }
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Exception (rethrowing): " + iOException);
                }
                FWHelper.debug("Exception: " + inetAddress + ", port " + n4);
                throw iOException;
            }
            ++n5;
            if (++n4 <= n3) continue;
            n4 = n2;
        }
        FWHelper.debug("Failed to create socket matching firewall properties.");
        MQInternalException mQInternalException = new MQInternalException(2, 2059, 125);
        if (Trace.isOn()) {
            Trace.exit(this, "createExplicitSocketConnection (failed)");
        }
        throw mQInternalException;
    }

    protected InetAddress getLocalInetAddress() {
        if (this.connection != null) {
            return this.connection.getLocalAddress();
        }
        return null;
    }

    protected int getLocalBoundPort() {
        if (this.connection != null) {
            return this.connection.getLocalPort();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void timedReadFully(byte[] byArray, int n) throws IOException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "timedReadFully (buffer only)");
                }
                this.timedReadFully(byArray, 0, byArray.length, n);
                Object var5_3 = null;
                if (!Trace.isOn) return;
            }
            catch (IOException iOException) {
                if (!Trace.isOn) throw iOException;
                Trace.trace(5, this, "leaving via IOException");
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "timedReadFully (buffer only)");
            throw throwable;
        }
        Trace.exit(this, "timedReadFully (buffer only)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void timedReadFully(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = -1;
        boolean bl = false;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "timedReadFully");
                    Trace.trace(5, this, "off = " + n + ", len = " + n2 + ", timeout = " + n3);
                }
                n4 = this.socketTimeOut;
                bl = false;
                do {
                    try {
                        this.serverIn.readFully(byArray, n, n2);
                        bl = false;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (Trace.isOn) {
                            Trace.trace(5, this, "Caught InterruptedIOException. Assuming socket timeout");
                        }
                        if ((n4 -= this.socketGrainTimeout) <= 0) {
                            if (!Trace.isOn) throw interruptedIOException;
                            Trace.trace(5, this, "timed out. Not retrying, throwing Exception instead:");
                            Trace.exceptionTrace(5, this, interruptedIOException);
                            throw interruptedIOException;
                        }
                        if (Trace.isOn) {
                            Trace.trace(5, this, "tempTimeout = " + n4 + ", retrying");
                        }
                        bl = true;
                    }
                    if (n4 < 0) break;
                } while (bl);
                Object var9_9 = null;
                if (!Trace.isOn) return;
            }
            catch (IOException iOException) {
                if (!Trace.isOn) throw iOException;
                Trace.exceptionTrace(5, this, iOException);
                Trace.trace(5, this, "leaving via IOException");
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "timedReadFully");
            throw throwable;
        }
        Trace.exit(this, "timedReadFully");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int timedReadInt(int n) throws IOException {
        int n2;
        int n3 = -1;
        boolean bl = false;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "timedReadInt");
                    Trace.trace(5, this, "timeout = " + n);
                }
                int n4 = 0;
                n3 = this.socketTimeOut;
                bl = false;
                do {
                    try {
                        n4 = this.serverIn.readInt();
                        bl = false;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (Trace.isOn) {
                            Trace.trace(5, this, "Caught InterruptedIOException. Assuming socket timeout");
                        }
                        if ((n3 -= this.socketGrainTimeout) <= 0) {
                            if (!Trace.isOn) throw interruptedIOException;
                            Trace.trace(5, this, "timed out. Not retrying, throwing Exception instead:");
                            Trace.exceptionTrace(5, this, interruptedIOException);
                            throw interruptedIOException;
                        }
                        if (Trace.isOn) {
                            Trace.trace(5, this, "tempTimeout = " + n3 + ", retrying");
                        }
                        bl = true;
                    }
                } while (n3 >= 0 && bl);
                n2 = n4;
                Object var7_8 = null;
                if (!Trace.isOn) return n2;
            }
            catch (IOException iOException) {
                if (!Trace.isOn) throw iOException;
                Trace.exceptionTrace(5, this, iOException);
                Trace.trace(5, this, "leaving via IOException");
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "timedReadInt");
            throw throwable;
        }
        Trace.exit(this, "timedReadInt");
        return n2;
    }
}

