/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQChannelExit;
import com.ibm.mq.MQEnvironment;
import com.ibm.mqservices.Trace;

class MQExternalUserExit {
    private static final String sccsid = "javabase/com/ibm/mq/MQExternalUserExit.java, jms, j5306, j5306-11-050701 03/12/11 10:35:03 @(#) 1.8.2.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1996, 1999, 2003   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String className = "MQExternalUserExit";
    private String sslCipherSpec;
    protected String[] exitLibraries = new String[]{""};
    protected String[] exitEntries = new String[]{""};
    protected String[] dataStrings = new String[]{""};
    protected byte[][] dllHandles = new byte[4][1];
    protected byte[][] fnPointers = new byte[4][1];
    protected int reasonCode;

    protected MQExternalUserExit() {
        String string = MQEnvironment.sslCipherSuite;
        this.sslCipherSpec = "SSL_RSA_WITH_DES_CBC_SHA".equals(string) ? "DES_SHA_EXPORT" : ("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA".equals(string) ? "DES_SHA_EXPORT1024" : ("SSL_RSA_WITH_NULL_MD5".equals(string) ? "NULL_MD5" : ("SSL_RSA_WITH_NULL_SHA".equals(string) ? "NULL_SHA" : ("SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5".equals(string) ? "RC2_MD5_EXPORT" : ("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA".equals(string) ? "RC4_56_SHA_EXPORT1024" : ("SSL_RSA_WITH_RC4_128_MD5".equals(string) ? "RC4_MD5_US" : ("SSL_RSA_EXPORT_WITH_RC4_40_MD5".equals(string) ? "RC4_MD5_EXPORT" : ("SSL_RSA_WITH_RC4_128_SHA".equals(string) ? "RC4_SHA_US" : ("SSL_RSA_WITH_3DES_EDE_CBC_SHA".equals(string) ? "TRIPLE_DES_SHA_US" : "")))))))));
        System.loadLibrary("mqjexitstub01");
    }

    protected MQExternalUserExit(String string, String string2, String string3) {
        this();
        this.setLibraryName(string);
        this.setEntryPointName(string2);
        this.setUserData(string3);
    }

    protected byte[] userExit(MQChannelExit mQChannelExit, MQChannelDefinition mQChannelDefinition, byte[] byArray) {
        String string = "userExit";
        Trace.entry(className, string);
        this.reasonCode = 0;
        if (mQChannelDefinition.sslPeerName == null) {
            mQChannelDefinition.sslPeerName = "";
        }
        if (mQChannelDefinition.remoteUserId == null) {
            mQChannelDefinition.remoteUserId = "";
        }
        if (mQChannelExit.exitUserArea == null) {
            mQChannelExit.exitUserArea = new byte[0];
        }
        int n = this.jniChannelExit(mQChannelExit, mQChannelDefinition, byArray);
        Trace.trace(className, "trace code returned from jniChannelExit is " + n % 256);
        switch (n / 256) {
            case 0: {
                this.reasonCode = 0;
                break;
            }
            case 2: 
            case 3: {
                this.reasonCode = 2406;
                break;
            }
            default: {
                this.reasonCode = 2407;
            }
        }
        Trace.trace(className, "reason code after jniChannelExit is " + this.reasonCode);
        Trace.exit(className, string);
        return byArray;
    }

    private native int jniChannelExit(MQChannelExit var1, MQChannelDefinition var2, byte[] var3);

    public void setEntryPointName(String string) {
        String string2 = "setEntryPointName";
        Trace.entry(className, string2);
        this.exitEntries[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public void setLibraryName(String string) {
        String string2 = "setLibraryName";
        Trace.entry(className, string2);
        this.exitLibraries[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public void setUserData(String string) {
        String string2 = "setUserData";
        Trace.entry(className, string2);
        this.dataStrings[0] = string == null ? "" : string;
        Trace.exit(className, string2);
    }

    public String getUserData() {
        String string = "getUserData";
        Trace.entry(className, string);
        Trace.exit(className, string);
        return this.dataStrings[0];
    }

    protected String getEntryPointName() {
        String string = "getEntryPointName";
        Trace.entry(className, string);
        Trace.exit(className, string);
        return this.exitLibraries[0];
    }

    protected String getLibraryName() {
        String string = "getLibraryName";
        Trace.entry(className, string);
        Trace.exit(className, string);
        return this.exitLibraries[0];
    }

    public int getReasonCode() {
        return this.reasonCode;
    }
}

