/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.MQSimpleConnectionManager;
import com.ibm.mqservices.Trace;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.spi.ConnectionManager;

public class MQEnvironment {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQEnvironment.java, java, j5306, j5306-12-050823 1.50.1.5 05/06/30 15:57:15";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 5694-137 (c) Copyright IBM Corp. 1997, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String version_notice = "Websphere MQ classes for Java V5.3.0";
    static final String CLASSNAME = "MQEnvironment";
    public static MQSecurityExit securityExit = null;
    public static MQSendExit sendExit = null;
    public static MQReceiveExit receiveExit = null;
    public static String hostname = "";
    public static int port = 1414;
    public static String channel = "";
    public static String userID = "";
    public static String password = "";
    public static int CCSID = 819;
    public static String sslCipherSuite = null;
    public static String sslPeerName = null;
    public static Collection sslCertStores = null;
    public static Object sslSocketFactory = null;
    public static String localAddressSetting = null;
    public static Hashtable properties = new Hashtable();
    static Vector poolTokenSet = new Vector();
    static Vector poolServices = new Vector();
    static MQConnectionManager defaultMQCxManager = new MQSimpleConnectionManager();
    static ConnectionManager defaultCxManager = null;
    static boolean xaClientEnabled = false;
    static int xaLicenseMsg = 0;
    protected static boolean runningInWebSphere = false;
    protected static boolean forceAllowClient = false;

    public static final String getVersionNotice() {
        return version_notice;
    }

    public static void enableTracing(int n) {
        if (!MQSESSION.getLibraryName().equals("wmqjcics")) {
            Trace.notInCICS();
        }
        Trace.setTraceLevel(n);
        Trace.turnTracingOn();
        if (n >= 5) {
            Trace.turnMethodTracingOn();
        }
        MQEnvironment.traceSystemProperties();
    }

    public static void enableTracing(int n, OutputStream outputStream) {
        Trace.setWasBaseJavaTrace(true);
        if (!MQSESSION.getLibraryName().equals("wmqjcics")) {
            Trace.notInCICS();
        }
        if (outputStream != null) {
            Trace.setTraceStream(new PrintWriter(outputStream, true));
        }
        Trace.setTraceLevel(n);
        Trace.turnTracingOn();
        if (n >= 5) {
            Trace.turnMethodTracingOn();
        }
        MQEnvironment.traceSystemProperties();
    }

    public static void disableTracing() {
        Trace.setWasBaseJavaTrace(false);
        Trace.turnMethodTracingOff();
        Trace.turnTracingOff();
    }

    public static void setDefaultConnectionManager(MQConnectionManager mQConnectionManager) {
        Trace.entry(CLASSNAME, "setDefaultConnectionManager (MQ)");
        if (mQConnectionManager == null) {
            Trace.exit("MQEnvrironment", "setDefaultConnectionManager (via exception)");
            throw new NullPointerException("");
        }
        Vector vector = poolTokenSet;
        synchronized (vector) {
            defaultMQCxManager = mQConnectionManager;
            defaultCxManager = null;
            poolTokenSet.removeAllElements();
        }
        Vector vector2 = (Vector)poolServices.clone();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireDefaultConnectionManagerChanged();
        }
        Trace.exit(CLASSNAME, "setDefaultConnectionManager");
    }

    public static void setDefaultConnectionManager(ConnectionManager connectionManager) {
        Trace.entry(CLASSNAME, "setDefaultConnectionManager");
        if (connectionManager == null) {
            Trace.exit(CLASSNAME, "setDefaultConnectionManager (via exception)");
            throw new NullPointerException("");
        }
        Vector vector = poolTokenSet;
        synchronized (vector) {
            defaultCxManager = connectionManager;
            defaultMQCxManager = null;
            poolTokenSet.removeAllElements();
        }
        Vector vector2 = (Vector)poolServices.clone();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireDefaultConnectionManagerChanged();
        }
        Trace.exit(CLASSNAME, "setDefaultConnectionManager");
    }

    public static ConnectionManager getDefaultConnectionManager() {
        Vector vector = poolTokenSet;
        synchronized (vector) {
            ConnectionManager connectionManager = defaultCxManager;
            return connectionManager;
        }
    }

    public static void addConnectionPoolToken(MQPoolToken mQPoolToken) {
        Trace.entry(CLASSNAME, "addConnectionPoolToken");
        if (mQPoolToken == null) {
            Trace.exit(CLASSNAME, "addConnectionPoolToken (via exception)");
            throw new NullPointerException("");
        }
        poolTokenSet.addElement(mQPoolToken);
        Vector vector = (Vector)poolServices.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireTokenAdded(mQPoolToken);
        }
        Trace.exit("MQEnvironnment", "addConnectionPoolToken");
    }

    public static MQPoolToken addConnectionPoolToken() {
        Trace.entry(CLASSNAME, "addConnectionPoolToken");
        MQPoolToken mQPoolToken = new MQPoolToken();
        poolTokenSet.addElement(mQPoolToken);
        Vector vector = (Vector)poolServices.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
            mQPoolServices.fireTokenAdded(mQPoolToken);
        }
        Trace.exit(CLASSNAME, "addConnectionPoolToken");
        return mQPoolToken;
    }

    public static void removeConnectionPoolToken(MQPoolToken mQPoolToken) {
        Trace.entry(CLASSNAME, "removeConnectionPoolToken");
        if (mQPoolToken == null) {
            Trace.exit(CLASSNAME, "removeConnectionPoolToken (via exception)");
            throw new NullPointerException("");
        }
        boolean bl = false;
        Vector vector = poolTokenSet;
        synchronized (vector) {
            int n = poolTokenSet.size();
            poolTokenSet.removeElement(mQPoolToken);
            if (poolTokenSet.size() < n) {
                bl = true;
            }
        }
        if (bl) {
            Vector vector2 = (Vector)poolServices.clone();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                MQPoolServices mQPoolServices = (MQPoolServices)enumeration.nextElement();
                mQPoolServices.fireTokenRemoved(mQPoolToken);
            }
        }
        Trace.exit(CLASSNAME, "removeConnectionPoolToken");
    }

    public static Thread createThread(Runnable runnable, boolean bl) throws SecurityException {
        return MQEnvironment.createThread(runnable, null, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Thread createThread(final Runnable runnable, final String string, final boolean bl) throws SecurityException {
        Thread thread;
        Thread thread2 = null;
        try {
            try {
                Trace.entry(CLASSNAME, "createThread");
                thread2 = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread thread = new Thread(runnable, string);
                        thread.setDaemon(bl);
                        return thread;
                    }
                });
                Trace.trace(CLASSNAME, "returning " + thread2);
                thread = thread2;
                Object var6_6 = null;
            }
            catch (SecurityException securityException) {
                Trace.trace(CLASSNAME, "throwing " + securityException);
                throw securityException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Trace.exit(CLASSNAME, "createThread");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "createThread");
        return thread;
    }

    public static boolean runningInWS() {
        return runningInWebSphere;
    }

    public static boolean forceAllowClientConnection() {
        Trace.trace(CLASSNAME, "forceAllowClient = " + forceAllowClient);
        return forceAllowClient;
    }

    protected static final String stringFromBytes(byte[] byArray) {
        String string;
        try {
            string = new String(byArray, "819");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Could not convert string using 819. Using default locale");
            }
            string = new String(byArray);
        }
        return string;
    }

    protected static final byte[] bytesFromString(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("819");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Could not convert string using 819. Using default locale");
            }
            byArray = string.getBytes();
        }
        return byArray;
    }

    static void registerPoolServices(MQPoolServices mQPoolServices) {
        poolServices.addElement(mQPoolServices);
    }

    static void deregisterPoolServices(MQPoolServices mQPoolServices) {
        poolServices.removeElement(mQPoolServices);
    }

    static Object getDefaultProperty(Object object) {
        Object object2 = properties.get(object);
        Trace.entry(CLASSNAME, "getDefaultProperty - " + object);
        if (object2 == null) {
            if (object.equals("CCSID")) {
                object2 = new Integer(CCSID);
            }
            if (object.equals("channel")) {
                object2 = channel;
            }
            if (object.equals("connectOptions")) {
                object2 = new Integer(0);
            }
            if (object.equals("hostname")) {
                object2 = hostname;
            }
            if (object.equals("password")) {
                object2 = password;
            }
            if (object.equals("port")) {
                object2 = new Integer(port);
            }
            if (object.equals("receiveExit")) {
                object2 = receiveExit;
            }
            if (object.equals("securityExit")) {
                object2 = securityExit;
            }
            if (object.equals("sendExit")) {
                object2 = sendExit;
            }
            if (object.equals("transport")) {
                object2 = "MQSeries";
            }
            if (object.equals("userID")) {
                object2 = userID;
            }
            if (object.equals("SSL Cipher Suite")) {
                object2 = sslCipherSuite;
            }
            if (object.equals("SSL Peer Name")) {
                object2 = sslPeerName;
            }
            if (object.equals("SSL CertStores")) {
                object2 = sslCertStores;
            }
            if (object.equals("SSL Socket Factory")) {
                object2 = sslSocketFactory;
            }
            if (object.equals("Local Address Property")) {
                object2 = localAddressSetting;
            }
        }
        Trace.exit(CLASSNAME, "getDefaultProperty - " + object);
        return object2;
    }

    static Object getObjectProperty(String string, Hashtable hashtable) {
        Object object = null;
        if (hashtable != null) {
            object = hashtable.get(string);
        }
        if (object == null) {
            object = MQEnvironment.getDefaultProperty(string);
        }
        return object;
    }

    static String getStringProperty(String string, Hashtable hashtable) {
        Object object = MQEnvironment.getObjectProperty(string, hashtable);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    static int getIntegerProperty(String string, Hashtable hashtable) {
        Object object = MQEnvironment.getObjectProperty(string, hashtable);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    static boolean getXaClientEnabled() {
        return xaClientEnabled;
    }

    static int getXaLicenseMsg() {
        return xaLicenseMsg;
    }

    static void setXaLicenseMsg(int n) {
        xaLicenseMsg = n;
    }

    public static void traceSystemProperties() {
        if (Trace.isOn) {
            try {
                Object t = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperties();
                        }
                        catch (AccessControlException accessControlException) {
                            return null;
                        }
                    }
                });
                Properties properties = null;
                if (t == null || !(t instanceof Properties)) {
                    Trace.trace("", "Failed to obtain system properties!");
                    return;
                }
                properties = (Properties)t;
                Enumeration<?> enumeration = properties.propertyNames();
                String string = System.getProperty("line.separator");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string + "        System Properties" + string);
                stringBuffer.append("          =================" + string + string);
                stringBuffer.append("Key                                    Value" + string);
                stringBuffer.append("---                                    -----" + string + string);
                String string2 = "";
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    stringBuffer.append(string2 + ":");
                    int n = 40 - string2.length();
                    while (n-- > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(properties.getProperty(string2) + string);
                }
                stringBuffer.append(string);
                Trace.trace("", stringBuffer.toString());
            }
            catch (Throwable throwable) {
                Trace.trace("", "Failed to obtain system properties!");
            }
        }
    }

    static {
        Trace.trace(CLASSNAME, sccsid);
        try {
            Class.forName("com.ibm.mq.OSE");
            Trace.trace(CLASSNAME, "OSE loaded");
        }
        catch (Exception exception) {
            Trace.trace(CLASSNAME, "OSE not found");
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.localAddress");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string != null && !string.trim().equals("")) {
            localAddressSetting = string;
        }
    }
}

