/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BindingsConnectionRequestInfo;
import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnection;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mqservices.Trace;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class MQClientManagedConnectionFactoryJ11
implements MQManagedConnectionFactory {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQClientManagedConnectionFactoryJ11.java, java, j5306, j5306-12-050823 1.22.3.2 05/06/30 16:04:41";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 2001, 2002   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String fieldQMGR = "";
    private String fieldServerName = "";
    private int fieldPortNumber = 1414;
    private String fieldChannel = "";
    private int fieldCCSID = 819;
    PrintWriter logWriter = null;

    MQClientManagedConnectionFactoryJ11(String string, Hashtable hashtable) {
        Trace.entry(this, "MQClientManagedConnectionFactoryJ11 constructor");
        this.setQMGR(string);
        this.setServerName(MQEnvironment.getStringProperty("hostname", hashtable));
        this.setPortNumber(MQEnvironment.getIntegerProperty("port", hashtable));
        this.setChannel(MQEnvironment.getStringProperty("channel", hashtable));
        this.setCCSID(MQEnvironment.getIntegerProperty("CCSID", hashtable));
        Trace.exit(this, "MQClientManagedConnectionFactoryJ11 constructor");
    }

    public void setQMGR(String string) {
        this.fieldQMGR = string;
    }

    public String getQMGR() {
        return this.fieldQMGR;
    }

    public void setServerName(String string) {
        this.fieldServerName = string;
    }

    public String getServerName() {
        return this.fieldServerName;
    }

    public void setPortNumber(int n) {
        this.fieldPortNumber = n;
    }

    public int getPortNumber() {
        return this.fieldPortNumber;
    }

    public void setChannel(String string) {
        this.fieldChannel = string;
    }

    public String getChannel() {
        return this.fieldChannel;
    }

    public void setCCSID(int n) {
        this.fieldCCSID = n;
    }

    public int getCCSID() {
        return this.fieldCCSID;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public Object createConnectionFactory(MQConnectionManager mQConnectionManager) throws ResourceException {
        Trace.entry(this, "createConnectionFactory");
        Trace.exit(this, "createConnectionFactory (via exception)");
        throw new NotSupportedException("createConnectionFactory not supported by Websphere MQ");
    }

    public Object createConnectionFactory() throws ResourceException {
        Trace.entry(this, "createConnectionFactory");
        Trace.exit(this, "createConnectionFactory (via exception)");
        throw new NotSupportedException("createConnectionFactory not supported by Websphere MQ");
    }

    MQManagedConnectionJ11 _createManagedConnection(ConnectionRequestInfo connectionRequestInfo, boolean bl) throws ResourceException {
        MQManagedConnectionJ11 mQManagedConnectionJ11;
        Trace.entry(this, "_createManagedConnection");
        if (!(connectionRequestInfo instanceof ClientConnectionRequestInfo)) {
            Trace.exit(this, "_createManagedConnection (via exception)");
            String string = MQException.getNLSMsg(105);
            throw new ResourceException(string);
        }
        ClientConnectionRequestInfo clientConnectionRequestInfo = (ClientConnectionRequestInfo)connectionRequestInfo;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("transport", "MQSeries Client");
        hashtable.put("hostname", this.getServerName());
        hashtable.put("port", new Integer(this.getPortNumber()));
        hashtable.put("channel", this.getChannel());
        hashtable.put("CCSID", new Integer(this.getCCSID()));
        hashtable.put("connectOptions", new Integer(clientConnectionRequestInfo.connectOptions));
        if (clientConnectionRequestInfo.securityExit != null) {
            hashtable.put("securityExit", clientConnectionRequestInfo.securityExit);
        }
        if (clientConnectionRequestInfo.sendExit != null) {
            hashtable.put("sendExit", clientConnectionRequestInfo.sendExit);
        }
        if (clientConnectionRequestInfo.receiveExit != null) {
            hashtable.put("receiveExit", clientConnectionRequestInfo.receiveExit);
        }
        if (clientConnectionRequestInfo.userName != null) {
            hashtable.put("userID", clientConnectionRequestInfo.userName);
        }
        if (clientConnectionRequestInfo.password != null) {
            hashtable.put("password", clientConnectionRequestInfo.password);
        }
        if (clientConnectionRequestInfo.spi != null) {
            hashtable.put("SPI", clientConnectionRequestInfo.spi);
        }
        if (clientConnectionRequestInfo.xaRequired) {
            hashtable.put("XAReq", new Boolean(true));
        }
        if (clientConnectionRequestInfo.useQmCcsid) {
            hashtable.put("Use QM CCSID", new Boolean(true));
        }
        if (clientConnectionRequestInfo.useBatching != null) {
            hashtable.put("Batching enabled", clientConnectionRequestInfo.useBatching);
        }
        if (clientConnectionRequestInfo.batchFloor != null) {
            hashtable.put("Batch size floor", clientConnectionRequestInfo.batchFloor);
        }
        if (clientConnectionRequestInfo.batchCeiling != null) {
            hashtable.put("Batch size ceiling", clientConnectionRequestInfo.batchCeiling);
        }
        if (clientConnectionRequestInfo.batchThreshold != null) {
            hashtable.put("Batching threshold", clientConnectionRequestInfo.batchThreshold);
        }
        if (clientConnectionRequestInfo.batchInterval != null) {
            hashtable.put("Batch interval", clientConnectionRequestInfo.batchInterval);
        }
        if (clientConnectionRequestInfo.sslCipherSuite != null) {
            hashtable.put("SSL Cipher Suite", clientConnectionRequestInfo.sslCipherSuite);
        }
        if (clientConnectionRequestInfo.sslPeername != null) {
            hashtable.put("SSL Peer Name", clientConnectionRequestInfo.sslPeername);
        }
        if (clientConnectionRequestInfo.sslCertStores != null) {
            hashtable.put("SSL CertStores", clientConnectionRequestInfo.sslCertStores);
        }
        if (clientConnectionRequestInfo.sslSocketFactory != null) {
            hashtable.put("SSL Socket Factory", clientConnectionRequestInfo.sslSocketFactory);
        }
        if (clientConnectionRequestInfo.localAddress != null) {
            hashtable.put("FIREWALL_SETTINGS", clientConnectionRequestInfo.localAddress);
        }
        try {
            mQManagedConnectionJ11 = bl ? new MQManagedConnectionJ11(this.fieldQMGR, hashtable, connectionRequestInfo, this) : new MQManagedConnection(this.fieldQMGR, hashtable, connectionRequestInfo, this);
            mQManagedConnectionJ11.setLogWriter(this.logWriter);
        }
        catch (MQException mQException) {
            ResourceException resourceException = mQException.getResourceException();
            Trace.exit(this, "_createManagedConnection (via exception)");
            throw resourceException;
        }
        Trace.exit(this, "_createManagedConnection");
        return mQManagedConnectionJ11;
    }

    public MQManagedConnectionJ11 createManagedConnection(ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return this._createManagedConnection(connectionRequestInfo, true);
    }

    public MQManagedConnectionJ11 matchManagedConnections(Vector vector, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Trace.entry(this, "matchManagedConnections");
        MQManagedConnectionJ11 mQManagedConnectionJ11 = null;
        if (!(connectionRequestInfo instanceof BindingsConnectionRequestInfo)) {
            throw new ResourceException("Invalid ConnectionRequestInfo object");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements() && mQManagedConnectionJ11 == null) {
            try {
                MQManagedConnectionJ11 mQManagedConnectionJ112 = (MQManagedConnectionJ11)enumeration.nextElement();
                if (!mQManagedConnectionJ112.isSuitable(connectionRequestInfo, this)) continue;
                mQManagedConnectionJ11 = mQManagedConnectionJ112;
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (Trace.isOn()) {
            if (mQManagedConnectionJ11 == null) {
                Trace.trace(2, this, "No suitable MQManagedConnection found");
            } else {
                Trace.trace(2, this, "Suitable MQManagedConnection found: " + mQManagedConnectionJ11);
            }
        }
        Trace.exit(this, "matchManagedConnections");
        return mQManagedConnectionJ11;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MQClientManagedConnectionFactoryJ11 mQClientManagedConnectionFactoryJ11 = (MQClientManagedConnectionFactoryJ11)object;
        return MQClientManagedConnectionFactoryJ11.twoStringsEqual(this.fieldQMGR, mQClientManagedConnectionFactoryJ11.fieldQMGR) && this.fieldServerName.equals(mQClientManagedConnectionFactoryJ11.fieldServerName) && this.fieldPortNumber == mQClientManagedConnectionFactoryJ11.fieldPortNumber && this.fieldChannel.equals(mQClientManagedConnectionFactoryJ11.fieldChannel) && this.fieldCCSID == mQClientManagedConnectionFactoryJ11.fieldCCSID;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalAccessError();
        }
    }

    static boolean twoStringsEqual(String string, String string2) {
        boolean bl = string == null && string2 == null ? true : (string == null || string2 == null ? false : string.equals(string2));
        return bl;
    }
}

