/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSESSIONClient;
import com.ibm.mqservices.Trace;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public abstract class FWHelper {
    public static final String CLSNAME = "FWHelper";
    private static final String sccsid = "javabase/com/ibm/mq/FWHelper.java, jms, j5306, j5306-11-050701 03/12/11 10:43:26 @(#) 1.11.2.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 2002   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String FW_HOST = "HOST";
    static final String FW_START_PORT = "START_PORT";
    static final String FW_END_PORT = "END_PORT";
    static final String FW_OBJECT = "FIREWALL_SETTINGS";
    static boolean FW_DEBUG_ENABLED = false;
    static PrintWriter debug_out = null;
    private static Map fwRecords = Collections.synchronizedMap(new HashMap());
    private static int MODE_BEST = 0;
    private static int MODE_EXPLICIT = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetAddress getLocalIP(String string) throws MQException {
        InetAddress inetAddress;
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "getLocalIP");
        }
        if (Trace.isOn) {
            Trace.trace(CLSNAME, "setting: " + string);
        }
        try {
            try {
                InetAddress inetAddress2 = null;
                String string2 = null;
                if (string != null) {
                    int n = string.indexOf("(");
                    if (n == -1) {
                        n = string.length();
                    }
                    string2 = string.substring(0, n);
                } else {
                    string2 = null;
                }
                try {
                    if (string2 != null && string2.trim().length() == 0) {
                        string2 = null;
                    }
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.trace(CLSNAME, "Attempt to get local ip setting from this string: '" + string2 + "'");
                    }
                    if ((inetAddress2 = string2 == null || string2.equalsIgnoreCase("localhost") || string2.equalsIgnoreCase("127.0.0.1") ? InetAddress.getLocalHost() : InetAddress.getByName(string2)) != null) {
                        if (Trace.isOn && FW_DEBUG_ENABLED) {
                            Trace.trace(CLSNAME, "Parsed local IP setting: " + inetAddress2.getHostAddress());
                        }
                    } else if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.trace(CLSNAME, "Parsed local IP setting is null");
                    }
                    inetAddress = inetAddress2;
                    Object var6_8 = null;
                    if (!Trace.isOn) return inetAddress;
                }
                catch (IOException iOException) {
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "IO Error determining local InetAddress");
                    }
                    if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getLocalIP", 125);
                    Trace.exceptionTrace(1, "getLocalIP", iOException);
                    throw new MQException(2, 2059, (Object)"FWHelper getLocalIP", 125);
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Error determining local InetAddress");
                    }
                    if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getLocalIP", 125);
                    Trace.exceptionTrace(1, "getLocalIP", exception);
                    throw new MQException(2, 2059, (Object)"FWHelper getLocalIP", 125);
                }
            }
            catch (MQException mQException) {
                throw mQException;
            }
            catch (Exception exception) {
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "Exception occurred");
                }
                if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getLocalIP", 125);
                Trace.exceptionTrace(1, "getLocalIP", exception);
                throw new MQException(2, 2059, (Object)"FWHelper getLocalIP", 125);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "getLocalIP");
            throw throwable;
        }
        Trace.exit(CLSNAME, "getLocalIP");
        return inetAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getStartPort(String string) throws MQException {
        int n;
        block24: {
            int n2;
            block23: {
                int n3;
                block22: {
                    if (Trace.isOn) {
                        Trace.entry(CLSNAME, "getStartPort");
                    }
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "setting: " + string);
                    }
                    int n4 = 0;
                    try {
                        try {
                            String string2 = null;
                            if (string != null) {
                                int n5 = string.indexOf("(");
                                if (n5 == -1) {
                                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                                        Trace.trace(CLSNAME, "No starting bracket specified - default to 0");
                                    }
                                    n3 = 0;
                                    Object var8_9 = null;
                                    if (!Trace.isOn) return n3;
                                    break block22;
                                }
                                int n6 = 0;
                                n6 = string.indexOf(",", n5);
                                if (n6 == -1 && (n6 = string.indexOf(")", n5)) == -1) {
                                    if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                    if (!FW_DEBUG_ENABLED) throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                    Trace.trace(CLSNAME, "Malformed setting string. No comma or closing bracket found - return " + n4);
                                    throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                }
                                string2 = string.substring(n5 + 1, n6);
                                if (Trace.isOn && FW_DEBUG_ENABLED) {
                                    Trace.trace(CLSNAME, "String form of start port: '" + string2 + "'");
                                }
                                try {
                                    int n7;
                                    if (string2 != null) {
                                        string2 = string2.trim();
                                    }
                                    if (string2.length() == 0) {
                                        string2 = "0";
                                    }
                                    if ((n7 = Integer.valueOf(string2).intValue()) < 0) {
                                        if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                        Trace.trace(CLSNAME, "Negative port number: " + n7);
                                        throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                    }
                                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                                        Trace.trace(CLSNAME, "Converted to int successfully: " + n7);
                                    }
                                    n2 = n7;
                                    break block23;
                                }
                                catch (MQException mQException) {
                                    throw mQException;
                                }
                                catch (Exception exception) {
                                    if (Trace.isOn) {
                                        Trace.trace(CLSNAME, "Exception occurred converting string to int - return " + n4);
                                    }
                                    if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                    Trace.trace(CLSNAME, exception.toString());
                                    throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                                }
                            }
                            if (Trace.isOn && FW_DEBUG_ENABLED) {
                                Trace.trace(CLSNAME, "setting string is null - default to 0");
                            }
                            n = 0;
                            break block24;
                        }
                        catch (MQException mQException) {
                            throw mQException;
                        }
                        catch (Exception exception) {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Exception occurred - return " + n4);
                            }
                            if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                            Trace.trace(CLSNAME, exception.toString());
                            throw new MQException(2, 2059, (Object)"FWHelper getStartPort", 125);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (!Trace.isOn) throw throwable;
                        Trace.exit(CLSNAME, "getStartPort");
                        throw throwable;
                    }
                }
                Trace.exit(CLSNAME, "getStartPort");
                return n3;
            }
            Object var8_10 = null;
            if (!Trace.isOn) return n2;
            Trace.exit(CLSNAME, "getStartPort");
            return n2;
        }
        Object var8_11 = null;
        if (!Trace.isOn) return n;
        Trace.exit(CLSNAME, "getStartPort");
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getEndPort(String string) throws MQException {
        int n;
        block24: {
            int n2;
            block23: {
                int n3;
                block22: {
                    if (Trace.isOn) {
                        Trace.entry(CLSNAME, "getEndPort");
                    }
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "setting: " + string);
                    }
                    int n4 = 0;
                    try {
                        try {
                            String string2 = null;
                            if (string != null) {
                                int n5 = string.indexOf(",");
                                if (n5 == -1) {
                                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                                        Trace.trace(CLSNAME, "No comma specified - default to getStartPort");
                                    }
                                    n3 = FWHelper.getStartPort(string);
                                    Object var8_9 = null;
                                    if (!Trace.isOn) return n3;
                                    break block22;
                                }
                                int n6 = 0;
                                n6 = string.indexOf(")", n5);
                                if (n6 == -1) {
                                    if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                    if (!FW_DEBUG_ENABLED) throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                    Trace.trace(CLSNAME, "Malformed setting string. No closing bracket found - return " + n4);
                                    throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                }
                                string2 = string.substring(n5 + 1, n6);
                                if (Trace.isOn && FW_DEBUG_ENABLED) {
                                    Trace.trace(CLSNAME, "String form of end port: " + string2);
                                }
                                try {
                                    int n7;
                                    if (string2 != null) {
                                        string2 = string2.trim();
                                    }
                                    if (string2.length() == 0) {
                                        string2 = "0";
                                    }
                                    if ((n7 = Integer.valueOf(string2).intValue()) < 0) {
                                        if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                        Trace.trace(CLSNAME, "Negative port number: " + n7);
                                        throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                    }
                                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                                        Trace.trace(CLSNAME, "Converted to int successfully: " + n7);
                                    }
                                    n2 = n7;
                                    break block23;
                                }
                                catch (MQException mQException) {
                                    throw mQException;
                                }
                                catch (Exception exception) {
                                    if (Trace.isOn) {
                                        Trace.trace(CLSNAME, "Exception occurred converting string to int - return " + n4);
                                    }
                                    if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                    Trace.trace(CLSNAME, exception.toString());
                                    throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                                }
                            }
                            if (Trace.isOn && FW_DEBUG_ENABLED) {
                                Trace.trace(CLSNAME, "setting string is null - default to startPort");
                            }
                            n = FWHelper.getStartPort(string);
                            break block24;
                        }
                        catch (MQException mQException) {
                            throw mQException;
                        }
                        catch (Exception exception) {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Exception occurred - return " + n4);
                            }
                            if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                            Trace.trace(CLSNAME, exception.toString());
                            throw new MQException(2, 2059, (Object)"FWHelper getEndPort", 125);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (!Trace.isOn) throw throwable;
                        Trace.exit(CLSNAME, "getEndPort");
                        throw throwable;
                    }
                }
                Trace.exit(CLSNAME, "getEndPort");
                return n3;
            }
            Object var8_10 = null;
            if (!Trace.isOn) return n2;
            Trace.exit(CLSNAME, "getEndPort");
            return n2;
        }
        Object var8_11 = null;
        if (!Trace.isOn) return n;
        Trace.exit(CLSNAME, "getEndPort");
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object encodeToObject(String string) throws MQException {
        Hashtable<String, Serializable> hashtable;
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "encodeToObject");
        }
        FWHelper.debug("Raw setting: " + string);
        try {
            try {
                Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
                InetAddress inetAddress = FWHelper.getLocalIP(string);
                if (inetAddress != null) {
                    hashtable2.put(FW_HOST, inetAddress);
                }
                hashtable2.put(FW_START_PORT, new Integer(FWHelper.getStartPort(string)));
                hashtable2.put(FW_END_PORT, new Integer(FWHelper.getEndPort(string)));
                hashtable = hashtable2;
                Object var5_6 = null;
                if (!Trace.isOn) return hashtable;
            }
            catch (MQException mQException) {
                throw mQException;
            }
            catch (Exception exception) {
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "Exception occurred during encoding");
                }
                if (!Trace.isOn) throw new MQException(2, 2059, (Object)"FWHelper encodeToObject", 125);
                Trace.trace(CLSNAME, exception.toString());
                throw new MQException(2, 2059, (Object)"FWHelper encodeToObject", 125);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "encodeToObject");
            throw throwable;
        }
        Trace.exit(CLSNAME, "encodeToObject");
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static InetAddress decodeLocalAddress(Object object) {
        InetAddress inetAddress;
        block11: {
            InetAddress inetAddress2;
            block10: {
                if (Trace.isOn) {
                    Trace.entry(CLSNAME, "decodeLocalAddress");
                }
                try {
                    try {
                        if (object instanceof Hashtable) {
                            Hashtable hashtable = (Hashtable)object;
                            InetAddress inetAddress3 = (InetAddress)hashtable.get(FW_HOST);
                            if (Trace.isOn && FW_DEBUG_ENABLED) {
                                Trace.trace(CLSNAME, "Retrieved: " + inetAddress3);
                            }
                            inetAddress2 = inetAddress3;
                            Object var5_7 = null;
                            if (!Trace.isOn) return inetAddress2;
                            break block10;
                        }
                        if (Trace.isOn && FW_DEBUG_ENABLED) {
                            Trace.trace(CLSNAME, "Encoded object is not a hashtable - return null");
                        }
                        inetAddress = null;
                        break block11;
                    }
                    catch (Exception exception) {
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Exception occurred during decoding");
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, exception.toString());
                        }
                        InetAddress inetAddress4 = null;
                        Object var5_9 = null;
                        if (!Trace.isOn) return inetAddress4;
                        Trace.exit(CLSNAME, "decodeLocalAddress");
                        return inetAddress4;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(CLSNAME, "decodeLocalAddress");
                    throw throwable;
                }
            }
            Trace.exit(CLSNAME, "decodeLocalAddress");
            return inetAddress2;
        }
        Object var5_8 = null;
        if (!Trace.isOn) return inetAddress;
        Trace.exit(CLSNAME, "decodeLocalAddress");
        return inetAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int decodePort(Object object, String string) {
        int n;
        block16: {
            int n2;
            block15: {
                int n3;
                block14: {
                    if (Trace.isOn) {
                        Trace.entry(CLSNAME, "decodePort");
                    }
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Port type: " + string);
                    }
                    try {
                        try {
                            if (object instanceof Hashtable) {
                                Hashtable hashtable = (Hashtable)object;
                                Integer n4 = (Integer)hashtable.get(string);
                                if (Trace.isOn && FW_DEBUG_ENABLED) {
                                    Trace.trace(CLSNAME, "Retrieved: " + n4);
                                }
                                if (n4 != null) {
                                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                                        Trace.trace(CLSNAME, "Returning: " + n4);
                                    }
                                    n3 = n4;
                                    Object var6_9 = null;
                                    if (!Trace.isOn) return n3;
                                    break block14;
                                }
                                if (Trace.isOn && FW_DEBUG_ENABLED) {
                                    Trace.trace(CLSNAME, "Returning: 0");
                                }
                                n2 = 0;
                                break block15;
                            }
                            if (Trace.isOn && FW_DEBUG_ENABLED) {
                                Trace.trace(CLSNAME, "Encoded object is not a hashtable - return 0");
                            }
                            n = 0;
                            break block16;
                        }
                        catch (Exception exception) {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Exception occurred during decoding - return 0");
                            }
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, exception.toString());
                            }
                            int n5 = 0;
                            Object var6_12 = null;
                            if (!Trace.isOn) return n5;
                            Trace.exit(CLSNAME, "decodePort");
                            return n5;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_13 = null;
                        if (!Trace.isOn) throw throwable;
                        Trace.exit(CLSNAME, "decodePort");
                        throw throwable;
                    }
                }
                Trace.exit(CLSNAME, "decodePort");
                return n3;
            }
            Object var6_10 = null;
            if (!Trace.isOn) return n2;
            Trace.exit(CLSNAME, "decodePort");
            return n2;
        }
        Object var6_11 = null;
        if (!Trace.isOn) return n;
        Trace.exit(CLSNAME, "decodePort");
        return n;
    }

    static int getLastTried(InetAddress inetAddress, int n, int n2) {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "getLastTried");
        }
        int n3 = 0;
        n3 = FWHelper.getLastTriedInternal(inetAddress, n, n2, MODE_BEST);
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "getLastTried");
        }
        return n3;
    }

    static int getLastTriedExplicit(InetAddress inetAddress, int n, int n2) {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "getLastTriedExplicit");
        }
        int n3 = 0;
        n3 = FWHelper.getLastTriedInternal(inetAddress, n, n2, MODE_EXPLICIT);
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "getLastTriedExplicit");
        }
        return n3;
    }

    private static int getLastTriedInternal(InetAddress inetAddress, int n, int n2, int n3) {
        int n4;
        block14: {
            if (Trace.isOn) {
                Trace.entry(CLSNAME, "getLastTriedInternal");
            }
            if (Trace.isOn) {
                Trace.trace(2, CLSNAME, "getLastTriedInternal(" + inetAddress + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            n4 = 0;
            try {
                if (n3 == MODE_EXPLICIT) {
                    String string = n + " " + n2;
                    int[] nArray = (int[])fwRecords.get(string);
                    if (Trace.isOn) {
                        Trace.trace(2, CLSNAME, "Get explicit port for " + inetAddress + " " + string);
                    }
                    if (nArray != null && nArray.length != 0) {
                        n4 = nArray[0];
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(2, CLSNAME, "Error in format");
                        }
                        n4 = n - 1;
                    }
                } else {
                    Collection collection = fwRecords.values();
                    Iterator iterator = collection.iterator();
                    int n5 = n - 1;
                    while (iterator.hasNext()) {
                        int n6;
                        int[] nArray = (int[])iterator.next();
                        if (Trace.isOn) {
                            Trace.trace(2, CLSNAME, "Stored LastTry value: " + nArray[0]);
                        }
                        if (nArray == null || nArray.length == 0 || (n6 = nArray[0]) <= n5 || n6 >= n2) continue;
                        n5 = n6;
                    }
                    n4 = n5;
                }
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block14;
                Trace.exceptionTrace(2, CLSNAME, exception);
            }
        }
        FWHelper.debug("Last Tried Port: " + n4);
        if (Trace.isOn) {
            Trace.trace(2, CLSNAME, "getLastTriedInternal returns " + n4);
        }
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "getLastTriedInternal");
        }
        return n4;
    }

    static void setLastTried(InetAddress inetAddress, int n, int n2, int n3) {
        block8: {
            if (Trace.isOn) {
                Trace.entry(CLSNAME, "setLastTried");
            }
            try {
                String string = n + " " + n2;
                Object v = fwRecords.get(string);
                if (v == null) {
                    if (Trace.isOn) {
                        Trace.trace(2, CLSNAME, "Setting up storage for range " + string + ".");
                    }
                    fwRecords.put(string, new int[]{0});
                    v = fwRecords.get(string);
                }
                int[] nArray = (int[])v;
                if (Trace.isOn) {
                    Trace.trace(2, CLSNAME, "Setting data for range " + string + " to " + n3);
                }
                nArray[0] = n3;
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block8;
                Trace.exceptionTrace(2, CLSNAME, exception);
            }
        }
        if (Trace.isOn) {
            Trace.trace(2, CLSNAME, "LastTried (" + inetAddress.toString() + ", " + n + ", " + n2 + ") set to " + n3);
        }
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "setLastTried");
        }
    }

    public static void clearLocalAddressState() {
        block4: {
            if (Trace.isOn) {
                Trace.entry(CLSNAME, "clearLocalAddressState");
            }
            try {
                fwRecords.clear();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block4;
                Trace.exceptionTrace(2, CLSNAME, exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "clearLocalAddressState");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean fuzzyCompare(MQManagedConnectionJ11 mQManagedConnectionJ11, Object object) {
        boolean bl;
        block16: {
            boolean bl2;
            block15: {
                boolean bl3;
                block14: {
                    boolean bl4;
                    block13: {
                        boolean bl5;
                        block12: {
                            try {
                                block20: {
                                    int n;
                                    block18: {
                                        Object object2;
                                        InetAddress inetAddress;
                                        block19: {
                                            block17: {
                                                if (Trace.isOn) {
                                                    Trace.entry(CLSNAME, "fuzzyCompare");
                                                }
                                                inetAddress = null;
                                                n = 0;
                                                MQSESSION mQSESSION = mQManagedConnectionJ11.getMQSESSION();
                                                if (!(mQSESSION instanceof MQSESSIONClient)) break block17;
                                                object2 = (MQSESSIONClient)mQSESSION;
                                                inetAddress = ((MQSESSIONClient)object2).getLocalInetAddress();
                                                n = ((MQSESSIONClient)object2).getLocalBoundPort();
                                                object2 = FWHelper.decodeLocalAddress(object);
                                                if (object2 == null) break block18;
                                                break block19;
                                            }
                                            bl5 = false;
                                            Object var10_7 = null;
                                            if (!Trace.isOn) return bl5;
                                            break block12;
                                        }
                                        if (inetAddress == null || !((Object)inetAddress).equals(object2)) break block20;
                                    }
                                    if (Trace.isOn) {
                                        Trace.trace(2, CLSNAME, "Local address object matches.");
                                    }
                                    int n2 = FWHelper.decodePort(object, FW_START_PORT);
                                    int n3 = FWHelper.decodePort(object, FW_END_PORT);
                                    if (n3 == 0) {
                                        if (Trace.isOn) {
                                            Trace.trace(2, CLSNAME, "No port restrictrictions set.");
                                        }
                                        bl4 = true;
                                        break block13;
                                    }
                                    if (n >= n2 && n <= n3) {
                                        if (Trace.isOn) {
                                            Trace.trace(2, CLSNAME, "Bound port is within range");
                                        }
                                        bl3 = true;
                                        break block14;
                                    }
                                    if (Trace.isOn) {
                                        Trace.trace(2, CLSNAME, "Bound port " + n + " is outside range [" + n2 + ", " + n3 + "]");
                                    }
                                    bl2 = false;
                                    break block15;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(2, CLSNAME, "Local address object does not match");
                                }
                                bl = false;
                                break block16;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                if (!Trace.isOn) throw throwable;
                                Trace.exit(CLSNAME, "fuzzyCompare");
                                throw throwable;
                            }
                        }
                        Trace.exit(CLSNAME, "fuzzyCompare");
                        return bl5;
                    }
                    Object var10_8 = null;
                    if (!Trace.isOn) return bl4;
                    Trace.exit(CLSNAME, "fuzzyCompare");
                    return bl4;
                }
                Object var10_9 = null;
                if (!Trace.isOn) return bl3;
                Trace.exit(CLSNAME, "fuzzyCompare");
                return bl3;
            }
            Object var10_10 = null;
            if (!Trace.isOn) return bl2;
            Trace.exit(CLSNAME, "fuzzyCompare");
            return bl2;
        }
        Object var10_11 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(CLSNAME, "fuzzyCompare");
        return bl;
    }

    public static void setDebug(boolean bl) {
        block8: {
            if (Trace.isOn) {
                Trace.entry(CLSNAME, "setDebug");
            }
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "debug state: " + bl);
            }
            FW_DEBUG_ENABLED = bl;
            try {
                if (bl) {
                    File file = new File("firewall.dbg");
                    if (file.exists()) {
                        file.delete();
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    debug_out = new PrintWriter(fileWriter);
                    debug_out.println("MQJava Firewall Support - DEBUG started");
                    debug_out.println("---------------------------------------");
                } else {
                    debug_out.flush();
                    debug_out.close();
                }
            }
            catch (IOException iOException) {
                if (!Trace.isOn) break block8;
                Trace.trace(CLSNAME, "IOException: " + iOException.getMessage());
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "setDebug");
        }
    }

    static void debug(String string) {
        if (FW_DEBUG_ENABLED) {
            if (Trace.isOn) {
                Trace.entry(CLSNAME, "debug");
            }
            if (Trace.isOn) {
                Trace.trace(CLSNAME, string);
            }
            if (debug_out != null) {
                debug_out.println(string);
            }
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "debug");
            }
        }
    }
}

