/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQConnectionRequestInfo;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mqservices.Trace;
import java.util.Hashtable;
import javax.resource.spi.ConnectionRequestInfo;

class ClientConnectionRequestInfo
extends MQConnectionRequestInfo
implements Cloneable,
ConnectionRequestInfo {
    private static final String sccsid = "javabase/com/ibm/mq/ClientConnectionRequestInfo.java, java, j5306, j5306-11-050701  04/04/29 12:52:09 @(#) 1.22.1.2";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5648-C60 (c) Copyright IBM Corp. 1996, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public int connectOptions;
    public MQSecurityExit securityExit;
    public MQSendExit sendExit;
    public MQReceiveExit receiveExit;
    public String userName;
    public String password;
    public boolean xaRequired;
    public boolean useQmCcsid;
    public Boolean useBatching = null;
    public Integer batchFloor = null;
    public Integer batchCeiling = null;
    public Integer batchThreshold = null;
    public Integer batchInterval = null;
    public String spi;
    public String sslCipherSuite = null;
    public String sslPeername = null;
    public Object sslCertStores = null;
    public Object sslSocketFactory = null;
    public Object localAddress = "";

    ClientConnectionRequestInfo(Hashtable hashtable) throws MQException {
        Trace.entry("Uninitialized object", "ClientConnectionRequestInfo constructor");
        this.hasVariablePortion = true;
        this.connectOptions = MQEnvironment.getIntegerProperty("connectOptions", hashtable);
        this.securityExit = (MQSecurityExit)MQEnvironment.getObjectProperty("securityExit", hashtable);
        this.receiveExit = (MQReceiveExit)MQEnvironment.getObjectProperty("receiveExit", hashtable);
        this.sendExit = (MQSendExit)MQEnvironment.getObjectProperty("sendExit", hashtable);
        this.userName = MQEnvironment.getStringProperty("userID", hashtable);
        this.password = MQEnvironment.getStringProperty("password", hashtable);
        this.spi = MQEnvironment.getStringProperty("SPI", hashtable);
        this.sslCipherSuite = MQEnvironment.getStringProperty("SSL Cipher Suite", hashtable);
        this.sslPeername = MQEnvironment.getStringProperty("SSL Peer Name", hashtable);
        this.sslCertStores = MQEnvironment.getObjectProperty("SSL CertStores", hashtable);
        this.sslSocketFactory = MQEnvironment.getObjectProperty("SSL Socket Factory", hashtable);
        String string = MQEnvironment.getStringProperty("Local Address Property", hashtable);
        if (string != null) {
            this.localAddress = FWHelper.encodeToObject(string);
        }
        if (hashtable != null) {
            Object v;
            this.xaRequired = false;
            Object v2 = hashtable.get("XAReq");
            if (v2 != null && v2 instanceof Boolean) {
                this.xaRequired = (Boolean)v2;
            }
            this.useQmCcsid = false;
            Object v3 = hashtable.get("Use QM CCSID");
            if (v3 != null && v3 instanceof Boolean) {
                this.useQmCcsid = (Boolean)v3;
            }
            if ((v = hashtable.get("Batching enabled")) != null && v instanceof Boolean) {
                this.useBatching = (Boolean)v;
            }
            if ((v = hashtable.get("Batch size floor")) != null && v instanceof Integer) {
                this.batchFloor = (Integer)v;
            }
            if ((v = hashtable.get("Batch size ceiling")) != null && v instanceof Integer) {
                this.batchCeiling = (Integer)v;
            }
            if ((v = hashtable.get("Batching threshold")) != null && v instanceof Integer) {
                this.batchThreshold = (Integer)v;
            }
            if ((v = hashtable.get("Batch interval")) != null && v instanceof Integer) {
                this.batchInterval = (Integer)v;
            }
        }
        Trace.exit(this, "ClientConnectionRequestInfo constructor");
    }

    public int variableHashCode() {
        int n = 0;
        if (this.localAddress != null) {
            n += 101 * this.localAddress.hashCode();
        }
        return n;
    }

    public int fixedHashCode() {
        int n = 31 * this.connectOptions;
        if (this.userName != null) {
            n += 37 * this.userName.hashCode();
        }
        if (this.xaRequired) {
            n += 43;
        }
        if (this.useQmCcsid) {
            n += 47;
        }
        if (this.spi != null) {
            n += 53 * this.spi.hashCode();
        }
        if (this.useBatching != null) {
            n += 59 * this.useBatching.hashCode();
        }
        if (this.batchFloor != null) {
            n += 61 * this.batchFloor.hashCode();
        }
        if (this.batchCeiling != null) {
            n += 67 * this.batchCeiling.hashCode();
        }
        if (this.batchThreshold != null) {
            n += 71 * this.batchThreshold.hashCode();
        }
        if (this.batchInterval != null) {
            n += 73 * this.batchInterval.hashCode();
        }
        if (this.sslCipherSuite != null) {
            n += 79 * this.sslCipherSuite.hashCode();
        }
        if (this.sslPeername != null) {
            n += 83 * this.sslPeername.hashCode();
        }
        if (this.sslCertStores != null) {
            n += 89 * this.sslCertStores.hashCode();
        }
        if (this.sslSocketFactory != null) {
            n += 97 * this.sslSocketFactory.hashCode();
        }
        return n;
    }

    public boolean variableIsSuitable(MQManagedConnectionJ11 mQManagedConnectionJ11) {
        if (mQManagedConnectionJ11 == null) {
            return false;
        }
        MQManagedConnectionJ11 mQManagedConnectionJ112 = mQManagedConnectionJ11;
        synchronized (mQManagedConnectionJ112) {
            if (!FWHelper.fuzzyCompare(mQManagedConnectionJ11, this.localAddress)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean fixedEquals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        ClientConnectionRequestInfo clientConnectionRequestInfo = (ClientConnectionRequestInfo)object;
        try {
            if (this.connectOptions == clientConnectionRequestInfo.connectOptions && this.userName.equals(clientConnectionRequestInfo.userName) && this.password.equals(clientConnectionRequestInfo.password) && (this.securityExit == clientConnectionRequestInfo.securityExit || this.securityExit != null && clientConnectionRequestInfo.securityExit != null && this.securityExit.equals(clientConnectionRequestInfo.securityExit)) && (this.sendExit == clientConnectionRequestInfo.sendExit || this.sendExit != null && clientConnectionRequestInfo.sendExit != null && this.sendExit.equals(clientConnectionRequestInfo.sendExit)) && (this.receiveExit == clientConnectionRequestInfo.receiveExit || this.receiveExit != null && clientConnectionRequestInfo.receiveExit != null && this.receiveExit.equals(clientConnectionRequestInfo.receiveExit)) && this.xaRequired == clientConnectionRequestInfo.xaRequired && this.useQmCcsid == clientConnectionRequestInfo.useQmCcsid && this.objEquals(this.spi, clientConnectionRequestInfo.spi) && this.objEquals(this.useBatching, clientConnectionRequestInfo.useBatching) && this.objEquals(this.batchFloor, clientConnectionRequestInfo.batchFloor) && this.objEquals(this.batchCeiling, clientConnectionRequestInfo.batchCeiling) && this.objEquals(this.batchThreshold, clientConnectionRequestInfo.batchThreshold) && this.objEquals(this.batchInterval, clientConnectionRequestInfo.batchInterval) && this.objEquals(this.sslCipherSuite, clientConnectionRequestInfo.sslCipherSuite) && this.objEquals(this.sslPeername, clientConnectionRequestInfo.sslPeername) && this.objEquals(this.sslCertStores, clientConnectionRequestInfo.sslCertStores) && this.objEquals(this.sslSocketFactory, clientConnectionRequestInfo.sslSocketFactory)) {
                return true;
            }
        }
        catch (Exception exception) {
            Trace.trace(this, "fixedEquals caught exception:");
            Trace.trace(this, exception.toString());
        }
        return false;
    }

    public boolean variableEquals(Object object) {
        ClientConnectionRequestInfo clientConnectionRequestInfo = (ClientConnectionRequestInfo)object;
        return this.objEquals(this.localAddress, clientConnectionRequestInfo.localAddress);
    }
}

