/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQC;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;

class BatchMatchingCriteria {
    private static final String sccsid = "javabase/com/ibm/mq/BatchMatchingCriteria.java, java, j5306, j5306-11-050701 03/12/11 10:42:09 @(#) 1.1.6.1";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5639-B43 (c) Copyright IBM Corp. 1997, 1999, 2001   All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int options;
    private int matchOptions;
    private String msgId;
    private String correlId;
    private String groupId;
    protected int hcon;
    protected int hobj;
    private int msgSeqNum;
    private int offset;

    BatchMatchingCriteria() {
    }

    public String toString() {
        String string = "MatchingCriteria: msgId=" + this.msgId + " correlId=" + this.correlId + " groupId=" + this.groupId + " hcon=" + this.hcon + " hobj=" + this.hobj + " msgSeqNum=" + this.msgSeqNum + " offset=" + this.offset + " options=" + this.options + " matchOptions=" + this.matchOptions;
        return string;
    }

    protected void set(BatchMatchingCriteria batchMatchingCriteria) {
        this.options = batchMatchingCriteria.options;
        this.matchOptions = batchMatchingCriteria.matchOptions;
        this.msgId = new String(batchMatchingCriteria.msgId);
        this.correlId = new String(batchMatchingCriteria.correlId);
        this.groupId = new String(batchMatchingCriteria.groupId);
        this.hcon = batchMatchingCriteria.hcon;
        this.hobj = batchMatchingCriteria.hobj;
        this.msgSeqNum = batchMatchingCriteria.msgSeqNum;
        this.offset = batchMatchingCriteria.offset;
    }

    protected void set(int n, int n2, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) {
        this.hcon = n;
        this.hobj = n2;
        this.options = mQGetMessageOptions.options;
        this.matchOptions = mQGetMessageOptions.matchOptions;
        if ((this.matchOptions & 1) == 1) {
            this.msgId = new String(mQMsg2.getMessageId());
            if (this.msgId.equals(MQC.MQMI_NONE)) {
                this.matchOptions &= 0xFFFFFFFE;
            }
        } else {
            this.msgId = "";
        }
        if ((this.matchOptions & 2) == 2) {
            this.correlId = new String(mQMsg2.getCorrelationId());
            if (this.correlId.equals(MQC.MQCI_NONE)) {
                this.matchOptions &= 0xFFFFFFFD;
            }
        } else {
            this.correlId = "";
        }
        if ((this.matchOptions & 4) == 4) {
            this.groupId = new String(mQMsg2.getGroupId());
            if (this.groupId.equals(MQC.MQGI_NONE)) {
                this.matchOptions &= 0xFFFFFFFB;
            }
        } else {
            this.groupId = "";
        }
        this.msgSeqNum = (this.matchOptions & 8) == 8 ? mQMsg2.getMessageSequenceNumber() : 0;
        this.offset = (this.matchOptions & 0x10) == 16 ? mQMsg2.getOffset() : 0;
    }

    protected boolean matches(BatchMatchingCriteria batchMatchingCriteria) {
        boolean bl = false;
        if (this.hobj == batchMatchingCriteria.hobj && this.hcon == batchMatchingCriteria.hcon && this.options == batchMatchingCriteria.options && this.matchOptions == batchMatchingCriteria.matchOptions) {
            bl = true;
            if ((this.matchOptions & 1) == 1) {
                boolean bl2 = bl = bl && this.msgId.equals(batchMatchingCriteria.msgId);
            }
            if ((this.matchOptions & 2) == 2) {
                boolean bl3 = bl = bl && this.correlId.equals(batchMatchingCriteria.correlId);
            }
            if ((this.matchOptions & 4) == 4) {
                boolean bl4 = bl = bl && this.groupId.equals(batchMatchingCriteria.groupId);
            }
            if ((this.matchOptions & 8) == 8) {
                boolean bl5 = bl = bl && this.msgSeqNum == batchMatchingCriteria.msgSeqNum;
            }
            if ((this.matchOptions & 0x10) == 16) {
                bl = bl && this.offset == batchMatchingCriteria.offset;
            }
        }
        return bl;
    }
}

