/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.util.Collections;
import java.util.List;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.engine.SQLParameter;

public class TimeStatInterceptor
implements Interceptor {
    List<String> excludes = null;
    long max;

    public TimeStatInterceptor(long max) {
        this(Collections.emptyList(), max);
    }

    public TimeStatInterceptor(List<String> excludes, long max) {
        this.excludes = excludes;
    }

    @Override
    public void before(InterceptorContext ctx) {
        if (this.excludes.contains(ctx.getSqlId())) {
            return;
        }
        ctx.put("stat.time", System.currentTimeMillis());
    }

    @Override
    public void after(InterceptorContext ctx) {
        long start;
        if (this.excludes.contains(ctx.getSqlId())) {
            return;
        }
        long end = System.currentTimeMillis();
        if (end - (start = ((Long)ctx.get("stat.time")).longValue()) > this.max) {
            this.print(ctx.getSqlId(), ctx.getSql(), ctx.getParas(), end - start);
        }
    }

    protected void print(String sqlId, String sql, List<SQLParameter> paras, long time) {
        System.err.println("sqlId=" + sqlId + " time:" + time);
        System.out.println("=====================");
        System.out.println(sql);
    }

    @Override
    public void exception(InterceptorContext ctx, Exception ex) {
    }
}

