/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.orm;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.orm.LazyEntity;
import org.beetl.sql.core.orm.MappingEntity;

public class LazyMappingEntity
extends MappingEntity {
    @Override
    public void map(List list, SQLManager sm, Map paras) {
        if (list.size() == 0) {
            return;
        }
        this.init(list.get(0), sm.getEntityLoader());
        for (Object obj : list) {
            this.mapClassItem(obj, sm, paras);
        }
    }

    @Override
    protected void mapClassItem(Object obj, SQLManager sm, Map sqlParas) {
        final String sqlManagerName = sm.getSQLManagerName();
        if (this.sqlId != null) {
            final HashMap<String, Object> paras = new HashMap<String, Object>();
            if (sqlParas != null && !sqlParas.isEmpty()) {
                paras.putAll(sqlParas);
            }
            for (Map.Entry entry : this.mapkey.entrySet()) {
                String attr = (String)entry.getKey();
                String targetAttr = (String)entry.getValue();
                Object value = BeanKit.getBeanProperty(obj, attr);
                paras.put(targetAttr, value);
            }
            LazyEntity lazy = new LazyEntity(){

                @Override
                public Object get() {
                    SQLManager sqlManager = LazyMappingEntity.this.getSQLManager(sqlManagerName);
                    List ret = sqlManager.select(LazyMappingEntity.this.sqlId, LazyMappingEntity.this.targetClass, paras);
                    return LazyMappingEntity.this.retValue(ret);
                }
            };
            this.setTailAttr(obj, lazy);
        } else {
            if (this.mapkey.size() == 1) {
                String tableName = sm.getNc().getTableName(this.targetClass);
                TableDesc tableDesc = sm.getMetaDataManager().getTable(tableName);
                ClassDesc classDesc = tableDesc.getClassDesc(this.targetClass, sm.getNc());
                if (classDesc.getIdAttrs().size() == 1 && classDesc.getIdAttrs().containsAll(this.mapkey.values())) {
                    String foreignAttr = (String)this.mapkey.keySet().iterator().next();
                    final Object value = BeanKit.getBeanProperty(obj, foreignAttr);
                    LazyEntity lazy = new LazyEntity(){

                        @Override
                        public Object get() {
                            SQLManager sqlManager = LazyMappingEntity.this.getSQLManager(sqlManagerName);
                            Object ret = sqlManager.single(LazyMappingEntity.this.targetClass, value);
                            return ret;
                        }
                    };
                    this.setTailAttr(obj, lazy);
                    return;
                }
            }
            final Object ins = this.getIns(this.targetClass);
            for (Map.Entry entry : this.mapkey.entrySet()) {
                String attr = (String)entry.getKey();
                String targetAttr = (String)entry.getValue();
                Object value = BeanKit.getBeanProperty(obj, attr);
                BeanKit.setBeanProperty(ins, value, targetAttr);
            }
            LazyEntity lazy = new LazyEntity(){

                @Override
                public Object get() {
                    SQLManager sqlManager = LazyMappingEntity.this.getSQLManager(sqlManagerName);
                    List<Object> ret = sqlManager.template(ins);
                    return LazyMappingEntity.this.retValue(ret);
                }
            };
            this.setTailAttr(obj, lazy);
        }
    }

    @Override
    protected void setTailAttr(Object o, Object value) {
        if (o instanceof Tail) {
            ((Tail)o).set(this.tailName, value);
        } else {
            Method m = BeanKit.getTailMethod(o.getClass());
            if (m == null) {
                throw new RuntimeException("\u61d2\u52a0\u8f7d OR/Mapping \u5fc5\u987b\u5b9e\u73b0Tail\u63a5\u53e3,\u7528\u4e8e\u8bbe\u7f6e " + this.tailName + "\u5bf9\u8c61\uff0c\u6216\u8005\u4e0d\u4f7f\u7528\u61d2\u52a0\u8f7d");
            }
            try {
                m.invoke(o, this.tailName, value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Object retValue(List ret) {
        if (this.isSingle) {
            if (ret.isEmpty()) {
                return null;
            }
            return ret.get(0);
        }
        return ret;
    }

    private SQLManager getSQLManager(String name) {
        return SQLManager.getSQLManagerByName(name);
    }
}

