/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.Map;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.db.SqlServerStyle;

public class SqlServer2012Style
extends SqlServerStyle {
    @Override
    protected String getOrderBy() {
        return this.lineSeparator + this.HOLDER_START + "text(' order by ' + _orderBy!'current_timestamp')" + this.HOLDER_END + " ";
    }

    @Override
    public String getPageSQL(String sql) {
        StringBuilder builder = new StringBuilder(sql);
        if (!sql.matches("(?is).*pageIgnoreTag\\s*\\(\\s*\\)[^}]*?order\\s+by.*|.*\\s+order\\s+by[^)]+$")) {
            builder.append(this.getOrderBy());
        }
        return builder.append(" offset ").append(this.HOLDER_START).append("_pageOffset").append(this.HOLDER_END).append(" rows fetch next ").append(this.HOLDER_START).append("_pageSize").append(this.HOLDER_END).append(" rows only ").toString();
    }

    @Override
    public String getPageSQLStatement(String sql, long offset, long pageSize) {
        StringBuilder builder = new StringBuilder(sql);
        if (!sql.matches("(?is).*\\s+order\\s+by[^)]+$")) {
            builder.append(" order by current_timestamp ");
        }
        return builder.append(" offset ").append(PageParamKit.sqlServer2012Offset(this.offsetStartZero, offset)).append(" rows fetch next ").append(pageSize).append(" rows only ").toString();
    }

    @Override
    public void initPagePara(Map<String, Object> param, long start, long size) {
        param.put("_pageOffset", start - (long)(this.offsetStartZero ? 0 : 1));
        param.put("_pageSize", size);
    }
}

