/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.LinkedHashMap;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.Tag;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.TagStatement;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarDefineNode;
import org.beetl.ext.tag.HTMLTagVarBindingWrapper;

public class TagVarBindingStatement
extends TagStatement {
    VarDefineNode[] varIndexs;

    public TagVarBindingStatement(String tagName, Expression[] paras, Statement block, VarDefineNode[] varDefine, GrammarToken token) {
        super(tagName, paras, block, token);
        this.varIndexs = varDefine;
    }

    @Override
    protected void runTag(Tag tag, Context ctx) {
        try {
            LinkedHashMap<String, Integer> indexMap;
            HTMLTagVarBindingWrapper htmlTag;
            if (tag instanceof HTMLTagVarBindingWrapper) {
                htmlTag = (HTMLTagVarBindingWrapper)tag;
                Object[] vars = htmlTag.bindVars();
                if (vars != null) {
                    for (int i = 0; i < vars.length; ++i) {
                        ctx.vars[this.varIndexs[i].getVarIndex()] = vars[i];
                    }
                }
                indexMap = new LinkedHashMap<String, Integer>(this.varIndexs.length);
                for (VarDefineNode node : this.varIndexs) {
                    indexMap.put(node.token.text, node.varIndex);
                }
            } else {
                BeetlException be = new BeetlException("ERROR", "tag\u5fc5\u987b\u662fHTMLTagVarBindingWrapper");
                be.pushToken(this.token);
                throw be;
            }
            htmlTag.mapName2Index(indexMap);
            tag.render();
        }
        catch (BeetlException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException be = new BeetlException("ERROR", "tag\u6267\u884c\u629b\u9519", ex);
            be.pushToken(this.token);
            throw be;
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        for (Expression exp : this.paras) {
            exp.infer(inferCtx);
        }
        for (int i = 0; i < this.varIndexs.length; ++i) {
            inferCtx.types[this.varIndexs[i].getVarIndex()] = Type.ObjectType;
        }
        this.block.infer(inferCtx);
    }
}

