/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.ArrayList;
import java.util.List;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Type;

public class JsonArrayExpression
extends Expression {
    public Expression[] array;

    public JsonArrayExpression(List<Expression> list, GrammarToken token) {
        super(token);
        this.array = list.toArray(new Expression[0]);
    }

    @Override
    public Object evaluate(Context ctx) {
        if (this.array.length == 0) {
            return new ArrayList();
        }
        ArrayList<Object> values = new ArrayList<Object>(this.array.length);
        for (Expression exp : this.array) {
            values.add(exp.evaluate(ctx));
        }
        return values;
    }

    @Override
    public void infer(InferContext inferCtx) {
        for (Expression exp : this.array) {
            exp.infer(inferCtx);
        }
        this.type = Type.ListType;
    }
}

