/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cdn.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cdn.v1.model.Sources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DomainBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="domain_name")
    private String domainName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="business_type")
    private BusinessTypeEnum businessType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sources")
    private List<Sources> sources = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="service_area")
    private ServiceAreaEnum serviceArea;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="enterprise_project_id")
    private String enterpriseProjectId;

    public DomainBody withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DomainBody withBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        return this;
    }

    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
    }

    public DomainBody withSources(List<Sources> sources) {
        this.sources = sources;
        return this;
    }

    public DomainBody addSourcesItem(Sources sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<Sources>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    public DomainBody withSources(Consumer<List<Sources>> sourcesSetter) {
        if (this.sources == null) {
            this.sources = new ArrayList<Sources>();
        }
        sourcesSetter.accept(this.sources);
        return this;
    }

    public List<Sources> getSources() {
        return this.sources;
    }

    public void setSources(List<Sources> sources) {
        this.sources = sources;
    }

    public DomainBody withServiceArea(ServiceAreaEnum serviceArea) {
        this.serviceArea = serviceArea;
        return this;
    }

    public ServiceAreaEnum getServiceArea() {
        return this.serviceArea;
    }

    public void setServiceArea(ServiceAreaEnum serviceArea) {
        this.serviceArea = serviceArea;
    }

    public DomainBody withEnterpriseProjectId(String enterpriseProjectId) {
        this.enterpriseProjectId = enterpriseProjectId;
        return this;
    }

    public String getEnterpriseProjectId() {
        return this.enterpriseProjectId;
    }

    public void setEnterpriseProjectId(String enterpriseProjectId) {
        this.enterpriseProjectId = enterpriseProjectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainBody domainBody = (DomainBody)o;
        return Objects.equals(this.domainName, domainBody.domainName) && Objects.equals(this.businessType, domainBody.businessType) && Objects.equals(this.sources, domainBody.sources) && Objects.equals(this.serviceArea, domainBody.serviceArea) && Objects.equals(this.enterpriseProjectId, domainBody.enterpriseProjectId);
    }

    public int hashCode() {
        return Objects.hash(this.domainName, this.businessType, this.sources, this.serviceArea, this.enterpriseProjectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainBody {\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    businessType: ").append(this.toIndentedString(this.businessType)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    serviceArea: ").append(this.toIndentedString(this.serviceArea)).append("\n");
        sb.append("    enterpriseProjectId: ").append(this.toIndentedString(this.enterpriseProjectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ServiceAreaEnum {
        public static final ServiceAreaEnum MAINLAND_CHINA = new ServiceAreaEnum("mainland_china");
        public static final ServiceAreaEnum OUTSIDE_MAINLAND_CHINA = new ServiceAreaEnum("outside_mainland_china");
        public static final ServiceAreaEnum GLOBAL = new ServiceAreaEnum("global");
        private static final Map<String, ServiceAreaEnum> STATIC_FIELDS = ServiceAreaEnum.createStaticFields();
        private String value;

        private static Map<String, ServiceAreaEnum> createStaticFields() {
            HashMap<String, ServiceAreaEnum> map = new HashMap<String, ServiceAreaEnum>();
            map.put("mainland_china", MAINLAND_CHINA);
            map.put("outside_mainland_china", OUTSIDE_MAINLAND_CHINA);
            map.put("global", GLOBAL);
            return Collections.unmodifiableMap(map);
        }

        ServiceAreaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceAreaEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            ServiceAreaEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new ServiceAreaEnum(value);
            }
            return result;
        }

        public static ServiceAreaEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            ServiceAreaEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ServiceAreaEnum) {
                return this.value.equals(((ServiceAreaEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class BusinessTypeEnum {
        public static final BusinessTypeEnum WEB = new BusinessTypeEnum("web");
        public static final BusinessTypeEnum DOWNLOAD = new BusinessTypeEnum("download");
        public static final BusinessTypeEnum VIDEO = new BusinessTypeEnum("video");
        public static final BusinessTypeEnum WHOLESITE = new BusinessTypeEnum("wholeSite");
        private static final Map<String, BusinessTypeEnum> STATIC_FIELDS = BusinessTypeEnum.createStaticFields();
        private String value;

        private static Map<String, BusinessTypeEnum> createStaticFields() {
            HashMap<String, BusinessTypeEnum> map = new HashMap<String, BusinessTypeEnum>();
            map.put("web", WEB);
            map.put("download", DOWNLOAD);
            map.put("video", VIDEO);
            map.put("wholeSite", WHOLESITE);
            return Collections.unmodifiableMap(map);
        }

        BusinessTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BusinessTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            BusinessTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new BusinessTypeEnum(value);
            }
            return result;
        }

        public static BusinessTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            BusinessTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof BusinessTypeEnum) {
                return this.value.equals(((BusinessTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

