/**
 * Copyright 2019 Huawei Technologies Co.,Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.obs.services.internal.security;

import com.obs.services.model.ISecurityKey;

public class BasicSecurityKey implements ISecurityKey {
    protected String accessKey;
    protected String secretKey;
    protected String securityToken;

    public BasicSecurityKey(String accessKey, String secretKey){
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public BasicSecurityKey(String accessKey, String secretKey, String securityToken){
        this(accessKey, secretKey);
        this.securityToken = securityToken;
    }

    @Override
    public String getAccessKey() {
        return accessKey;
    }

    @Override
    public String getSecretKey() {
        return secretKey;
    }

    @Override
    public String getSecurityToken() {
        return securityToken;
    }
}
