/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.io.MayRepeatableInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class RepeatableRequestEntity
extends RequestBody
implements Closeable {
    private static final ILogger interfaceLog = LoggerBuilder.getLogger("com.obs.services.internal.RestStorageService");
    private String contentType;
    private long contentLength = -1L;
    private volatile long bytesWritten = 0L;
    private InputStream inputStream;
    private final int writeBufferSize = 4096;

    public RepeatableRequestEntity(InputStream is, String contentType, long contentLength, ObsProperties obsProperties) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.inputStream = is;
        this.contentLength = contentLength;
        this.contentType = contentType;
        if (!(this.inputStream instanceof MayRepeatableInputStream)) {
            this.inputStream = new MayRepeatableInputStream(is, obsProperties.getIntProperty("httpclient.write-buffer-size", 8192));
        }
        this.inputStream.mark(0);
    }

    public long contentLength() throws IOException {
        return this.contentLength;
    }

    public boolean isRepeatable() {
        return this.inputStream == null || this.inputStream.markSupported();
    }

    protected void writeToNIO(BufferedSink out) throws IOException {
        ReadableByteChannel in = Channels.newChannel(this.inputStream);
        WritableByteChannel ou = Channels.newChannel(out.outputStream());
        ByteBuffer buffer = ByteBuffer.allocate(this.writeBufferSize);
        int count = 0;
        if (this.contentLength < 0L) {
            count = in.read(buffer);
            while (count > 0) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    ou.write(buffer);
                }
                buffer.clear();
                this.bytesWritten += (long)count;
                count = in.read(buffer);
            }
        } else {
            for (long remaining = this.contentLength; remaining > 0L && (count = in.read(buffer)) > 0; remaining -= (long)count) {
                this.getClass();
                buffer.position((int)Math.min(4096L, remaining));
                buffer.flip();
                while (buffer.hasRemaining()) {
                    ou.write(buffer);
                }
                buffer.clear();
                this.bytesWritten += (long)count;
            }
        }
    }

    protected void writeToBIO(BufferedSink out) throws IOException {
        byte[] tmp = new byte[this.writeBufferSize];
        int count = 0;
        if (this.contentLength < 0L) {
            count = this.inputStream.read(tmp);
            while (count != -1) {
                this.bytesWritten += (long)count;
                out.write(tmp, 0, count);
                count = this.inputStream.read(tmp);
            }
        } else {
            for (long remaining = this.contentLength; remaining > 0L; remaining -= (long)count) {
                this.getClass();
                count = this.inputStream.read(tmp, 0, (int)Math.min(4096L, remaining));
                if (count != -1) {
                    out.write(tmp, 0, count);
                    this.bytesWritten += (long)count;
                    continue;
                }
                break;
            }
        }
    }

    public MediaType contentType() {
        return MediaType.parse((String)(this.contentType == null ? "application/octet-stream" : this.contentType));
    }

    public void writeTo(BufferedSink sink) throws IOException {
        long start = System.currentTimeMillis();
        if (this.bytesWritten > 0L) {
            this.inputStream.reset();
            this.bytesWritten = 0L;
        }
        this.writeToBIO(sink);
        if (interfaceLog.isInfoEnabled()) {
            interfaceLog.info("write data end, cost " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

