/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.DefaultProgressStatus;
import com.obs.services.internal.ProgressManager;
import com.obs.services.model.ProgressListener;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentProgressManager
extends ProgressManager {
    private AtomicBoolean startFlag = new AtomicBoolean(false);
    private AtomicBoolean endFlag = new AtomicBoolean(false);
    protected AtomicLong transferredBytes;
    protected AtomicLong newlyTransferredBytes;

    public ConcurrentProgressManager(long totalBytes, long transferredBytes, ProgressListener progressListener, long intervalBytes) {
        super(totalBytes, progressListener, intervalBytes);
        this.transferredBytes = transferredBytes < 0L ? new AtomicLong(0L) : new AtomicLong(transferredBytes);
        this.newlyTransferredBytes = new AtomicLong(0L);
    }

    public void progressStart() {
        if (this.startFlag.compareAndSet(false, true)) {
            super.progressStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnd() {
        if (this.progressListener == null) {
            return;
        }
        ConcurrentProgressManager concurrentProgressManager = this;
        synchronized (concurrentProgressManager) {
            Date now = new Date();
            DefaultProgressStatus status = new DefaultProgressStatus(this.newlyTransferredBytes.get(), this.transferredBytes.get(), this.totalBytes, now.getTime() - this.lastCheckpoint.getTime(), now.getTime() - this.startCheckpoint.getTime());
            this.progressListener.progressChanged(status);
        }
    }

    protected void doProgressChanged(int bytes) {
        List<ProgressManager.BytesUnit> currentInstantaneousBytes;
        long _transferredBytes = this.transferredBytes.addAndGet(bytes);
        long _newlyTransferredBytes = this.newlyTransferredBytes.addAndGet(bytes);
        Date now = new Date();
        this.lastInstantaneousBytes = currentInstantaneousBytes = this.createCurrentInstantaneousBytes(bytes, now);
        if (_newlyTransferredBytes >= this.intervalBytes && (_transferredBytes < this.totalBytes || this.totalBytes == -1L) && this.newlyTransferredBytes.compareAndSet(_newlyTransferredBytes, -_newlyTransferredBytes)) {
            DefaultProgressStatus status = new DefaultProgressStatus(_newlyTransferredBytes, _transferredBytes, this.totalBytes, now.getTime() - this.lastCheckpoint.getTime(), now.getTime() - this.startCheckpoint.getTime());
            status.setInstantaneousBytes(currentInstantaneousBytes);
            this.progressListener.progressChanged(status);
            this.lastCheckpoint = now;
        }
    }
}

