/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbstractTemporarySignatureRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.PolicyConditionItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTempSignatureRequest
extends AbstractTemporarySignatureRequest {
    private Date expiryDate;
    private long expires = 300L;
    private List<PolicyConditionItem> conditions;

    public PolicyTempSignatureRequest() {
    }

    public PolicyTempSignatureRequest(HttpMethodEnum method, String bucketName, String objectKey) {
        super(method, bucketName, objectKey);
    }

    public PolicyTempSignatureRequest(HttpMethodEnum method, String bucketName, String objectKey, Date expiryDate) {
        super(method, bucketName, objectKey);
        this.expiryDate = expiryDate;
    }

    public PolicyTempSignatureRequest(HttpMethodEnum method, String bucketName, String objectKey, long expires) {
        super(method, bucketName, objectKey);
        this.expires = expires;
    }

    public String generatePolicy() {
        Date requestDate = new Date();
        SimpleDateFormat expirationDateFormat = ServiceUtils.getExpirationDateFormat();
        Date expiryDate = this.expiryDate;
        if (expiryDate == null) {
            expiryDate = new Date(requestDate.getTime() + (this.expires <= 0L ? 300L : this.expires) * 1000L);
        }
        String expiration = expirationDateFormat.format(expiryDate);
        StringBuilder policy = new StringBuilder();
        policy.append("{\"expiration\":").append("\"").append(expiration).append("\",").append("\"conditions\":[");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            policy.append(ServiceUtils.join(this.conditions, ","));
        }
        policy.append("]}");
        return policy.toString();
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public List<PolicyConditionItem> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<PolicyConditionItem> conditions) {
        this.conditions = conditions;
    }
}

