/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.model.AuthTypeEnum;

public class ProviderCredentials {
    protected static final ILogger log = LoggerBuilder.getLogger(ProviderCredentials.class);
    protected String accessKey;
    protected String secretKey;
    protected AuthTypeEnum authType;
    private String securityToken;
    private ThreadLocal<AuthTypeEnum> threadLocalAuthType;

    public String getRegion() {
        return "region";
    }

    public ProviderCredentials(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public ProviderCredentials(String accessKey, String secretKey, String securityToken) {
        this(accessKey, secretKey);
        this.securityToken = securityToken;
    }

    public AuthTypeEnum getAuthType() {
        return this.threadLocalAuthType == null ? this.authType : this.threadLocalAuthType.get();
    }

    public void setAuthType(AuthTypeEnum authType) {
        this.authType = authType;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setThreadLocalAuthType(AuthTypeEnum authType) {
        if (this.threadLocalAuthType != null) {
            this.threadLocalAuthType.set(authType);
        }
    }

    public void removeThreadLocalAuthType() {
        if (this.threadLocalAuthType != null) {
            this.threadLocalAuthType.remove();
        }
    }

    public void initThreadLocalAuthType() {
        if (this.threadLocalAuthType == null) {
            this.threadLocalAuthType = new ThreadLocal<AuthTypeEnum>(){

                @Override
                protected AuthTypeEnum initialValue() {
                    return ProviderCredentials.this.authType;
                }
            };
        }
    }
}

