/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.InterfaceLogBean;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.ObsCallback;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.OefExceptionMessage;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.consensus.CacheManager;
import com.obs.services.internal.consensus.SegmentLock;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.UnrecoverableIOException;
import com.obs.services.internal.security.ProviderCredentialThreadContext;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.utils.IAuthentication;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.utils.V4Authentication;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpMethodEnum;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestStorageService {
    private static final ILogger log = LoggerBuilder.getLogger(RestStorageService.class);
    private static final Set<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>();
    private static final String REQUEST_TIMEOUT_CODE = "RequestTimeout";
    protected OkHttpClient httpClient;
    protected AtomicBoolean shuttingDown = new AtomicBoolean(false);
    protected ObsProperties obsProperties;
    protected volatile ProviderCredentials credentials;
    protected KeyManagerFactory keyManagerFactory;
    protected TrustManagerFactory trustManagerFactory;
    protected CacheManager apiVersionCache;
    protected SegmentLock segmentLock;
    protected Semaphore semaphore;

    protected RestStorageService() {
    }

    protected void initHttpClient(Dispatcher httpDispatcher) {
        OkHttpClient.Builder builder = RestUtils.initHttpClientBuilder(this, this.obsProperties, this.keyManagerFactory, this.trustManagerFactory, httpDispatcher);
        if (this.obsProperties.getBoolProperty("httpclient.proxy-enable", true)) {
            String proxyHostAddress = this.obsProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.obsProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.obsProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.obsProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.obsProperties.getStringProperty("httpclient.proxy-domain", null);
            String proxyWorkstation = this.obsProperties.getStringProperty("httpclient.proxy-workstation", null);
            RestUtils.initHttpProxy(builder, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, proxyWorkstation);
        }
        this.httpClient = builder.build();
        int maxConnections = this.obsProperties.getIntProperty("httpclient.max-connections", 1000);
        this.semaphore = new Semaphore(maxConnections);
    }

    protected void shutdownImpl() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            this.credentials = null;
            this.obsProperties = null;
            if (this.httpClient != null) {
                try {
                    Method dispatcherMethod = this.httpClient.getClass().getMethod("dispatcher", new Class[0]);
                    if (dispatcherMethod != null) {
                        Method m = dispatcherMethod.invoke((Object)this.httpClient, new Object[0]).getClass().getDeclaredMethod("executorService", new Class[0]);
                        m.setAccessible(true);
                        Object exeService = m.invoke((Object)this.httpClient.dispatcher(), new Object[0]);
                        if (exeService instanceof ExecutorService) {
                            ExecutorService executorService = (ExecutorService)exeService;
                            executorService.shutdown();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.httpClient.connectionPool() != null) {
                    this.httpClient.connectionPool().evictAll();
                }
                this.httpClient = null;
            }
        }
        if (this.apiVersionCache != null) {
            this.apiVersionCache.clear();
            this.apiVersionCache = null;
        }
        if (this.segmentLock != null) {
            this.segmentLock.clear();
            this.segmentLock = null;
        }
    }

    protected boolean retryRequest(IOException exception, int executionCount, int retryMaxCount, Request request, Call call) {
        if (executionCount > retryMaxCount) {
            return false;
        }
        if (nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        return !call.isCanceled();
    }

    private ServiceException handleThrowable(Request request, Response response, InterfaceLogBean reqBean, Call call, Throwable t) {
        ServiceException serviceException = t instanceof ServiceException ? (ServiceException)t : new ServiceException("Request Error: " + t, t);
        serviceException.setRequestHost(request.header("Host"));
        serviceException.setRequestVerb(request.method());
        serviceException.setRequestPath(request.url().toString());
        if (response != null) {
            ServiceUtils.closeStream((Closeable)response);
            serviceException.setResponseCode(response.code());
            serviceException.setResponseStatus(response.message());
            serviceException.setResponseDate(response.header("Date"));
            serviceException.setResponseHeaders(ServiceUtils.cleanRestMetadataMapV2(this.convertHeadersToMap(response.headers()), this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
            if (!ServiceUtils.isValid(serviceException.getErrorRequestId())) {
                serviceException.setRequestAndHostIds(response.header(this.getIHeaders().requestIdHeader()), response.header(this.getIHeaders().requestId2Header()));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn(serviceException);
        }
        if (call != null) {
            call.cancel();
        }
        return serviceException;
    }

    private void performRequestAsync(Request request, RequestContext context, ObsCallback<Response, ServiceException> callback) throws InterruptedException {
        this.performRequestAsync(request, context, callback, false);
    }

    private void performRequestAsync(final Request request, final RequestContext context, final ObsCallback<Response, ServiceException> callback, final boolean isOEF) throws InterruptedException {
        Call call = this.httpClient.newCall(request);
        final long start = System.currentTimeMillis();
        call.enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    int responseCode = response.code();
                    context.reqBean.setRespParams("[responseCode: " + responseCode + "][request-id: " + response.header(RestStorageService.this.getIHeaders().requestIdHeader(), "") + "]");
                    String contentType = response.header("Content-Type");
                    if (log.isDebugEnabled()) {
                        log.debug("Response for '" + context.method + "'. Content-Type: " + contentType + ", ResponseCode:" + responseCode + ", Headers: " + response.headers());
                    }
                    if (log.isTraceEnabled() && response.body() != null) {
                        log.trace("Entity length: " + response.body().contentLength());
                    }
                    if (responseCode >= 300 && responseCode < 400 && responseCode != 304) {
                        String location = response.header("Location");
                        if (!ServiceUtils.isValid(location)) {
                            ServiceException exception = new ServiceException("Try to redirect, but location is null!");
                            context.reqBean.setResponseInfo("Request Error:" + exception.getMessage(), "|" + responseCode + "|" + response.message() + "|");
                            throw exception;
                        }
                        if (location.indexOf("?") < 0) {
                            location = RestStorageService.this.addRequestParametersToUrlPath(location, context.requestParameters, isOEF);
                        }
                        ++context.internalErrorCount;
                        if (context.internalErrorCount > context.retryMaxCount) {
                            String xmlMessage = null;
                            try {
                                if (response.body() != null) {
                                    xmlMessage = response.body().string();
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            throw new ServiceException("Exceeded 3xx redirect limit (" + context.retryMaxCount + ").", xmlMessage);
                        }
                        ServiceUtils.closeStream((Closeable)response);
                        if (context.doSignature) {
                            RestStorageService.this.performRequestAsync(RestStorageService.this.authorizeHttpRequest(request, context.bucketName, location), context, callback);
                        } else {
                            Request.Builder builder = request.newBuilder();
                            RestStorageService.this.setHost(builder, request, location);
                            RestStorageService.this.performRequestAsync(builder.build(), context, callback);
                        }
                        return;
                    }
                    if (responseCode >= 400 && responseCode < 500 || responseCode == 304) {
                        String xmlMessage = null;
                        try {
                            if (response.body() != null) {
                                xmlMessage = response.body().string();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        ServiceException exception = new ServiceException("Request Error.", xmlMessage);
                        if (RestStorageService.REQUEST_TIMEOUT_CODE.equals(exception.getErrorCode())) {
                            ++context.internalErrorCount;
                            if (context.internalErrorCount < context.retryMaxCount) {
                                if (log.isWarnEnabled()) {
                                    log.warn("Retrying connection that failed with RequestTimeout error, attempt number " + context.internalErrorCount + " of " + context.retryMaxCount);
                                }
                                RestStorageService.this.performRequestAsync(RestStorageService.this.authorizeHttpRequest(request, context.bucketName, null), context, callback);
                                return;
                            }
                            if (log.isErrorEnabled()) {
                                log.error("Exceeded maximum number of retries for RequestTimeout errors: " + context.retryMaxCount);
                            }
                        }
                        throw exception;
                    }
                    if (responseCode >= 500) {
                        context.reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
                        if (log.isErrorEnabled()) {
                            log.error(context.reqBean);
                        }
                        ++context.internalErrorCount;
                        RestStorageService.this.sleepOnInternalError(context.internalErrorCount, context.retryMaxCount, response, context.reqBean);
                        RestStorageService.this.performRequestAsync(RestStorageService.this.authorizeHttpRequest(request, context.bucketName, null), context, callback);
                        return;
                    }
                    if (log.isInfoEnabled()) {
                        context.reqBean.setRespTime(new Date());
                        context.reqBean.setResultCode("0");
                        log.info(context.reqBean);
                    }
                    callback.onSuccess(response);
                }
                catch (Throwable t) {
                    ServiceException s = RestStorageService.this.handleThrowable(request, response, context.reqBean, call, t);
                    callback.onFailure(s);
                }
                finally {
                    if (log.isInfoEnabled()) {
                        log.info("OkHttp cost " + (System.currentTimeMillis() - start) + " ms to apply http request");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Call call, IOException e) {
                try {
                    if (e instanceof UnrecoverableIOException) {
                        if (context.lastException != null) {
                            throw context.lastException;
                        }
                        throw e;
                    }
                    context.lastException = e;
                    ++context.internalErrorCount;
                    if (RestStorageService.this.retryRequest(e, context.internalErrorCount, context.retryMaxCount, request, call)) {
                        long delayMs = 50L * (long)((int)Math.pow(2.0, context.internalErrorCount));
                        Thread.sleep(delayMs);
                        RestStorageService.this.performRequestAsync(RestStorageService.this.authorizeHttpRequest(request, context.bucketName, null), context, callback);
                        return;
                    }
                    try {
                        if (e instanceof ConnectException || e instanceof InterruptedIOException) {
                            ServiceException se = new ServiceException("Request error. ", e);
                            se.setResponseCode(408);
                            se.setErrorCode("RequestTimeOut");
                            se.setErrorMessage(e.getMessage());
                            se.setResponseStatus("Request error. ");
                            throw se;
                        }
                        throw e;
                    }
                    catch (Throwable t) {
                        ServiceException s = RestStorageService.this.handleThrowable(request, null, context.reqBean, call, t);
                        callback.onFailure(s);
                    }
                }
                finally {
                    if (log.isInfoEnabled()) {
                        log.info("OkHttp cost " + (System.currentTimeMillis() - start) + " ms to apply http request");
                    }
                }
            }
        });
    }

    protected void performRequestAsync(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, ObsCallback<Response, ServiceException> callback) throws ServiceException, InterruptedException {
        InterfaceLogBean reqBean = new InterfaceLogBean("performRequest", "", "");
        if (log.isDebugEnabled()) {
            log.debug("Performing " + request.method() + " request for '" + request.url());
            log.debug("Headers: " + request.headers());
        }
        RequestContext context = new RequestContext();
        context.reqBean = reqBean;
        context.method = request.method();
        context.retryMaxCount = this.obsProperties.getIntProperty("httpclient.retry-max", 3);
        context.bucketName = bucketName;
        context.requestParameters = requestParameters;
        context.doSignature = doSignature;
        if (doSignature) {
            request = this.authorizeHttpRequest(request, bucketName, null);
        } else {
            Request.Builder builder = request.newBuilder();
            builder.headers(request.headers().newBuilder().removeAll("Authorization").build());
            this.setHost(builder, request, null);
            request = builder.build();
        }
        this.performRequestAsync(request, context, callback);
    }

    protected Response performRequestAsync(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature) throws ServiceException {
        final CountDownLatch latch = new CountDownLatch(1);
        final ResponseContext context = new ResponseContext();
        try {
            this.performRequestAsync(request, requestParameters, bucketName, doSignature, new ObsCallback<Response, ServiceException>(){

                @Override
                public void onSuccess(Response result) {
                    context.response = result;
                    latch.countDown();
                }

                @Override
                public void onFailure(ServiceException e) {
                    context.ex = e;
                    latch.countDown();
                }
            });
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ServiceException(e);
        }
        if (context.ex != null) {
            throw context.ex;
        }
        return context.response;
    }

    protected Response performRequestAsync(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequestAsync(request, requestParameters, bucketName, true);
    }

    protected Response performRequesttWithoutSignatureAsync(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequestAsync(request, requestParameters, bucketName, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, true);
    }

    protected Response performRequestWithoutSignature(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, doSignature, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF) throws ServiceException {
        Response response = null;
        InterfaceLogBean reqBean = new InterfaceLogBean("performRequest", "", "");
        Call call = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Performing " + request.method() + " request for '" + request.url());
                log.debug("Headers: " + request.headers());
            }
            boolean completedWithoutRecoverableError = false;
            int internalErrorCount = 0;
            boolean wasRecentlyRedirected = false;
            IOException lastException = null;
            int responseCode = -1;
            int retryMaxCount = this.obsProperties.getIntProperty("httpclient.retry-max", 3);
            do {
                ServiceException exception;
                if (!wasRecentlyRedirected) {
                    if (doSignature) {
                        request = this.authorizeHttpRequest(request, bucketName, null);
                    } else {
                        Request.Builder builder = request.newBuilder();
                        builder.headers(request.headers().newBuilder().removeAll("Authorization").build());
                        this.setHost(builder, request, null);
                        request = builder.build();
                    }
                } else {
                    wasRecentlyRedirected = false;
                }
                long start = System.currentTimeMillis();
                call = this.httpClient.newCall(request);
                try {
                    this.semaphore.acquire();
                    response = call.execute();
                }
                catch (IOException e) {
                    if (e instanceof UnrecoverableIOException) {
                        if (lastException != null) {
                            throw lastException;
                        }
                        throw e;
                    }
                    lastException = e;
                    if (this.retryRequest(e, ++internalErrorCount, retryMaxCount, request, call)) {
                        long delayMs = 50L * (long)((int)Math.pow(2.0, internalErrorCount));
                        Thread.sleep(delayMs);
                        continue;
                    }
                    if (e instanceof ConnectException || e instanceof InterruptedIOException) {
                        ServiceException se = new ServiceException("Request error. ", e);
                        se.setResponseCode(408);
                        se.setErrorCode("RequestTimeOut");
                        se.setErrorMessage(e.getMessage());
                        se.setResponseStatus("Request error. ");
                        throw se;
                    }
                    throw e;
                }
                finally {
                    this.semaphore.release();
                    if (log.isInfoEnabled()) {
                        log.info("OkHttp cost " + (System.currentTimeMillis() - start) + " ms to apply http request");
                    }
                }
                responseCode = response.code();
                reqBean.setRespParams("[responseCode: " + responseCode + "][request-id: " + response.header(this.getIHeaders().requestIdHeader(), "") + "]");
                String contentType = response.header("Content-Type");
                if (log.isDebugEnabled()) {
                    log.debug("Response for '" + request.method() + "'. Content-Type: " + contentType + ", ResponseCode:" + responseCode + ", Headers: " + response.headers());
                }
                if (log.isTraceEnabled() && response.body() != null) {
                    log.trace("Entity length: " + response.body().contentLength());
                }
                if (isOEF && "application/json".equalsIgnoreCase(contentType)) {
                    if (responseCode >= 400 && responseCode < 500) {
                        String xmlMessage = null;
                        try {
                            if (response.body() != null) {
                                xmlMessage = response.body().string();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        OefExceptionMessage oefException = (OefExceptionMessage)JSONChange.jsonToObj(new OefExceptionMessage(), xmlMessage);
                        ServiceException exception2 = new ServiceException("Request Error." + xmlMessage);
                        exception2.setErrorMessage(oefException.getMessage());
                        exception2.setErrorCode(oefException.getCode());
                        exception2.setErrorRequestId(oefException.getRequest_id());
                        throw exception2;
                    }
                    if (responseCode >= 500) {
                        reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
                        if (log.isErrorEnabled()) {
                            log.error(reqBean);
                        }
                        String xmlMessage = null;
                        try {
                            if (response.body() != null) {
                                xmlMessage = response.body().string();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        exception = new ServiceException("Encountered too many 5xx errors (" + internalErrorCount + "), aborting request.", xmlMessage);
                        throw exception;
                    }
                    completedWithoutRecoverableError = true;
                    continue;
                }
                if (responseCode >= 300 && responseCode < 400 && responseCode != 304) {
                    String location = response.header("Location");
                    if (!ServiceUtils.isValid(location)) {
                        exception = new ServiceException("Try to redirect, but location is null!");
                        reqBean.setResponseInfo("Request Error:" + exception.getMessage(), "|" + responseCode + "|" + response.message() + "|");
                        throw exception;
                    }
                    if (location.indexOf("?") < 0) {
                        location = this.addRequestParametersToUrlPath(location, requestParameters, isOEF);
                    }
                    if (doSignature) {
                        request = this.authorizeHttpRequest(request, bucketName, location);
                    } else {
                        Request.Builder builder = request.newBuilder();
                        this.setHost(builder, request, location);
                        request = builder.build();
                    }
                    wasRecentlyRedirected = true;
                    if (++internalErrorCount > retryMaxCount) {
                        String xmlMessage = null;
                        try {
                            if (response.body() != null) {
                                xmlMessage = response.body().string();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw new ServiceException("Exceeded 3xx redirect limit (" + retryMaxCount + ").", xmlMessage);
                    }
                    ServiceUtils.closeStream((Closeable)response);
                    continue;
                }
                if (responseCode >= 400 && responseCode < 500 || responseCode == 304) {
                    String xmlMessage = null;
                    try {
                        if (response.body() != null) {
                            xmlMessage = response.body().string();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    exception = new ServiceException("Request Error.", xmlMessage);
                    if (REQUEST_TIMEOUT_CODE.equals(exception.getErrorCode())) {
                        if (++internalErrorCount < retryMaxCount) {
                            if (!log.isWarnEnabled()) continue;
                            log.warn("Retrying connection that failed with RequestTimeout error, attempt number " + internalErrorCount + " of " + retryMaxCount);
                            continue;
                        }
                        if (log.isErrorEnabled()) {
                            log.error("Exceeded maximum number of retries for RequestTimeout errors: " + retryMaxCount);
                        }
                    }
                    throw exception;
                }
                if (responseCode >= 500) {
                    reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
                    if (log.isErrorEnabled()) {
                        log.error(reqBean);
                    }
                    this.sleepOnInternalError(++internalErrorCount, retryMaxCount, response, reqBean);
                    continue;
                }
                completedWithoutRecoverableError = true;
            } while (!completedWithoutRecoverableError);
        }
        catch (Throwable t) {
            ServiceException serviceException = this.handleThrowable(request, response, reqBean, call, t);
            throw serviceException;
        }
        if (log.isInfoEnabled()) {
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            log.info(reqBean);
        }
        return response;
    }

    protected String getRestMetadataPrefix() {
        return this.getIHeaders().headerMetaPrefix();
    }

    protected String getRestHeaderPrefix() {
        return this.getIHeaders().headerPrefix();
    }

    private boolean isProviderCredentialsInValid(ProviderCredentials providerCredentials) {
        return providerCredentials == null || !ServiceUtils.isValid(providerCredentials.getAccessKey()) || !ServiceUtils.isValid(providerCredentials.getSecretKey());
    }

    private URI setHost(Request.Builder builder, Request request, String url) {
        int insecurePort;
        int securePort;
        URI uri;
        if (url == null) {
            uri = request.url().uri();
        } else {
            uri = URI.create(url);
            builder.url(url);
        }
        String portStr = this.getHttpsOnly() ? ((securePort = this.getHttpsPort()) == 443 ? "" : ":" + securePort) : ((insecurePort = this.getHttpPort()) == 80 ? "" : ":" + insecurePort);
        builder.header("Host", uri.getHost() + portStr);
        return uri;
    }

    protected Request authorizeHttpRequest(Request request, String bucketName, String url) throws ServiceException {
        IAuthentication iauthentication;
        String queryString;
        boolean isV4;
        Headers headers = request.headers().newBuilder().removeAll("Authorization").build();
        Request.Builder builder = request.newBuilder();
        builder.headers(headers);
        URI uri = this.setHost(builder, request, url);
        String hostname = uri.getHost();
        ProviderCredentials providerCredentials = ProviderCredentialThreadContext.getInstance().getProviderCredentials();
        if (this.isProviderCredentialsInValid(providerCredentials)) {
            providerCredentials = this.getProviderCredentials();
        } else {
            providerCredentials.setAuthType(this.getProviderCredentials().getAuthType());
        }
        if (this.isProviderCredentialsInValid(providerCredentials)) {
            if (log.isInfoEnabled()) {
                log.info("Service has no Credential and is un-authenticated, skipping authorization");
            }
            return request;
        }
        String dateHeader = this.getIHeaders().dateHeader();
        String date = request.header(dateHeader);
        Date now = null;
        boolean bl = isV4 = providerCredentials.getAuthType() == AuthTypeEnum.V4;
        if (date != null) {
            try {
                now = isV4 ? ServiceUtils.getLongDateFormat().parse(date) : ServiceUtils.parseRfc822Date(date);
            }
            catch (ParseException e) {
                throw new ServiceException(dateHeader + " is not well-format", e);
            }
        } else {
            now = new Date();
        }
        builder.header("Date", ServiceUtils.formatRfc822Date(now));
        String securityToken = providerCredentials.getSecurityToken();
        if (ServiceUtils.isValid(securityToken)) {
            builder.header(this.getIHeaders().securityTokenHeader(), securityToken);
        }
        String fullUrl = uri.getRawPath();
        String endpoint = this.getEndpoint();
        if (!(this.isPathStyle() && !this.isCname() || hostname == null || isV4)) {
            if (this.isCname()) {
                fullUrl = "/" + hostname + fullUrl;
            } else if (ServiceUtils.isValid(bucketName) && !endpoint.equals(hostname) && hostname.indexOf(bucketName) >= 0) {
                fullUrl = "/" + bucketName + fullUrl;
            }
        }
        if ((queryString = uri.getRawQuery()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        if (log.isDebugEnabled()) {
            log.debug("For creating canonical string, using uri: " + fullUrl);
        }
        if (isV4) {
            builder.header(this.getIHeaders().contentSha256Header(), "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
            iauthentication = V4Authentication.makeServiceCanonicalString(request.method(), this.convertHeadersToMap(builder.build().headers()), fullUrl, providerCredentials, now);
            if (log.isDebugEnabled()) {
                log.debug("CanonicalRequest:" + iauthentication.getCanonicalRequest());
            }
        } else {
            iauthentication = Constants.AUTHTICATION_MAP.get((Object)providerCredentials.getAuthType()).makeAuthorizationString(request.method(), this.convertHeadersToMap(builder.build().headers()), fullUrl, Constants.ALLOWED_RESOURCE_PARAMTER_NAMES, providerCredentials);
        }
        if (log.isDebugEnabled()) {
            log.debug("StringToSign ('|' is a newline): " + iauthentication.getStringToSign().replace('\n', '|'));
        }
        String authorizationString = iauthentication.getAuthorization();
        builder.header("Authorization", authorizationString);
        builder.header("User-Agent", "obs-sdk-java/3.1.3");
        return builder.build();
    }

    protected Response performRestHead(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.HEAD, bucketName, objectKey, requestParameters, null);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequest(builder.build(), requestParameters, bucketName);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        return this.performRestGet(bucketName, objectKey, requestParameters, requestHeaders, false);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.GET, bucketName, objectKey, requestParameters, null, isOEF);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
    }

    protected Response performRestPut(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease) throws ServiceException {
        return this.performRestPut(bucketName, objectKey, metadata, requestParameters, body, autoRelease, false);
    }

    protected Response performRestPut(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.PUT, bucketName, objectKey, requestParameters, body, isOEF);
        this.renameMetadataKeys(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestPost(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease) throws ServiceException {
        return this.performRestPost(bucketName, objectKey, metadata, requestParameters, body, autoRelease, false);
    }

    protected Response performRestPost(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, RequestBody body, boolean autoRelease, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.POST, bucketName, objectKey, requestParameters, body, isOEF);
        this.renameMetadataKeys(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> metadata) throws ServiceException {
        return this.performRestDelete(bucketName, objectKey, requestParameters, metadata, false);
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> metadata, boolean isOEF) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.DELETE, bucketName, objectKey, requestParameters, null, isOEF);
        this.renameMetadataKeys(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        result.close();
        return result;
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters) throws ServiceException {
        return this.performRestDelete(bucketName, objectKey, requestParameters, true);
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, boolean autoRelease) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.DELETE, bucketName, objectKey, requestParameters, null);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestOptions(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, boolean autoRelease) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.OPTIONS, bucketName, objectKey, requestParameters, null);
        this.addRequestHeadersToConnection(builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestForApiVersion(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        Request.Builder builder = this.setupConnection(HttpMethodEnum.HEAD, bucketName, objectKey, requestParameters, null);
        this.addRequestHeadersToConnection(builder, requestHeaders);
        return this.performRequestWithoutSignature(builder.build(), requestParameters, bucketName);
    }

    protected void shutdown() {
        this.shutdownImpl();
    }

    protected void sleepOnInternalError(int internalErrorCount, int retryMaxCount, Response response, InterfaceLogBean reqBean) throws ServiceException {
        String xmlMessage = null;
        if (internalErrorCount <= retryMaxCount) {
            ServiceUtils.closeStream((Closeable)response);
            long delayMs = 50L * (long)((int)Math.pow(2.0, internalErrorCount));
            if (log.isWarnEnabled()) {
                log.warn("Encountered " + internalErrorCount + " Internal Server error(s), will retry in " + delayMs + "ms");
            }
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {}
        } else {
            try {
                xmlMessage = response.body().string();
            }
            catch (IOException e) {
                // empty catch block
            }
            ServiceException exception = new ServiceException("Encountered too many 5xx errors (" + internalErrorCount + "), aborting request.", xmlMessage);
            throw exception;
        }
    }

    protected Map<String, String> convertHeadersToMap(Headers headers) {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        for (Map.Entry entry : headers.toMultimap().entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                map.put(new String((String)entry.getKey()), value);
            }
        }
        return map;
    }

    protected ProviderCredentials getProviderCredentials() {
        return this.credentials;
    }

    protected void setProviderCredentials(ProviderCredentials credentials) {
        this.credentials = credentials;
    }

    protected void renameMetadataKeys(Request.Builder builder, Map<String, String> metadata) {
        HashMap<String, String> convertedMetadata = new HashMap<String, String>();
        if (metadata != null) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ServiceUtils.isValid(key)) continue;
                if (!((key = key.trim()).startsWith(this.getRestHeaderPrefix()) || key.startsWith("x-obs-") || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault())))) {
                    key = this.getRestMetadataPrefix() + key;
                }
                try {
                    if (key.startsWith(this.getRestMetadataPrefix())) {
                        key = RestUtils.uriEncode(key, true);
                    }
                    convertedMetadata.put(key, RestUtils.uriEncode(value == null ? "" : value, true));
                }
                catch (ServiceException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Ignore metadata key:" + key);
                }
            }
        }
        for (Map.Entry<String, String> entry : convertedMetadata.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug("Added request header to connection: " + entry.getKey() + "=" + entry.getValue());
        }
    }

    protected Request.Builder setupConnection(HttpMethodEnum method, String bucketName, String objectKey, Map<String, String> requestParameters, RequestBody body) throws ServiceException {
        return this.setupConnection(method, bucketName, objectKey, requestParameters, body, false);
    }

    protected Request.Builder setupConnection(HttpMethodEnum method, String bucketName, String objectKey, Map<String, String> requestParameters, RequestBody body, boolean isOEF) throws ServiceException {
        boolean pathStyle = this.isPathStyle();
        String endPoint = this.getEndpoint();
        boolean isCname = this.isCname();
        String hostname = isCname ? endPoint : ServiceUtils.generateHostnameForBucket(RestUtils.encodeUrlString(bucketName), pathStyle, endPoint);
        String resourceString = "/";
        if (hostname.equals(endPoint) && !isCname && bucketName.length() > 0) {
            resourceString = resourceString + RestUtils.encodeUrlString(bucketName);
        }
        if (objectKey != null) {
            resourceString = resourceString + (pathStyle && !isCname ? "/" : "") + RestUtils.encodeUrlString(objectKey);
        }
        String url = null;
        if (this.getHttpsOnly()) {
            int securePort = this.getHttpsPort();
            String securePortStr = securePort == 443 ? "" : ":" + securePort;
            url = "https://" + hostname + securePortStr + resourceString;
        } else {
            int insecurePort = this.getHttpPort();
            String insecurePortStr = insecurePort == 80 ? "" : ":" + insecurePort;
            url = "http://" + hostname + insecurePortStr + resourceString;
        }
        if (log.isDebugEnabled()) {
            log.debug("OBS URL: " + url);
        }
        url = this.addRequestParametersToUrlPath(url, requestParameters, isOEF);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (body == null) {
            body = RequestBody.create(null, (String)"");
        }
        switch (method) {
            case PUT: {
                builder.put(body);
                break;
            }
            case POST: {
                builder.post(body);
                break;
            }
            case HEAD: {
                builder.head();
                break;
            }
            case GET: {
                builder.get();
                break;
            }
            case DELETE: {
                builder.delete(body);
                break;
            }
            case OPTIONS: {
                builder.method("OPTIONS", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised HTTP method name: " + (Object)((Object)method));
            }
        }
        if (!this.isKeepAlive()) {
            builder.addHeader("Connection", "Close");
        }
        return builder;
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map<String, String> requestParameters) {
        return this.addRequestParametersToUrlPath(urlPath, requestParameters, false);
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map<String, String> requestParameters, boolean isOEF) throws ServiceException {
        if (requestParameters != null) {
            for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                urlPath = isOEF ? (this.isPathStyle() ? urlPath + "/" + key : urlPath + key) : urlPath + (urlPath.indexOf("?") < 0 ? "?" : "&") + RestUtils.encodeUrlString(key);
                if (ServiceUtils.isValid(value)) {
                    urlPath = urlPath + "=" + RestUtils.encodeUrlString(value);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Added request parameter: " + key + "=" + value);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Added request parameter without value: " + key);
            }
        }
        return urlPath;
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser();
    }

    protected void addRequestHeadersToConnection(Request.Builder builder, Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ServiceUtils.isValid(key) || value == null || !Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase(Locale.getDefault())) && !key.startsWith(this.getRestHeaderPrefix())) continue;
                builder.addHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug("Added request header to connection: " + key + "=" + value);
            }
        }
    }

    protected IHeaders getIHeaders() {
        return Constants.HEADERS_MAP.get((Object)this.getProviderCredentials().getAuthType());
    }

    protected IConvertor getIConvertor() {
        return Constants.CONVERTOR_MAP.get((Object)this.getProviderCredentials().getAuthType());
    }

    protected boolean isKeepAlive() {
        return this.obsProperties.getBoolProperty("httpclient.keep-alive", true);
    }

    protected String getEndpoint() {
        return this.obsProperties.getStringProperty("obs-endpoint", "");
    }

    protected boolean isPathStyle() {
        return this.obsProperties.getBoolProperty("obs.disable-dns-buckets", false);
    }

    protected int getHttpPort() {
        return this.obsProperties.getIntProperty("obs-endpoint-http-port", 80);
    }

    protected int getHttpsPort() {
        return this.obsProperties.getIntProperty("obs-endpoint-https-port", 443);
    }

    protected boolean getHttpsOnly() {
        return this.obsProperties.getBoolProperty("obs.https-only", true);
    }

    protected boolean isAuthTypeNegotiation() {
        return this.obsProperties.getBoolProperty("httpclient.auth-type-negotiation", true);
    }

    protected CacheManager getApiVersionCache() {
        return this.apiVersionCache;
    }

    protected boolean isCname() {
        return this.obsProperties.getBoolProperty("httpclient.is-cname", false);
    }

    protected String getFileSystemDelimiter() {
        return this.obsProperties.getStringProperty("filesystem.delimiter", "/");
    }

    static {
        nonRetriableClasses.add(UnknownHostException.class);
        nonRetriableClasses.add(SSLException.class);
        nonRetriableClasses.add(ConnectException.class);
    }

    private static class ResponseContext {
        Response response;
        ServiceException ex;

        private ResponseContext() {
        }
    }

    private static class RequestContext {
        InterfaceLogBean reqBean;
        String method;
        int retryMaxCount;
        int internalErrorCount = 0;
        String bucketName;
        Exception lastException;
        boolean doSignature;
        Map<String, String> requestParameters;

        private RequestContext() {
        }
    }
}

