/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.model.ProgressListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProgressManager {
    protected final long totalBytes;
    protected Date startCheckpoint;
    protected Date lastCheckpoint;
    protected final long intervalBytes;
    protected final ProgressListener progressListener;
    protected volatile List<BytesUnit> lastInstantaneousBytes;

    public ProgressManager(long totalBytes, ProgressListener progressListener, long intervalBytes) {
        Date now;
        this.totalBytes = totalBytes;
        this.progressListener = progressListener;
        this.startCheckpoint = now = new Date();
        this.lastCheckpoint = now;
        this.intervalBytes = intervalBytes;
    }

    public void progressStart() {
        Date now;
        this.startCheckpoint = now = new Date();
        this.lastCheckpoint = now;
    }

    public final void progressChanged(int bytes) {
        if (this.progressListener == null || bytes <= 0) {
            return;
        }
        this.doProgressChanged(bytes);
    }

    protected List<BytesUnit> createCurrentInstantaneousBytes(long bytes, Date now) {
        ArrayList<BytesUnit> currentInstantaneousBytes = new ArrayList<BytesUnit>();
        List<BytesUnit> _lastInstantaneousBytes = this.lastInstantaneousBytes;
        if (_lastInstantaneousBytes != null) {
            for (BytesUnit item : _lastInstantaneousBytes) {
                if (now.getTime() - item.dateTime.getTime() >= 1000L) continue;
                currentInstantaneousBytes.add(item);
            }
        }
        currentInstantaneousBytes.add(new BytesUnit(now, bytes));
        return currentInstantaneousBytes;
    }

    public abstract void progressEnd();

    protected abstract void doProgressChanged(int var1);

    static class BytesUnit {
        Date dateTime;
        long bytes;

        BytesUnit(Date dateTime, long bytes) {
            this.dateTime = dateTime;
            this.bytes = bytes;
        }
    }
}

