/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.ProgressManager;
import com.obs.services.model.ProgressStatus;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProgressStatus
implements ProgressStatus {
    private final long newlyTransferredBytes;
    private final long transferredBytes;
    private final long totalBytes;
    private final long intervalMilliseconds;
    private final long totalMilliseconds;
    private List<ProgressManager.BytesUnit> instantaneousBytes;

    public DefaultProgressStatus(long newlyTransferredBytes, long transferredBytes, long totalBytes, long intervalMilliseconds, long totalMilliseconds) {
        this.newlyTransferredBytes = newlyTransferredBytes;
        this.transferredBytes = transferredBytes;
        this.totalBytes = totalBytes;
        this.intervalMilliseconds = intervalMilliseconds;
        this.totalMilliseconds = totalMilliseconds;
    }

    @Override
    public double getInstantaneousSpeed() {
        if (this.instantaneousBytes != null) {
            long instantaneousSpeed = 0L;
            for (ProgressManager.BytesUnit item : this.instantaneousBytes) {
                instantaneousSpeed += item.bytes;
            }
            return instantaneousSpeed;
        }
        if (this.intervalMilliseconds <= 0L) {
            return -1.0;
        }
        return (double)this.newlyTransferredBytes * 1000.0 / (double)this.intervalMilliseconds;
    }

    @Override
    public double getAverageSpeed() {
        if (this.totalMilliseconds <= 0L) {
            return -1.0;
        }
        return (double)this.transferredBytes * 1000.0 / (double)this.totalMilliseconds;
    }

    @Override
    public int getTransferPercentage() {
        if (this.totalBytes < 0L) {
            return -1;
        }
        if (this.totalBytes == 0L) {
            return 100;
        }
        return (int)(this.transferredBytes * 100L / this.totalBytes);
    }

    @Override
    public long getNewlyTransferredBytes() {
        return this.newlyTransferredBytes;
    }

    @Override
    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setInstantaneousBytes(List<ProgressManager.BytesUnit> instantaneousBytes) {
        this.instantaneousBytes = instantaneousBytes;
    }
}

