/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Log4j2Configurator {
    private static volatile boolean isWatchStart = false;
    private static volatile boolean log4j2Enabled = false;

    public static synchronized void setLogConfig(String configPath) {
        Log4j2Configurator.setLogConfig(configPath, false);
    }

    public static synchronized void setLogConfig(String configPath, boolean isWatchConfig) {
        Log4j2Configurator.setLogConfig(configPath, isWatchConfig, 60000L);
    }

    private static Object getLogContext(String configPath) {
        Object ctx = null;
        try {
            Class<?> configurationSource = Class.forName("org.apache.logging.log4j.core.config.ConfigurationSource");
            Class<?> configurator = Class.forName("org.apache.logging.log4j.core.config.Configurator");
            Constructor<?> con = configurationSource.getConstructor(InputStream.class);
            Method m = configurator.getMethod("initialize", ClassLoader.class, configurationSource);
            ctx = m.invoke(null, null, con.newInstance(new FileInputStream(configPath)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctx;
    }

    public static synchronized void setLogConfig(String configPath, boolean isWatchConfig, long watchInterval) {
        if (log4j2Enabled) {
            return;
        }
        Object ctx = Log4j2Configurator.getLogContext(configPath);
        if (isWatchConfig && ctx != null && !isWatchStart) {
            try {
                isWatchStart = true;
                long _watchInterval = watchInterval > 0L ? watchInterval : 60000L;
                LogWatcher wather = new LogWatcher(configPath, ctx, _watchInterval);
                wather.setDaemon(true);
                wather.start();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        log4j2Enabled = true;
    }

    private static class LogWatcher
    extends Thread {
        private Object ctx;
        private long watchInterval;
        private String configPath;

        LogWatcher(String configPath, Object ctx, long watchInterval) {
            this.configPath = configPath;
            this.ctx = ctx;
            this.watchInterval = watchInterval;
        }

        public void run() {
            try {
                Class<?> configuration = Class.forName("org.apache.logging.log4j.core.config.Configuration");
                Method stop = this.ctx.getClass().getMethod("stop", new Class[0]);
                Method start = this.ctx.getClass().getMethod("start", configuration);
                Class<?> xmlConfiguration = Class.forName("org.apache.logging.log4j.core.config.xml.XmlConfiguration");
                Class<?> configurationSource = Class.forName("org.apache.logging.log4j.core.config.ConfigurationSource");
                Constructor<?> configurationSourceConstructor = configurationSource.getConstructor(InputStream.class);
                Constructor<?> xmlConfigurationConstructor = xmlConfiguration.getConstructor(this.ctx.getClass(), configurationSource);
                while (true) {
                    Thread.sleep(this.watchInterval);
                    stop.invoke(this.ctx, new Object[0]);
                    start.invoke(this.ctx, xmlConfigurationConstructor.newInstance(this.ctx, configurationSourceConstructor.newInstance(new FileInputStream(this.configPath))));
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

