/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.Qos;

import com.obs.services.model.Qos.BpsLimitConfiguration;
import com.obs.services.model.Qos.NetworkType;
import com.obs.services.model.Qos.QpsLimitConfiguration;

public class QosRule {
    private NetworkType networkType;
    private long concurrentRequestLimit;
    private QpsLimitConfiguration qpsLimit;
    private BpsLimitConfiguration bpsLimit;

    private static void validateNonNegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " value cannot be negative: " + value);
        }
    }

    public QosRule(NetworkType networkType, long concurrentRequestLimitValue, QpsLimitConfiguration qpsLimit, BpsLimitConfiguration bpsLimit) {
        QosRule.validateNonNegative(concurrentRequestLimitValue, "concurrentRequestLimit");
        this.networkType = networkType;
        this.concurrentRequestLimit = concurrentRequestLimitValue;
        this.qpsLimit = qpsLimit;
        this.bpsLimit = bpsLimit;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(NetworkType networkType) {
        this.networkType = networkType;
    }

    public long getConcurrentRequestLimit() {
        return this.concurrentRequestLimit;
    }

    public void setConcurrentRequestLimit(long concurrentRequestLimitValue) {
        QosRule.validateNonNegative(concurrentRequestLimitValue, "concurrentRequestLimit");
        this.concurrentRequestLimit = concurrentRequestLimitValue;
    }

    public QpsLimitConfiguration getQpsLimit() {
        return this.qpsLimit;
    }

    public void setQpsLimit(QpsLimitConfiguration qpsLimit) {
        this.qpsLimit = qpsLimit;
    }

    public BpsLimitConfiguration getBpsLimit() {
        return this.bpsLimit;
    }

    public void setBpsLimit(BpsLimitConfiguration bpsLimit) {
        this.bpsLimit = bpsLimit;
    }
}

