/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.HeaderResponse;
import java.util.ArrayList;
import java.util.List;

public class BucketTagInfo
extends HeaderResponse {
    private TagSet tagSet;

    public BucketTagInfo() {
    }

    public BucketTagInfo(TagSet tagSet) {
        this.tagSet = tagSet;
    }

    public TagSet getTagSet() {
        if (this.tagSet == null) {
            this.tagSet = new TagSet();
        }
        return this.tagSet;
    }

    public void setTagSet(TagSet tagSet) {
        this.tagSet = tagSet;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        if (this.tagSet != null) {
            int i = 0;
            for (TagSet.Tag t : this.tagSet.getTags()) {
                s.append("[").append("key=").append(t.getKey()).append(",").append("value=").append(t.getValue()).append("]");
                if (i++ == this.tagSet.getTags().size() - 1) continue;
                s.append(",");
            }
        }
        s.append("]");
        return "BucketTagInfo [tagSet=[tags=" + s.toString() + "]";
    }

    public static class TagSet {
        private List<Tag> tags;

        public List<Tag> getTags() {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>();
            }
            return this.tags;
        }

        public Tag addTag(String key, String value) {
            Tag t = new Tag(key, value);
            this.getTags().add(t);
            return t;
        }

        public Tag removeTag(String key, String value) {
            Tag t = new Tag(key, value);
            this.getTags().remove(t);
            return t;
        }

        public Tag removeTagByKey(String key) {
            if (null == this.tags) {
                return null;
            }
            for (Tag t : this.tags) {
                if (!t.getKey().equals(key)) continue;
                this.removeTag(t.getKey(), t.getValue());
                return t;
            }
            return null;
        }

        public String toString() {
            return "TagSet [" + this.tags + "]";
        }

        public static class Tag {
            private String key;
            private String value;

            public Tag() {
            }

            public Tag(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
                result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Tag other = (Tag)obj;
                if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                    return false;
                }
                return !(this.value == null ? other.value != null : !this.value.equals(other.value));
            }

            public String toString() {
                return "Tag [key='" + this.key + '\'' + ", value='" + this.value + '\'' + ']';
            }
        }
    }
}

