/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.hmsscankit;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.huawei.hms.feature.dynamic.DynamicModule;
import com.huawei.hms.hmsscankit.ScanKitActivity;
import com.huawei.hms.hmsscankit.WriterException;
import com.huawei.hms.hmsscankit.b;
import com.huawei.hms.hmsscankit.f;
import com.huawei.hms.hmsscankit.g;
import com.huawei.hms.ml.scan.HmsBuildBitmapOption;
import com.huawei.hms.ml.scan.HmsScan;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;
import com.huawei.hms.ml.scan.HmsScanFrame;
import com.huawei.hms.ml.scan.HmsScanFrameOptions;
import com.huawei.hms.ml.scan.HmsScanResult;
import com.huawei.hms.mlsdk.common.MLFrame;
import com.huawei.hms.scankit.p.c5;
import com.huawei.hms.scankit.p.o4;
import com.huawei.hms.scankit.p.w7;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ScanUtil {
    public static final int SUCCESS = 0;
    public static final int ERROR_NO_CAMERA_PERMISSION = 1;
    public static final int ERROR_NO_READ_PERMISSION = 2;
    public static final int ERROR_ABNORMAL_RESTART = 3;
    public static final int ERROR_INVALID_PARAM = 4;
    public static final int CAMERA_INIT_ERROR = -1000;
    private static final int MAX_BITMAP_SIZE = 0x3200000;
    static final String MODULE_SCANKIT = "huawei_module_scankit";
    static final String MODULE_SCANKIT_LOCAL = "huawei_module_scankit_local";
    static final String CREATOR_PATH = "com.huawei.hms.scankit.Creator";
    static final String CONTEXT_PATH = "com.huawei.hms.feature.DynamicModuleInitializer";
    static final String CONTEXT_METHOD = "initializeModule";
    public static final String RESULT = "SCAN_RESULT";
    public static final String RESULT_CODE = "SCAN_RESULT_CODE";
    public static final int SCAN_NO_DETECTED = 4096;
    private static final int NEW_VERSION = 21002300;
    private static final int WR_VERSION = 201000300;
    private static final int LITE_VERSION = 10320300;

    public static int startScan(Activity activity, int n9, HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
        Intent intent;
        o4.d("ScanUtil", "startScan before");
        int n10 = 28;
        try {
            n10 = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)16384).applicationInfo.targetSdkVersion;
        }
        catch (RuntimeException runtimeException) {
            o4.b("exception", "RuntimeException");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            o4.b("exception", "NameNotFoundException");
        }
        n10 = ScanUtil.selfPermissionGranted((Context)activity, n10, "android.permission.CAMERA") ? 1 : 0;
        if (!w7.c) {
            o4.d("ScanUtil", "startScan failed");
            return 3;
        }
        if (!(n10 != 0 || hmsScanAnalyzerOptions != null && hmsScanAnalyzerOptions.showGuide)) {
            return 1;
        }
        Intent intent2 = intent;
        intent = new Intent((Context)activity, ScanKitActivity.class);
        if (hmsScanAnalyzerOptions != null) {
            intent2.putExtra("ScanFormatValue", hmsScanAnalyzerOptions.mode);
            intent2.putExtra("ScanViewValue", hmsScanAnalyzerOptions.viewType);
            intent2.putExtra("ScanErrorCheck", hmsScanAnalyzerOptions.errorCheck);
            intent2.putExtra("ScanGuide", hmsScanAnalyzerOptions.showGuide);
        }
        o4.d("ScanUtil", "startScan success");
        w7.c = false;
        activity.startActivityForResult(intent2, n9);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HmsScanResult decode(Context hmsScanArray, HmsScanFrame hmsScanFrame, HmsScanFrameOptions hmsScanFrameOptions) {
        if (hmsScanFrame == null) return new HmsScanResult(4, new HmsScan[0]);
        if (hmsScanFrame.getYuvImage() == null && hmsScanFrame.getBitmap() == null) {
            return new HmsScanResult(4, new HmsScan[0]);
        }
        o4.d("Scankit", "frame height " + hmsScanFrame.getHeight() + " width " + hmsScanFrame.getWidth());
        if (hmsScanFrame.getHeight() * hmsScanFrame.getHeight() <= 0x3200000 && hmsScanFrame.getHeight() * hmsScanFrame.getHeight() != 0) {
            try {
                if (g.d == Integer.MIN_VALUE) {
                    g.d = g.a((Context)hmsScanArray);
                }
                if (g.e == Integer.MIN_VALUE) {
                    g.e = DynamicModule.getRemoteVersion((Context)hmsScanArray.getApplicationContext(), (String)MODULE_SCANKIT);
                }
            }
            catch (Exception exception) {
                o4.b("Scankit", "get remote version failed");
            }
            if (hmsScanFrameOptions != null && hmsScanFrameOptions.isMultiMode()) {
                if ((hmsScanArray = b.a((Context)hmsScanArray, hmsScanFrame, new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(hmsScanFrameOptions.getType(), new int[0]).setPhotoMode(hmsScanFrameOptions.isPhotoMode()).setParseResult(hmsScanFrameOptions.isParseResult()).create())).length == 0) {
                    return new HmsScanResult(4096, hmsScanArray);
                }
                if (hmsScanArray.length == 1 && hmsScanArray[0].getZoomValue() > 1.0 && TextUtils.isEmpty((CharSequence)hmsScanArray[0].getOriginalValue())) {
                    return new HmsScanResult(4098, hmsScanArray);
                }
                if (hmsScanArray.length < 1) return new HmsScanResult(4096, hmsScanArray);
                if (TextUtils.isEmpty((CharSequence)hmsScanArray[0].getOriginalValue())) return new HmsScanResult(4096, hmsScanArray);
                return new HmsScanResult(0, hmsScanArray);
            }
            HmsScanAnalyzerOptions hmsScanAnalyzerOptions = hmsScanFrameOptions == null ? new HmsScanAnalyzerOptions.Creator().create() : new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(hmsScanFrameOptions.getType(), new int[0]).setPhotoMode(hmsScanFrameOptions.isPhotoMode()).setParseResult(hmsScanFrameOptions.isParseResult()).create();
            if (hmsScanFrame.getBitmap() != null) {
                return ScanUtil.checkHmsScan(f.a((Context)hmsScanArray, hmsScanFrame.getBitmap(), hmsScanAnalyzerOptions), hmsScanFrameOptions);
            }
            if (hmsScanFrame.getYuvImage() == null) return new HmsScanResult(4, new HmsScan[0]);
            Log.i((String)"scankit", (String)("local version " + g.d + " remote version" + g.e));
            if (ScanUtil.checkVersion(g.d, g.e)) {
                return f.a((Context)hmsScanArray, hmsScanFrame, hmsScanAnalyzerOptions);
            }
            HmsScanFrame hmsScanFrame2 = hmsScanFrame;
            int n9 = hmsScanFrame2.getYuvImage().getWidth();
            return f.a((Context)hmsScanArray, hmsScanFrame.getYuvImage().getYuvData(), n9, hmsScanFrame2.getYuvImage().getHeight(), hmsScanAnalyzerOptions);
        }
        o4.e("ScanUtil", "input image is invalid:" + hmsScanFrame.getWidth() + " " + hmsScanFrame.getHeight());
        return new HmsScanResult(4, new HmsScan[0]);
    }

    public static HmsScan[] decodeWithBitmap(Context context, Bitmap bitmap, HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
        if (bitmap != null && bitmap.getWidth() * bitmap.getHeight() <= 0x3200000) {
            return f.a(context, bitmap, hmsScanAnalyzerOptions);
        }
        if (bitmap != null) {
            o4.e("ScanUtil", "input image is too large:" + bitmap.getWidth());
        }
        return new HmsScan[0];
    }

    public static HmsScan[] detectForHmsDector(Context context, MLFrame mLFrame, HmsScanAnalyzerOptions hmsScanAnalyzerOptions) {
        return b.a(context, mLFrame, hmsScanAnalyzerOptions);
    }

    public static boolean isScanAvailable(Context context) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean selfPermissionGranted(Context context, int n9, String string2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = true;
        if (Build.VERSION.SDK_INT < 23) return bl3;
        if (n9 >= 23) {
            if (w7.a(string2) == null) {
                return true;
            }
            if (context.checkSelfPermission(string2) != 0) return bl2 = false;
            while (true) {
                bl = true;
                return bl;
            }
        }
        if (w7.a(context, string2) != 0) return bl2 = false;
        bl = true;
        return bl;
    }

    public static Bitmap compressBitmap(Context context, String string2) {
        BitmapFactory.Options options;
        Context context2 = context;
        context = options;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)context);
        ScanUtil.dealBitmapFactoryOption(context2, (BitmapFactory.Options)context);
        return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)context);
    }

    private static void dealBitmapFactoryOption(Context context, BitmapFactory.Options options) {
        int n9 = options.outWidth;
        int n10 = options.outHeight;
        if (n9 != 0 && n10 != 0) {
            if (n9 > n10) {
                n9 = n10;
            }
            n10 = 1;
            if (Build.VERSION.SDK_INT >= 23) {
                ActivityManager.MemoryInfo memoryInfo;
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                context = memoryInfo;
                activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
                Context context2 = context;
                double d9 = Math.pow(1024.0, 3.0);
                try {
                    int n11;
                    int n12;
                    n10 = (double)context2.totalMem / d9 < 5.5 ? (n12 = 1) : (n11 = 0);
                }
                catch (Exception exception) {
                    o4.b("exception", "Exception");
                }
                catch (NullPointerException nullPointerException) {
                    o4.b("exception", "NullPointerException");
                }
            }
            int n13 = 1;
            if (n9 > (n10 = n10 != 0 ? 1200 : 3000)) {
                n13 = Math.round((float)n9 / (float)n10);
            }
            BitmapFactory.Options options2 = options;
            options2.inSampleSize = n13;
            options2.inJustDecodeBounds = false;
            options2.inPreferredConfig = Bitmap.Config.ARGB_8888;
            options2.inPurgeable = true;
            options2.inInputShareable = true;
            return;
        }
    }

    public static Bitmap buildBitmap(String string2, int n9, int n10, int n11, HmsBuildBitmapOption hmsBuildBitmapOption) throws WriterException {
        return new c5().a(string2, n9, n10, n11, hmsBuildBitmapOption);
    }

    /*
     * Exception decompiling
     */
    public static Bitmap compressBitmapForAndroid29(Context var0, String var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 10[TRYBLOCK] [28 : 165->174)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Bitmap getBitmapFromUri(Context context, Uri uri, BitmapFactory.Options options) {
        if (uri == null) {
            o4.a("ScanBitmap", "uri == null");
            return null;
        }
        context = context.getContentResolver().openFileDescriptor(uri, "r");
        try {
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)context.getFileDescriptor(), null, (BitmapFactory.Options)options);
            context.close();
            return bitmap;
        }
        catch (Exception exception) {
            o4.b("exception", "Exception");
        }
        catch (IOException iOException) {
            o4.b("exception", "IOException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            o4.b("exception", "FileNotFoundException");
        }
        return null;
    }

    private static HmsScanResult checkHmsScan(HmsScan[] hmsScanArray, HmsScanFrameOptions hmsScanFrameOptions) {
        if (hmsScanArray.length == 0) {
            return new HmsScanResult(4096, null);
        }
        if (hmsScanArray[0].getOriginalValue() == "" && hmsScanArray[0].getZoomValue() > 1.0) {
            return new HmsScanResult(4098, hmsScanArray);
        }
        if (hmsScanArray[0].getOriginalValue() != "") {
            return new HmsScanResult(0, hmsScanArray);
        }
        return new HmsScanResult(4096, hmsScanArray);
    }

    private static boolean checkVersion(int n9, int n10) {
        if (n9 == 10320300 && (n10 < 21002300 || n10 == 201000300)) {
            return true;
        }
        return n9 != 10320300 && (n9 < 21002300 || n10 == 201000300 || n10 < 21002300);
    }
}

