/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.framework.network.grs;

import android.content.Context;
import android.text.TextUtils;
import com.huawei.hms.framework.common.Logger;
import com.huawei.hms.framework.network.grs.GrsApp;
import com.huawei.hms.framework.network.grs.f.b;
import com.huawei.hms.framework.network.grs.local.model.a;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;

public class GrsBaseInfo
implements Cloneable {
    private static final String TAG = GrsBaseInfo.class.getSimpleName();
    private String serCountry;
    private String versionName;
    private String appName;
    private String uid;
    private String regCountry;
    private String issueCountry;
    private String androidVersion;
    private String romVersion;
    private String deviceModel;
    private String countrySource;
    private int queryTimeout = -1;

    public GrsBaseInfo() {
    }

    public GrsBaseInfo(Context context) {
        this.issueCountry = GrsApp.getInstance().getIssueCountryCode(context);
    }

    private static String getObjSummary(GrsBaseInfo grsBaseInfo) {
        if (grsBaseInfo == null) {
            return "";
        }
        return "serCountry:" + grsBaseInfo.serCountry + "versionName:" + grsBaseInfo.versionName + "appName:" + grsBaseInfo.appName + "uid:" + grsBaseInfo.uid + "regCountry:" + grsBaseInfo.regCountry + "issueCountry:" + grsBaseInfo.issueCountry + "androidVersion:" + grsBaseInfo.androidVersion + "romVersion:" + grsBaseInfo.romVersion + "deviceModel:" + grsBaseInfo.deviceModel + "countrySource:" + grsBaseInfo.countrySource;
    }

    private StringBuffer getStringBuffer(StringBuffer stringBuffer, boolean bl, Context context) {
        String string = this.getAndroidVersion();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer.toString())) {
                stringBuffer.append("&");
            }
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.append("android_version");
            stringBuffer2.append("=");
            stringBuffer.append(this.getUrlEncodedStr(string));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.getRomVersion()))) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer.toString())) {
                stringBuffer.append("&");
            }
            StringBuffer stringBuffer3 = stringBuffer;
            stringBuffer3.append("rom_version");
            stringBuffer3.append("=");
            stringBuffer.append(this.getUrlEncodedStr(string));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.getDeviceModel()))) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer.toString())) {
                stringBuffer.append("&");
            }
            StringBuffer stringBuffer4 = stringBuffer;
            stringBuffer4.append("device_model");
            stringBuffer4.append("=");
            stringBuffer.append(this.getUrlEncodedStr(string));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.getCountrySource()))) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer.toString())) {
                stringBuffer.append("&");
            }
            StringBuffer stringBuffer5 = stringBuffer;
            stringBuffer5.append("country_source");
            stringBuffer5.append("=");
            stringBuffer.append(this.getUrlEncodedStr(string));
        }
        if (!TextUtils.isEmpty((CharSequence)stringBuffer.toString())) {
            stringBuffer.append("&");
        }
        StringBuffer stringBuffer6 = stringBuffer;
        stringBuffer6.append("package_name").append("=").append(this.getUrlEncodedStr(context.getPackageName()));
        return stringBuffer6;
    }

    public String getSerCountry() {
        return this.serCountry;
    }

    public void setSerCountry(String string) {
        string = string != null ? string.toUpperCase(Locale.ENGLISH) : "";
        this.serCountry = string;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String string) {
        this.versionName = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getUid() {
        return this.uid;
    }

    @Deprecated
    public void setUid(String string) {
        this.uid = string;
    }

    public String getRegCountry() {
        return this.regCountry;
    }

    public void setRegCountry(String string) {
        string = string != null ? string.toUpperCase(Locale.ENGLISH) : "";
        this.regCountry = string;
    }

    public String getIssueCountry() {
        return this.issueCountry;
    }

    @Deprecated
    public void setIssueCountry(String string) {
        string = string != null ? string.toUpperCase(Locale.ENGLISH) : "";
        this.issueCountry = string;
    }

    public String getAndroidVersion() {
        return this.androidVersion;
    }

    public void setAndroidVersion(String string) {
        this.androidVersion = string;
    }

    public String getRomVersion() {
        return this.romVersion;
    }

    public void setRomVersion(String string) {
        this.romVersion = string;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String string) {
        this.deviceModel = string;
    }

    public String getCountrySource() {
        return this.countrySource;
    }

    public void setCountrySource(String string) {
        this.countrySource = string;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public GrsBaseInfo clone() {
        return (GrsBaseInfo)super.clone();
    }

    public boolean compare(Object object) {
        if (grsBaseInfo2 == object) {
            return true;
        }
        if (object != null && GrsBaseInfo.class == object.getClass()) {
            GrsBaseInfo grsBaseInfo = grsBaseInfo2;
            GrsBaseInfo grsBaseInfo2 = (GrsBaseInfo)object;
            return GrsBaseInfo.getObjSummary(grsBaseInfo).equals(GrsBaseInfo.getObjSummary(grsBaseInfo2));
        }
        return false;
    }

    public GrsBaseInfo copy() {
        GrsBaseInfo grsBaseInfo;
        GrsBaseInfo grsBaseInfo2 = grsBaseInfo;
        grsBaseInfo2();
        grsBaseInfo2.setAppName(this.appName);
        grsBaseInfo2.setSerCountry(this.serCountry);
        grsBaseInfo2.setRegCountry(this.regCountry);
        grsBaseInfo2.setIssueCountry(this.issueCountry);
        grsBaseInfo2.setCountrySource(this.countrySource);
        grsBaseInfo2.setAndroidVersion(this.androidVersion);
        grsBaseInfo2.setDeviceModel(this.deviceModel);
        grsBaseInfo2.setRomVersion(this.romVersion);
        grsBaseInfo2.setUid(this.uid);
        grsBaseInfo2.setVersionName(this.versionName);
        grsBaseInfo.setQueryTimeout(this.queryTimeout);
        return grsBaseInfo;
    }

    public String getGrsParasKey(boolean bl, boolean bl2, Context context) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        a a2 = null;
        Object object = b.a(context.getPackageName());
        if (object != null) {
            a2 = ((b)object).a();
        }
        object = "";
        if (a2 != null) {
            object = a2.a();
        }
        if (!TextUtils.isEmpty((CharSequence)(this = ((GrsBaseInfo)this).getGrsReqParamJoint(bl, bl2, (String)object, context)))) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer2.toString())) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append((String)this);
        }
        return stringBuffer2.toString();
    }

    public String getGrsReqParamJoint(boolean bl, boolean bl2, String string, Context context) {
        String string2;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        if ("1.0".equals(string)) {
            Logger.v((String)TAG, (Object)"1.0 interface has no query param appname");
        } else if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuffer2.append("app_name").append("=").append(this.getUrlEncodedStr(string));
        } else if (!TextUtils.isEmpty((CharSequence)this.getAppName())) {
            GrsBaseInfo grsBaseInfo = this;
            stringBuffer2.append("app_name").append("=").append(grsBaseInfo.getUrlEncodedStr(grsBaseInfo.getAppName()));
        }
        string = this.getVersionName();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer2.toString())) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append("app_version").append("=").append(this.getUrlEncodedStr(string));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.getUid()))) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer2.toString())) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append("uid").append("=");
            if (bl) {
                stringBuffer2.append(com.huawei.hms.framework.network.grs.h.b.b(string));
            } else if (bl2) {
                stringBuffer2.append(com.huawei.hms.framework.network.grs.h.b.a(string));
            } else {
                stringBuffer2.append(string);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.getRegCountry())) && !"UNKNOWN".equals(string2)) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer2.toString())) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append("reg_country").append("=").append(this.getUrlEncodedStr(string2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.getSerCountry())) && !"UNKNOWN".equals(string2)) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer2.toString())) {
                stringBuffer2.append("&");
            }
            StringBuffer stringBuffer3 = stringBuffer2;
            stringBuffer3.append("ser_country");
            stringBuffer3.append("=");
            stringBuffer2.append(this.getUrlEncodedStr(string2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.getIssueCountry())) && !"UNKNOWN".equals(string2)) {
            if (!TextUtils.isEmpty((CharSequence)stringBuffer2.toString())) {
                stringBuffer2.append("&");
            }
            StringBuffer stringBuffer4 = stringBuffer2;
            stringBuffer4.append("issue_country");
            stringBuffer4.append("=");
            stringBuffer2.append(this.getUrlEncodedStr(string2));
        }
        return this.getStringBuffer(stringBuffer2, bl2, context).toString();
    }

    public String getUrlEncodedStr(String string) {
        try {
            return URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.e((String)TAG, (Object)"UnsupportedEncodingException, Please check the params!");
            return "";
        }
    }

    public int uniqueCode() {
        return (this.appName + "#" + this.serCountry + "#" + this.regCountry + "#" + this.issueCountry).hashCode();
    }

    public static @interface CountryCodeSource {
        public static final String VENDOR_COUNTRY = "VENDOR_COUNTRY";
        public static final String SIM_COUNTRY = "SIM_COUNTRY";
        public static final String NETWORK_COUNTRY = "NETWORK_COUNTRY";
        public static final String LOCALE_INFO = "LOCALE_INFO";
        public static final String UNKNOWN = "UNKNOWN";
        public static final String APP = "APP";
    }
}

