/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.text.TextUtils;
import com.huawei.hms.mlsdk.common.AgConnectInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MLApplicationSetting {
    private final String appId;
    private final String apiKey;
    private final String packageName;
    private final String certFingerprint;
    private final String mlSdkVersion;
    private final Boolean acceptHa;
    private final String region;
    private final List<String> mlServiceUrls;
    private final List<String> haCollectorUrls;
    private final Map<String, Object> extProperties;
    private final String appMLKitGrsPolicy;
    private final String projectId;

    public Map<String, Object> getExtProperties() {
        return this.extProperties;
    }

    private MLApplicationSetting(String appId, String apiKey, String packageName, String certFingerprint, String mlSdkVersion, Boolean acceptHa, String region, List<String> mlServiceUrls, List<String> haCollectorUrls, Map<String, Object> extProperties, String appMLKitGrsPolicy, String projectId) {
        this.appId = appId;
        this.apiKey = apiKey;
        this.packageName = packageName;
        this.certFingerprint = certFingerprint;
        this.mlSdkVersion = mlSdkVersion;
        this.acceptHa = acceptHa;
        this.region = region;
        this.mlServiceUrls = mlServiceUrls;
        this.haCollectorUrls = haCollectorUrls;
        this.extProperties = extProperties;
        this.appMLKitGrsPolicy = appMLKitGrsPolicy;
        this.projectId = projectId;
    }

    public static MLApplicationSetting fromResource(Context context) {
        AgConnectInfo agConnectInfo = new AgConnectInfo(context);
        String mlSdkVersion = MLApplicationSetting.getMetadata(context, "com.huawei.hms.client.service.name:ml-computer-vision", "");
        if (TextUtils.isEmpty((CharSequence)mlSdkVersion)) {
            mlSdkVersion = MLApplicationSetting.getKitMetadata(context, "com.huawei.hms.client.service.name:ml-computer-vision", "UNKNOWN");
        }
        Boolean acceptHa = false;
        int appAnalyticsState = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"hw_app_analytics_state", (int)0);
        if (appAnalyticsState == 1) {
            acceptHa = true;
        }
        return new MLApplicationSetting(agConnectInfo.getApplicationId(), agConnectInfo.getApiKey(), agConnectInfo.getPackageName(), agConnectInfo.getCertFingerprint(), mlSdkVersion, acceptHa, agConnectInfo.getRegion(), agConnectInfo.getMLServiceUrls(), agConnectInfo.getHaCollectorUrls(), new HashMap<String, Object>(), agConnectInfo.getAppMLKitGrsPolicy(), agConnectInfo.getProjectId());
    }

    private static String getMetadata(Context context, String key, String defaultValue) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                return appInfo.metaData.getString(key, defaultValue);
            }
            return defaultValue;
        }
        catch (PackageManager.NameNotFoundException e) {
            return defaultValue;
        }
    }

    private static String getKitMetadata(Context context, String key, String defaultValue) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageArchiveInfo(context.getApplicationInfo().sourceDir, 128);
            if (packageInfo != null && packageInfo.applicationInfo.metaData != null) {
                return packageInfo.applicationInfo.metaData.getString(key, defaultValue);
            }
            return defaultValue;
        }
        catch (UnsupportedOperationException e) {
            return defaultValue;
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getCertFingerprint() {
        return this.certFingerprint;
    }

    public String getMLSdkVersion() {
        return this.mlSdkVersion;
    }

    public Boolean getAcceptHa() {
        return this.acceptHa;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getMLServiceUrls() {
        return this.mlServiceUrls;
    }

    public List<String> getHaConnectorUrls() {
        return this.haCollectorUrls;
    }

    public String getAppMLKitGrsPolicy() {
        return this.appMLKitGrsPolicy;
    }

    public String getProjectId() {
        return this.projectId;
    }

    private boolean equal(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MLApplicationSetting)) {
            return false;
        }
        MLApplicationSetting other = (MLApplicationSetting)o;
        return this.equal(this.appId, other.appId) && this.equal(this.apiKey, other.apiKey);
    }

    public int hashCode() {
        return this.hashCode(this.appId, this.apiKey);
    }

    public String toString() {
        return "appId=" + this.appId + ", packageName=" + this.packageName + ", mlSdkVersion=" + this.mlSdkVersion + ", acceptHa=" + this.acceptHa + ", region=" + this.region + ", mlServiceUrls=" + this.mlServiceUrls + ", haCollectorUrls=" + this.haCollectorUrls;
    }

    public static class BundleKeyConstants {

        public static final class AppInfo {
            public static final String PACKAGE_NAME = "packageName";
            public static final String APPID = "appid";
            public static final String ML_SDK_VERSION = "com.huawei.hms.client.service.name:ml-computer-vision";
            public static final String APP_NAME = "appName";
            public static final String OPEN_HA = "openHa";
            public static final String COUNTRY_CODE = "countryCode";
        }
    }

    public static final class Factory {
        private String apiKey;
        private String appId;
        private String packageName;
        private String certFingerprint;
        private String region;
        private String mlSdkVersion;
        private Boolean acceptHa;
        private List<String> mlServiceUrls = new ArrayList<String>();
        private List<String> haCollectorUrls = new ArrayList<String>();
        private Map<String, Object> extProperties = new HashMap<String, Object>();
        private String appMLKitGrsPolicy;
        private String projectId;

        public Factory() {
        }

        public Factory(MLApplicationSetting setting) {
            this.appId = setting.appId;
            this.apiKey = setting.apiKey;
            this.packageName = setting.packageName;
            this.certFingerprint = setting.certFingerprint;
            this.region = setting.region;
            this.mlSdkVersion = setting.mlSdkVersion;
            this.acceptHa = setting.acceptHa;
            this.mlServiceUrls = setting.mlServiceUrls;
            this.haCollectorUrls = setting.haCollectorUrls;
            this.extProperties = setting.extProperties;
            this.appMLKitGrsPolicy = setting.appMLKitGrsPolicy;
            this.projectId = setting.projectId;
        }

        public Factory setApplicationId(String applicationId) {
            this.appId = applicationId;
            return this;
        }

        public Factory setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Factory setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Factory setCertFingerprint(String certFingerprint) {
            this.certFingerprint = certFingerprint;
            return this;
        }

        public Factory setMLSdkVersion(String mlSdkVersion) {
            this.mlSdkVersion = mlSdkVersion;
            return this;
        }

        public Factory setAcceptHa(Boolean acceptHa) {
            this.acceptHa = acceptHa;
            return this;
        }

        public Factory setRegion(String region) {
            this.region = region;
            return this;
        }

        public Factory setMLServiceUrls(List<String> mlServiceUrls) {
            this.mlServiceUrls = mlServiceUrls == null ? new ArrayList() : mlServiceUrls;
            return this;
        }

        public Factory setHaCollectorUrls(List<String> haCollectorUrls) {
            this.haCollectorUrls = haCollectorUrls == null ? new ArrayList() : haCollectorUrls;
            return this;
        }

        public Factory setExtProperties(String key, Object value) {
            if (this.extProperties == null) {
                this.extProperties = new HashMap<String, Object>();
            }
            this.extProperties.put(key, value);
            return this;
        }

        public void setAppMLKitGrsPolicy(String appMLKitGrsPolicy) {
            this.appMLKitGrsPolicy = appMLKitGrsPolicy;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public MLApplicationSetting create() {
            return new MLApplicationSetting(this.appId, this.apiKey, this.packageName, this.certFingerprint, this.mlSdkVersion, this.acceptHa, this.region, this.mlServiceUrls, this.haCollectorUrls, this.extProperties, this.appMLKitGrsPolicy, this.projectId);
        }
    }
}

