/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import com.huawei.agconnect.AGConnectInstance;
import com.huawei.hms.ml.common.utils.ActivityMgr;
import com.huawei.hms.ml.common.utils.CountryCodeBean;
import com.huawei.hms.ml.common.utils.SmartLog;
import com.huawei.hms.mlsdk.common.MLApplicationSetting;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MLApplication {
    private static final String LOG_TAG = "MLApplication";
    public static final String DEFAULT_APP_NAME = "_DEFAULT_";
    public static final int REGION_DR_UNKNOWN = 1001;
    public static final int REGION_DR_CHINA = 1002;
    public static final int REGION_DR_RUSSIA = 1005;
    public static final int REGION_DR_GERMAN = 1006;
    public static final int REGION_DR_SINGAPORE = 1007;
    private static final Map<Integer, String> REGION_MAP = new HashMap<Integer, String>();
    private static final Object LOCK;
    static final Map<String, MLApplication> INSTANCES;
    private final Context appContext;
    private final String appName;
    private final MLApplicationSetting appSetting;
    private boolean setByCP = false;
    private String apiKey;
    private String accessToken;
    private boolean isAcessTokenSetByCP = false;
    private int userRegion = 1001;

    public Context getAppContext() {
        return this.appContext;
    }

    public String getAppName() {
        return this.appName;
    }

    public MLApplicationSetting getAppSetting() {
        return this.appSetting;
    }

    public String toString() {
        return "appName=" + this.appName + ", appSetting=" + this.appSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MLApplication> getAppList(Context context) {
        Object object = LOCK;
        synchronized (object) {
            return new ArrayList<MLApplication>(INSTANCES.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLApplication getInstance() {
        Object object = LOCK;
        synchronized (object) {
            MLApplication app = INSTANCES.get(DEFAULT_APP_NAME);
            if (app == null && (app = MLApplication.initialize(AGConnectInstance.getInstance().getContext())) == null) {
                throw new IllegalStateException("Please call MLApplication.initialize(Context) to initialize application first.");
            }
            return app;
        }
    }

    public static MLApplication getInstance(String name) {
        Object object = LOCK;
        synchronized (object) {
            MLApplication app = INSTANCES.get(name);
            if (app != null) {
                return app;
            }
            List<String> availableAppNames = MLApplication.getAllAppNames();
            String availableAppNamesMessage = availableAppNames.isEmpty() ? "" : "Available app names: " + TextUtils.join((CharSequence)", ", availableAppNames);
            String errorMessage = String.format(Locale.ENGLISH, "application doesn't exist. current available application names:%s", availableAppNamesMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLApplication initialize(Context context) {
        SmartLog.i((String)LOG_TAG, (String)"initialize one para");
        MLApplication app = null;
        Object object = LOCK;
        synchronized (object) {
            MLApplication.makeSureAGConnectInstanceInitialed(context);
            if (INSTANCES.containsKey(DEFAULT_APP_NAME)) {
                MLApplication.getInstance();
            }
            MLApplicationSetting mlAppSetting = new MLApplicationSetting.Factory().create();
            MLApplicationSetting setting = MLApplicationSetting.fromResource(context);
            app = MLApplication.initialize(context, setting);
            return app;
        }
    }

    public static MLApplication initialize(Context context, MLApplicationSetting setting) {
        SmartLog.i((String)LOG_TAG, (String)"initialize two para");
        return MLApplication.initialize(context, setting, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLApplication initialize(Context context, MLApplicationSetting setting, String name) {
        MLApplication app;
        Context applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = LOCK;
        synchronized (object) {
            MLApplication.makeSureAGConnectInstanceInitialed(applicationContext);
            MLApplicationSetting mySetting = setting;
            if (mySetting == null) {
                MLApplicationSetting newSetting = new MLApplicationSetting.Factory().create();
                mySetting = MLApplicationSetting.fromResource(context);
            }
            app = new MLApplication(applicationContext, name, mySetting);
            INSTANCES.put(name, app);
            if (ActivityMgr.INST.getCurrentActivity() == null && applicationContext instanceof Application) {
                ActivityMgr.INST.init((Application)applicationContext);
            }
        }
        return app;
    }

    protected MLApplication(Context applicationContext, String name, MLApplicationSetting setting) {
        this.appContext = applicationContext;
        this.appName = name;
        this.appSetting = setting;
    }

    private static void makeSureAGConnectInstanceInitialed(Context context) {
        if (AGConnectInstance.getInstance() == null) {
            AGConnectInstance.initialize((Context)context);
        }
    }

    public boolean isDefault() {
        return DEFAULT_APP_NAME.equals(this.getAppName());
    }

    public String getUniqueKey() {
        return MLApplication.getUniqueKey(this.getAppName(), this.getAppSetting());
    }

    public static String getUniqueKey(String name, MLApplicationSetting setting) {
        String nameResult = null;
        String optionResult = null;
        if (name != null) {
            byte[] nameArr = name.getBytes(Charset.defaultCharset());
            nameResult = Base64.encodeToString((byte[])nameArr, (int)11);
        }
        if (setting != null && setting.getAppId() != null) {
            byte[] optionArr = setting.getAppId().getBytes(Charset.defaultCharset());
            optionResult = Base64.encodeToString((byte[])optionArr, (int)11);
        }
        return nameResult + "+" + optionResult;
    }

    public <T> T get(Class<T> anInterface) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAppNames() {
        ArrayList<String> allAppNames = new ArrayList<String>();
        Object object = LOCK;
        synchronized (object) {
            for (MLApplication app : INSTANCES.values()) {
                allAppNames.add(app.getAppName());
            }
        }
        Collections.sort(allAppNames);
        return allAppNames;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        if (this.getAppSetting() != null) {
            bundle.putString("appid", this.getAppSetting().getAppId());
            String appNameBundle = MLApplication.readManifest(this.getAppContext());
            bundle.putString("appName", appNameBundle);
            bundle.putString("packageName", this.getAppSetting().getPackageName());
            bundle.putString("com.huawei.hms.client.service.name:ml-computer-vision", this.getAppSetting().getMLSdkVersion());
            bundle.putBoolean("openHa", this.getAppSetting().getAcceptHa().booleanValue());
            bundle.putString("countryCode", new CountryCodeBean(this.appContext, false).getCountryCode());
        } else {
            SmartLog.w((String)LOG_TAG, (String)"APP setting is null.");
        }
        return bundle;
    }

    private static String readManifest(Context context) {
        String res = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            res = packageInfo.applicationInfo.loadLabel(packageManager).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            SmartLog.e((String)LOG_TAG, (String)"PackageManager NameNotFoundException");
        }
        catch (Resources.NotFoundException notFoundException) {
            SmartLog.e((String)LOG_TAG, (String)"Resources NotFoundException");
        }
        catch (Exception e) {
            SmartLog.e((String)LOG_TAG, (String)"readManifest Exception");
        }
        return res;
    }

    private static Activity findActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            ContextWrapper wrapper = (ContextWrapper)context;
            return MLApplication.findActivity(wrapper.getBaseContext());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessToken(String token) {
        SmartLog.i((String)LOG_TAG, (String)"set a tkn");
        Object object = LOCK;
        synchronized (object) {
            this.accessToken = token;
            this.isAcessTokenSetByCP = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthorizationToken() {
        Object object = LOCK;
        synchronized (object) {
            if (!this.isAcessTokenSetByCP) {
                return this.getApiKey();
            }
            if (TextUtils.isEmpty((CharSequence)this.accessToken)) {
                throw new NullPointerException("access token is empty");
            }
            return this.accessToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApiKey(String apiKey) {
        SmartLog.i((String)LOG_TAG, (String)"set a ky");
        Object object = LOCK;
        synchronized (object) {
            this.apiKey = apiKey;
            this.setByCP = true;
            if (!this.isDefault()) {
                MLApplication.getInstance().setApiKey(apiKey);
                MLApplication.getInstance().setApiKeyByCP(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApiKey() {
        SmartLog.i((String)LOG_TAG, (String)("get ky flag: " + this.setByCP));
        Object object = LOCK;
        synchronized (object) {
            if (!MLApplication.getInstance().isSetByCP() || this.apiKey == null || this.apiKey.length() == 0) {
                throw new NullPointerException("please set your app apiKey");
            }
            return this.apiKey;
        }
    }

    public boolean isSetByCP() {
        return this.setByCP;
    }

    public void setApiKeyByCP(boolean setByCP) {
        this.setByCP = setByCP;
    }

    public String getCountryCode() {
        return REGION_MAP.containsKey(this.userRegion) ? REGION_MAP.get(this.userRegion) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserRegion(int userRegion) throws IllegalArgumentException {
        SmartLog.i((String)LOG_TAG, (String)("set userRegion: " + userRegion));
        Object object = LOCK;
        synchronized (object) {
            if (!REGION_MAP.containsKey(userRegion)) {
                throw new IllegalArgumentException("region is not available");
            }
            this.userRegion = userRegion;
        }
    }

    static {
        REGION_MAP.put(1002, "CN");
        REGION_MAP.put(1007, "SG");
        REGION_MAP.put(1006, "DE");
        REGION_MAP.put(1005, "RU");
        LOCK = new Object();
        INSTANCES = new HashMap<String, MLApplication>();
    }
}

