/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.mlsdk.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.huawei.agconnect.AGConnectInstance;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.ml.common.utils.SmartLog;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AgConnectInfo {
    private String region;
    private String applicationId;
    private String packageName;
    private String apiKey;
    private String certFingerprint;
    private List<String> mlServiceUrls = new ArrayList<String>();
    private List<String> haCollectorUrls = new ArrayList<String>();
    private String appMLKitGrsPolicy;
    private String projectId;

    public AgConnectInfo(Context inContext) {
        String collectorUrls;
        String serviceUrls;
        Context context = inContext;
        if (context == null) {
            context = AGConnectInstance.getInstance().getContext();
        }
        if (context == null) {
            throw new IllegalStateException("Context not found.");
        }
        AGConnectServicesConfig config = AGConnectServicesConfig.fromContext((Context)context);
        SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "context: " + context));
        this.region = config.getString("region");
        SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "region: " + this.region));
        this.packageName = config.getString("client/package_name");
        if (this.packageName == null) {
            this.packageName = context.getPackageName();
        } else {
            SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "packageName: " + this.packageName));
        }
        this.applicationId = config.getString("client/app_id");
        if (this.applicationId == null) {
            this.applicationId = this.packageName;
        } else {
            SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "packageName: " + this.packageName));
        }
        this.apiKey = config.getString("client/api_key");
        if (this.apiKey != null) {
            SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "apiKey: apiKey is secret"));
        }
        this.certFingerprint = this.getRawSignature(context);
        if (this.certFingerprint != null) {
            SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "certFingerprint: certFingerprint is secret"));
        }
        if ((serviceUrls = config.getString("service/ml/mlservice_url")) != null) {
            String[] urlArray;
            for (String url : urlArray = serviceUrls.split(",")) {
                if (!(url = url.trim().toLowerCase(Locale.ENGLISH)).startsWith("http://") && !url.startsWith("https://")) {
                    url = "https://" + url;
                }
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                this.mlServiceUrls.add(url);
            }
        }
        if ((collectorUrls = config.getString("service/analytics/collector_url")) != null) {
            String[] urlArray;
            for (String url : urlArray = collectorUrls.split(",")) {
                if (!(url = url.trim().toLowerCase(Locale.ENGLISH)).startsWith("http://") && !url.startsWith("https://")) {
                    url = "https://" + url;
                }
                this.haCollectorUrls.add(url);
            }
        }
        this.projectId = config.getString("client/project_id");
        SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "project_id: " + this.projectId));
        this.appMLKitGrsPolicy = config.getString("processing_location_policy/mlkit");
        SmartLog.i((String)"AgConnectInfo", (String)("AGConnectServicesConfig: " + config + "processing_location_policy/mlkit: " + this.appMLKitGrsPolicy));
    }

    public AgConnectInfo() {
        this(null);
    }

    private String getRawSignature(Context paramContext) {
        PackageInfo localPackageInfo;
        PackageManager localPackageManager = paramContext.getPackageManager();
        try {
            localPackageInfo = localPackageManager.getPackageInfo(paramContext.getPackageName(), 64);
            if (localPackageInfo == null) {
                return "";
            }
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return "";
        }
        Signature signature = null;
        Signature[] signatures = localPackageInfo.signatures;
        if (signatures != null && signatures.length > 0) {
            signature = signatures[0];
            SmartLog.i((String)"AgConnectInfo", (String)"signature is not null ");
        } else {
            SmartLog.i((String)"AgConnectInfo", (String)"signature is null ");
        }
        if (signature != null) {
            return this.getSignatureString(signature, "SHA256");
        }
        return "";
    }

    private final String getSignatureString(Signature sig, String type) {
        String fingerprint = null;
        try {
            byte[] hexBytes = sig.toByteArray();
            StringBuffer buffer = new StringBuffer();
            MessageDigest digest = MessageDigest.getInstance(type);
            digest.reset();
            digest.update(hexBytes);
            byte[] bytes = digest.digest();
            for (int i = 0; i < bytes.length; ++i) {
                if (Integer.toHexString(0xFF & bytes[i]).length() == 1) {
                    buffer.append("0").append(Integer.toHexString(0xFF & bytes[i]));
                } else {
                    buffer.append(Integer.toHexString(0xFF & bytes[i]));
                }
                if (i == bytes.length - 1) continue;
                buffer.append(":");
            }
            fingerprint = buffer.toString().toUpperCase(Locale.ENGLISH);
            return fingerprint;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getRegion() {
        return this.region;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getCertFingerprint() {
        return this.certFingerprint;
    }

    public List<String> getMLServiceUrls() {
        return this.mlServiceUrls;
    }

    public List<String> getHaCollectorUrls() {
        return this.haCollectorUrls;
    }

    public String getAppMLKitGrsPolicy() {
        return this.appMLKitGrsPolicy;
    }

    public String getProjectId() {
        return this.projectId;
    }

    private static final class AgConnectKey {
        public static final String REGION = "region";
        public static final String APPLICATION_ID = "client/app_id";
        public static final String PACKAGE_NAME = "client/package_name";
        public static final String API_KEY = "client/api_key";
        public static final String ML_SERVICE_URL = "service/ml/mlservice_url";
        public static final String ANALYTICS_COLLECTOR_URL = "service/analytics/collector_url";
        public static final String APP_MLKIT_GRS_POLICY = "processing_location_policy/mlkit";
        public static final String PROJECT_ID = "client/project_id";

        private AgConnectKey() {
        }
    }
}

