/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.util.Locale;

public class Preconditions {
    public Preconditions() {
        throw new AssertionError((Object)"illegal Argument");
    }

    public static <T> T checkNotNull(T t) {
        if (t != null) {
            return t;
        }
        throw new NullPointerException("The input parameter is null.");
    }

    public static String checkNotEmpty(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        throw new IllegalArgumentException("The input parameter is empty.");
    }

    public static String checkNotEmpty(String string, Object object) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static <T> T checkNotNull(T t, Object object) {
        if (t != null) {
            return t;
        }
        throw new NullPointerException(String.valueOf(object));
    }

    public static int checkNotZero(int n, Object object) {
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static int checkNotZero(int n) {
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("The input parameter is 0.");
    }

    public static long checkNotZero(long l, Object object) {
        if (l != 0L) {
            return l;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static long checkNotZero(long l) {
        if (l != 0L) {
            return l;
        }
        throw new IllegalArgumentException("The input parameter is 0.");
    }

    public static void checkState(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void checkState(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.valueOf(object));
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.format(Locale.ROOT, string, objectArray));
    }

    public static void checkArgument(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, string, objectArray));
    }

    public static void checkArgument(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkMainThread(String string) {
        if (Preconditions.isMainThread()) {
            return;
        }
        throw new IllegalStateException(string);
    }

    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("The given thread is main thread.");
    }

    public static void checkNotMainThread(String string) {
        if (!Preconditions.isMainThread()) {
            return;
        }
        throw new IllegalStateException(string);
    }

    public static void checkHandlerThread(Handler handler) {
        if (Looper.myLooper() == handler.getLooper()) {
            return;
        }
        throw new IllegalStateException("The given thread is not the current thread.");
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }
}

