/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.encrypt.rsa;

import android.text.TextUtils;
import android.util.Base64;
import com.huawei.secure.android.common.encrypt.utils.EncryptUtil;
import com.huawei.secure.android.common.encrypt.utils.b;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public abstract class RSAEncrypt {
    private static final String a = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final String b = "RSAEncrypt";
    private static final String c = "UTF-8";
    private static final String d = "";
    private static final int e = 2048;
    private static final String f = "RSA";

    public static String encrypt(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            return RSAEncrypt.encrypt(string, (PublicKey)EncryptUtil.getPublicKey(string2));
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(b, "content or public key is null");
        return d;
    }

    public static String decrypt(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            return RSAEncrypt.decrypt(string, EncryptUtil.getPrivateKey(string2));
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(b, "content or private key is null");
        return d;
    }

    public static String encrypt(String string, PublicKey publicKey) {
        if (!TextUtils.isEmpty((CharSequence)string) && publicKey != null && RSAEncrypt.isPublicKeyLengthRight((RSAPublicKey)publicKey)) {
            try {
                return Base64.encodeToString((byte[])RSAEncrypt.encrypt(string.getBytes(c), publicKey), (int)0);
            }
            catch (Exception exception) {
                com.huawei.secure.android.common.encrypt.utils.b.b(b, "exception : " + exception.getMessage());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(b, "encrypt: UnsupportedEncodingException");
            }
            return d;
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(b, "content or PublicKey is null , or length is too short");
        return d;
    }

    public static String decrypt(String string, PrivateKey privateKey) {
        if (!TextUtils.isEmpty((CharSequence)string) && privateKey != null && RSAEncrypt.isPrivateKeyLengthRight((RSAPrivateKey)privateKey)) {
            try {
                return new String(RSAEncrypt.decrypt(Base64.decode((String)string, (int)0), privateKey), c);
            }
            catch (Exception exception) {
                com.huawei.secure.android.common.encrypt.utils.b.b(b, "exception : " + exception.getMessage());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(b, "RSA decrypt exception : " + unsupportedEncodingException.getMessage());
            }
            return d;
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(b, "content or privateKey is null , or length is too short");
        return d;
    }

    public static byte[] encrypt(byte[] byArray, PublicKey publicKey) {
        byte[] byArray2 = new byte[]{};
        if (byArray != null && publicKey != null && RSAEncrypt.isPublicKeyLengthRight((RSAPublicKey)publicKey)) {
            Cipher cipher;
            try {
                cipher = Cipher.getInstance(a);
            }
            catch (GeneralSecurityException generalSecurityException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(b, "RSA encrypt exception : " + generalSecurityException.getMessage());
                return byArray2;
            }
            cipher.init(1, publicKey);
            return cipher.doFinal(byArray);
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(b, "content or PublicKey is null , or length is too short");
        return byArray2;
    }

    public static byte[] decrypt(byte[] byArray, PrivateKey privateKey) {
        byte[] byArray2 = new byte[]{};
        if (byArray != null && privateKey != null && RSAEncrypt.isPrivateKeyLengthRight((RSAPrivateKey)privateKey)) {
            Cipher cipher = Cipher.getInstance(a);
            try {
                cipher.init(2, privateKey);
                byArray2 = cipher.doFinal(byArray);
            }
            catch (GeneralSecurityException generalSecurityException) {
                com.huawei.secure.android.common.encrypt.utils.b.b(b, "RSA decrypt exception : " + generalSecurityException.getMessage());
            }
            return byArray2;
        }
        com.huawei.secure.android.common.encrypt.utils.b.b(b, "content or privateKey is null , or length is too short");
        return byArray2;
    }

    public static boolean isPublicKeyLengthRight(RSAPublicKey rSAPublicKey) {
        if (rSAPublicKey == null) {
            return false;
        }
        return rSAPublicKey.getModulus().bitLength() >= 2048;
    }

    public static boolean isPrivateKeyLengthRight(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey == null) {
            return false;
        }
        return rSAPrivateKey.getModulus().bitLength() >= 2048;
    }

    public static Map<String, Key> generateRSAKeyPair(int n) throws NoSuchAlgorithmException {
        HashMap<String, Key> hashMap;
        Serializable serializable = hashMap;
        hashMap = new HashMap<String, Key>(2);
        if (n < 2048) {
            com.huawei.secure.android.common.encrypt.utils.b.b(b, "generateRSAKeyPair: key length is too short");
            return serializable;
        }
        HashMap<String, Key> hashMap2 = serializable;
        serializable = EncryptUtil.genSecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(f);
        keyPairGenerator.initialize(n, (SecureRandom)serializable);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        serializable = keyPair.getPrivate();
        hashMap2.put("publicKey", publicKey);
        hashMap2.put("privateKey", (Key)serializable);
        return hashMap2;
    }
}

