/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.webview;

import android.annotation.TargetApi;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import com.huawei.secure.android.common.util.LogsUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class UriUtil {
    private static final String a = "UriUtil";

    public static boolean isUrlHostInWhitelist(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!UriUtil.isUrlHostMatchWhitelist(string, stringArray[i])) continue;
                return true;
            }
            return false;
        }
        LogsUtil.e(a, "whitelist is null");
        return false;
    }

    public static boolean isUrlHostSameWhitelist(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            return TextUtils.equals((CharSequence)UriUtil.getHostByURI(string), (CharSequence)UriUtil.a(string2));
        }
        Log.e((String)a, (String)"isUrlHostSameWhitelist: url or host is null");
        return false;
    }

    public static boolean isUrlHostSameWhitelist(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!UriUtil.isUrlHostSameWhitelist(string, stringArray[i])) continue;
                return true;
            }
            return false;
        }
        LogsUtil.e(a, "whitelist is null");
        return false;
    }

    public static boolean isUrlHostMatchWhitelist(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)(string = UriUtil.getHostByURI(string))) && !TextUtils.isEmpty((CharSequence)string2)) {
            if (TextUtils.isEmpty((CharSequence)(string2 = UriUtil.a(string2)))) {
                Log.e((String)a, (String)"whitelist host is null");
                return false;
            }
            if (string2.equals(string)) {
                return true;
            }
            if (string.endsWith(string2)) {
                block10: {
                    int n = string.length() - string2.length();
                    string = string.substring(0, n);
                    if (string.endsWith(".")) break block10;
                    return false;
                }
                try {
                    return string.matches("^[A-Za-z0-9.-]+$");
                }
                catch (Exception exception) {
                    LogsUtil.e(a, "Exception : " + exception.getMessage());
                    return false;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    LogsUtil.e(a, "IndexOutOfBoundsException" + indexOutOfBoundsException.getMessage());
                    return false;
                }
            }
            return false;
        }
        LogsUtil.e(a, "url or whitelist is null");
        return false;
    }

    @TargetApi(value=9)
    public static String getHostByURI(String string) {
        block6: {
            if (TextUtils.isEmpty((CharSequence)string)) {
                LogsUtil.i(a, "url is null");
                return string;
            }
            try {
                if (URLUtil.isNetworkUrl((String)string)) break block6;
            }
            catch (MalformedURLException malformedURLException) {
                LogsUtil.e(a, "getHostByURI error  MalformedURLException : " + malformedURLException.getMessage());
                return "";
            }
            LogsUtil.e(a, "url don't starts with http or https");
            return "";
        }
        string = string.replaceAll("[\\\\#]", "/");
        return new URL(string).getHost();
    }

    private static String a(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            LogsUtil.i(a, "whiteListUrl is null");
            return null;
        }
        if (!URLUtil.isNetworkUrl((String)string)) {
            return string;
        }
        return UriUtil.getHostByURI(string);
    }

    public static boolean isUrlHostAndPathInWhitelist(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!UriUtil.isUrlHostAndPathMatchWhitelist(string, stringArray[i])) continue;
                return true;
            }
            return false;
        }
        LogsUtil.e(a, "whitelist is null");
        return false;
    }

    public static boolean isUrlHostAndPathMatchWhitelist(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            if (!string.contains("..") && !string.contains("@")) {
                if (!(string2.equals(string) || string.startsWith(string2 + "?") || string.startsWith(string2 + "#"))) {
                    if (!string2.endsWith("/")) {
                        return false;
                    }
                    List list = Uri.parse((String)string2).getPathSegments();
                    if (Uri.parse((String)string).getPathSegments().size() - list.size() != 1) {
                        return false;
                    }
                    return string.startsWith(string2);
                }
                return true;
            }
            Log.e((String)a, (String)"url contains unsafe char");
            return false;
        }
        return false;
    }
}

