/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.sign;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.text.TextUtils;
import com.huawei.secure.android.common.util.LogsUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class HiPkgSignManager {
    private static final String a = "HiPkgSignManager";

    public static byte[] getInstalledAPPSignature(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            block6: {
                context = context.getPackageManager();
                if (context == null) break block6;
                context = context.getPackageInfo(string, 64);
                if (context == null) break block6;
                try {
                    return context.signatures[0].toByteArray();
                }
                catch (Exception exception) {
                    LogsUtil.e(a, "Exception : " + exception.getMessage(), true);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    LogsUtil.e(a, "PackageManager.NameNotFoundException : " + nameNotFoundException.getMessage(), true);
                }
            }
            return new byte[0];
        }
        LogsUtil.e(a, "packageName is null or context is null");
        return new byte[0];
    }

    public static byte[] getUnInstalledAPPSignature(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            if ((context = HiPkgSignManager.a(context, string)) != null) {
                context = context.signatures[0];
                if (context != null) {
                    return context.toByteArray();
                }
            } else {
                LogsUtil.e(a, "PackageInfo is null ");
            }
            return new byte[0];
        }
        LogsUtil.e(a, "archiveFilePath is null or context is null");
        return new byte[0];
    }

    public static String getUnInstalledAPPPackageName(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            if ((context = HiPkgSignManager.a(context, string)) != null) {
                return context.packageName;
            }
            return "";
        }
        LogsUtil.e(a, "archiveFilePath is null or context is null");
        return "";
    }

    private static PackageInfo a(Context context, String string) {
        block3: {
            context = context.getPackageManager();
            if (context == null) break block3;
            try {
                return context.getPackageArchiveInfo(string, 64);
            }
            catch (Exception exception) {
                LogsUtil.e(a, "Exception : " + exception.getMessage(), true);
            }
        }
        return null;
    }

    public static String getInstalledAppHash(Context object, String object2) {
        Context context = object;
        object = "";
        byte[] byArray = HiPkgSignManager.getInstalledAPPSignature(context, (String)object2);
        object2 = byArray;
        if (byArray != null && ((Object)object2).length > 0) {
            object = HiPkgSignManager.b((byte[])object2);
        }
        return object;
    }

    public static String getUnInstalledAppHash(Context object, String object2) {
        Context context = object;
        object = "";
        byte[] byArray = HiPkgSignManager.getUnInstalledAPPSignature(context, (String)object2);
        object2 = byArray;
        if (byArray != null && ((Object)object2).length > 0) {
            object = HiPkgSignManager.b((byte[])object2);
        }
        return object;
    }

    private static String b(byte[] byArray) {
        String string = "";
        try {
            string = HiPkgSignManager.a(MessageDigest.getInstance("SHA-256").digest(byArray));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LogsUtil.e(a, "NoSuchAlgorithmException" + noSuchAlgorithmException.getMessage());
        }
        return string;
    }

    private static String a(byte[] byArray) {
        StringBuffer stringBuffer;
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer2.append("0" + Integer.toHexString(byArray[i] & 0xFF));
                continue;
            }
            stringBuffer2.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer2.toString().toUpperCase(Locale.ENGLISH);
    }

    public static boolean doCheckInstalled(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string) && context != null) {
            return string.equalsIgnoreCase(HiPkgSignManager.getInstalledAppHash(context, string2));
        }
        return false;
    }

    public static boolean doCheckArchiveApk(Context object, String string, String string2, String string3) {
        if (!(TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string) || object == null || TextUtils.isEmpty((CharSequence)string3))) {
            if ((object = HiPkgSignManager.a(object, string2)) != null) {
                object = object.packageName;
                return string.equalsIgnoreCase(HiPkgSignManager.b(object.signatures[0].toByteArray())) && string3.equals(object);
            }
            return false;
        }
        return false;
    }

    public static boolean doCheckInstalledV2V3(Context object, List<String> arrayList, String object2) {
        if (!TextUtils.isEmpty((CharSequence)object2) && arrayList != null && object != null) {
            ArrayList<String> arrayList2;
            if ((object = HiPkgSignManager.getInstalledAppHashV2V3((Context)object, (String)object2)) == null) {
                return false;
            }
            ArrayList<String> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>();
            object2 = arrayList3.iterator();
            while (object2.hasNext()) {
                arrayList.add(((String)object2.next()).toUpperCase(Locale.ENGLISH));
            }
            object = object.iterator();
            while (object.hasNext()) {
                if (arrayList.contains((String)object.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getInstalledAppHashV2V3(Context context, String string) {
        block14: {
            context = context.getPackageManager();
            if (Build.VERSION.SDK_INT < 28) break block14;
            context = context.getPackageInfo(string, 0x8000000);
            if (context == null) return null;
            if (context.signingInfo == null) return null;
            if (!context.signingInfo.hasMultipleSigners()) return HiPkgSignManager.a(context.signingInfo.getSigningCertificateHistory());
            return HiPkgSignManager.a(context.signingInfo.getApkContentsSigners());
        }
        context = context.getPackageInfo(string, 64);
        if (context == null) return null;
        if (context.signatures == null) return null;
        if (context.signatures.length == 0) return null;
        if (context.signatures[0] == null) return null;
        try {
            return HiPkgSignManager.a(context.signatures);
        }
        catch (Throwable throwable) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static List<String> a(Signature[] signatureArray) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (signatureArray != null && signatureArray.length != 0) {
            int n = signatureArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(HiPkgSignManager.b(signatureArray[i].toByteArray()));
            }
            return arrayList2;
        }
        return arrayList2;
    }
}

