/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.bulkload;

import com.highgo.jdbc.PGConnection;
import com.highgo.jdbc.bulkload.BulkloadIn;
import com.highgo.jdbc.util.ByteStreamWriter;
import com.highgo.jdbc.util.GT;
import com.highgo.jdbc.util.internal.Nullness;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGBulkloadOutputStream
extends OutputStream
implements BulkloadIn {
    private @Nullable BulkloadIn op;
    private final byte[] copyBuffer;
    private final byte[] singleByteBuffer = new byte[1];
    private int at = 0;

    public PGBulkloadOutputStream(PGConnection connection, String sql) throws SQLException {
        this(connection, sql, 65536);
    }

    public PGBulkloadOutputStream(PGConnection connection, String sql, int bufferSize) throws SQLException {
        this(connection.getBulkloadAPI().bulkloadIn(sql), bufferSize);
    }

    public PGBulkloadOutputStream(BulkloadIn op) {
        this(op, 65536);
    }

    public PGBulkloadOutputStream(BulkloadIn op, int bufferSize) {
        this.op = op;
        this.copyBuffer = new byte[bufferSize];
    }

    private BulkloadIn getOp() {
        return Nullness.castNonNull(this.op);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (b < 0 || b > 255) {
            throw new IOException(GT.tr("Cannot write to bulkload a byte of value {0}", b));
        }
        this.singleByteBuffer[0] = (byte)b;
        this.write(this.singleByteBuffer, 0, 1);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int siz) throws IOException {
        this.checkClosed();
        try {
            this.writeToBulkload(buf, off, siz);
        }
        catch (SQLException se) {
            throw new IOException("Write to bulkload failed.", se);
        }
    }

    private void checkClosed() throws IOException {
        if (this.getOp() == null) {
            throw new IOException(GT.tr("This bulkload stream is closed.", new Object[0]));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.getOp() == null) {
            return;
        }
        if (this.getOp().isActive()) {
            try {
                this.endBulkload();
            }
            catch (SQLException se) {
                throw new IOException("Ending write to bulkload failed.", se);
            }
        }
        this.op = null;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        try {
            this.getOp().writeToBulkload(this.copyBuffer, 0, this.at);
            this.at = 0;
            this.getOp().flushBulkload();
        }
        catch (SQLException e) {
            throw new IOException("Unable to flush stream", e);
        }
    }

    @Override
    public void writeToBulkload(byte[] buf, int off, int siz) throws SQLException {
        if (this.at > 0 && siz > this.copyBuffer.length - this.at) {
            this.getOp().writeToBulkload(this.copyBuffer, 0, this.at);
            this.at = 0;
        }
        if (siz > this.copyBuffer.length) {
            this.getOp().writeToBulkload(buf, off, siz);
        } else {
            System.arraycopy(buf, off, this.copyBuffer, this.at, siz);
            this.at += siz;
        }
    }

    @Override
    public void writeToBulkload(ByteStreamWriter from) throws SQLException {
        if (this.at > 0) {
            this.getOp().writeToBulkload(this.copyBuffer, 0, this.at);
            this.at = 0;
        }
        this.getOp().writeToBulkload(from);
    }

    @Override
    public int getFormat() {
        return this.getOp().getFormat();
    }

    @Override
    public int getFieldFormat(int field) {
        return this.getOp().getFieldFormat(field);
    }

    @Override
    public void cancelBulkload() throws SQLException {
        this.getOp().cancelBulkload();
    }

    @Override
    public int getFieldCount() {
        return this.getOp().getFieldCount();
    }

    @Override
    public boolean isActive() {
        return this.op != null && this.getOp().isActive();
    }

    @Override
    public void flushBulkload() throws SQLException {
        this.getOp().flushBulkload();
    }

    @Override
    public ResultSet endBulkload() throws SQLException {
        if (this.at > 0) {
            this.getOp().writeToBulkload(this.copyBuffer, 0, this.at);
        }
        return this.getOp().endBulkload();
    }

    @Override
    public ResultSet getHandledResultSet() {
        return this.getOp().getHandledResultSet();
    }
}

