/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.http;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CHttp {
    public static final Charset HTTP_CHARSET = StandardCharsets.ISO_8859_1;
    public static final String EOL = "\r\n";
    public static final int HTTP_CONTINUE = 100;
    public static final int HTTP_SWITCHING_PROTOCOLS = 101;
    public static final int HTTP_EARLY_HINTS = 103;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET_CONTENT = 205;
    public static final int HTTP_PARTIAL_CONTENT = 206;
    public static final int HTTP_MULTIPLE_CHOICES = 300;
    public static final int HTTP_MOVED_PERMANENTLY = 301;
    public static final int HTTP_MOVED_TEMPORARY = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_SWITCH_PROXY = 306;
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    public static final int HTTP_PERMANENT_REDIRECT = 308;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_METHOD_NOT_ALLOWED = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH_REQUIRED = 407;
    public static final int HTTP_REQUEST_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECONDITION_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQUEST_URI_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int HTTP_EXPECTATION_FAILED = 417;
    public static final int HTTP_IM_A_TEAPOT = 418;
    public static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    public static final int HTTP_UPGRADE_REQUIRED = 426;
    public static final int HTTP_PRECONDITION_REQUIRED = 428;
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    public static final int HTTP_REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    public static final int HTTP_UNAVAILABLE_FOR_LEGA_REASONS = 451;
    public static final int HTTP_INTERNAL_SERVER_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_SERVICE_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int HTTP_VARIANT_ALSO_NEGOTIATES = 506;
    public static final int HTTP_INSUFFICIENT_STORAGE = 507;
    public static final int HTTP_LOOP_DETECTED = 508;
    public static final int HTTP_NETWORK_AUTHENTICATION_REQUIRED = 511;
    private static final CHttp s_aInstance = new CHttp();

    private CHttp() {
    }

    @Nonnull
    @Nonempty
    public static String getHttpResponseMessage(int n) {
        String string;
        switch (n) {
            case 100: {
                string = "Continue";
                break;
            }
            case 101: {
                string = "Switching Protocols";
                break;
            }
            case 103: {
                string = "Early Hints";
                break;
            }
            case 200: {
                string = "OK";
                break;
            }
            case 201: {
                string = "Created";
                break;
            }
            case 202: {
                string = "Accepted";
                break;
            }
            case 203: {
                string = "Non-Authoritative Information";
                break;
            }
            case 204: {
                string = "No Content";
                break;
            }
            case 205: {
                string = "Reset Content";
                break;
            }
            case 206: {
                string = "Partial Content";
                break;
            }
            case 300: {
                string = "Multiple Choices";
                break;
            }
            case 301: {
                string = "Moved Permanently";
                break;
            }
            case 302: {
                string = "Moved Temporary";
                break;
            }
            case 303: {
                string = "See Other";
                break;
            }
            case 304: {
                string = "Not Modified";
                break;
            }
            case 305: {
                string = "Use Proxy";
                break;
            }
            case 306: {
                string = "Switch Proxy";
                break;
            }
            case 307: {
                string = "Temporary Redirect";
                break;
            }
            case 308: {
                string = "Permanent Redirect";
                break;
            }
            case 400: {
                string = "Bad Request";
                break;
            }
            case 401: {
                string = "Unauthorized";
                break;
            }
            case 402: {
                string = "Payment Required";
                break;
            }
            case 403: {
                string = "Forbidden";
                break;
            }
            case 404: {
                string = "Not Found";
                break;
            }
            case 405: {
                string = "Method Not Allowed";
                break;
            }
            case 406: {
                string = "Not Acceptable";
                break;
            }
            case 407: {
                string = "Proxy Authentication Required";
                break;
            }
            case 408: {
                string = "Request Time-out";
                break;
            }
            case 409: {
                string = "Conflict";
                break;
            }
            case 410: {
                string = "Gone";
                break;
            }
            case 411: {
                string = "Length Required";
                break;
            }
            case 412: {
                string = "Precondition Failed";
                break;
            }
            case 413: {
                string = "Request Entity Too Large";
                break;
            }
            case 414: {
                string = "Request-URI Too Large";
                break;
            }
            case 415: {
                string = "Unsupported Media Type";
                break;
            }
            case 416: {
                string = "Requested Range not satisfiable";
                break;
            }
            case 417: {
                string = "Expectation Failed";
                break;
            }
            case 418: {
                string = "I'm a teapot";
                break;
            }
            case 422: {
                string = "Unprocessable Entity";
                break;
            }
            case 426: {
                string = "Upgrade Required";
                break;
            }
            case 428: {
                string = "Precondition Required";
                break;
            }
            case 429: {
                string = "Too Many Requests";
                break;
            }
            case 431: {
                string = "Request Header Fields Too Large";
                break;
            }
            case 451: {
                string = "Unavailable For Legal Reasons";
                break;
            }
            case 500: {
                string = "Internal Server Error";
                break;
            }
            case 501: {
                string = "Not Implemented";
                break;
            }
            case 502: {
                string = "Bad Gateway";
                break;
            }
            case 503: {
                string = "Service Unavailable";
                break;
            }
            case 504: {
                string = "Gateway Time-out";
                break;
            }
            case 505: {
                string = "HTTP Version not supported";
                break;
            }
            case 506: {
                string = "Variant Also Negotiates";
                break;
            }
            case 507: {
                string = "Insufficient Storage";
                break;
            }
            case 508: {
                string = "Loop Detected";
                break;
            }
            case 511: {
                string = "Network Authentication Required";
                break;
            }
            default: {
                string = "Unknown (" + n + ")";
            }
        }
        return string;
    }

    public static long getUnifiedMillis(long l) {
        return l / 1000L * 1000L;
    }

    @Nonnull
    public static LocalDateTime convertMillisToLocalDateTime(long l) {
        return PDTFactory.createLocalDateTime(CHttp.getUnifiedMillis(l));
    }
}

