/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.ERandomAccessFileMode;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.ByteBufferOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileChannelHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileChannelHelper.class);
    private static final FileChannelHelper s_aInstance = new FileChannelHelper();

    private FileChannelHelper() {
    }

    @CheckForSigned
    public static long getFileSize(@Nullable FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                return fileChannel.size();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Nullable
    private static InputStream _getMappedInputStream(@Nonnull @WillNotClose FileChannel fileChannel, @Nonnull File file) {
        try {
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            s_aLogger.info("Created memory mapped input stream for " + file);
            return new ByteBufferInputStream(mappedByteBuffer);
        }
        catch (IOException iOException) {
            s_aLogger.warn("Failed to create memory mapped input stream for " + file, (Throwable)iOException);
            return null;
        }
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull File file) {
        InputStream inputStream;
        FileChannel fileChannel;
        ValueEnforcer.notNull(file, "File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        if (fileInputStream != null && FileChannelHelper.getFileSize(fileChannel = fileInputStream.getChannel()) > 0x100000L && (inputStream = FileChannelHelper._getMappedInputStream(fileChannel, file)) != null) {
            return inputStream;
        }
        return fileInputStream;
    }

    @Nullable
    public static FileChannel getFileReadChannel(@Nonnull String string) {
        return FileChannelHelper.getFileReadChannel(new File(string));
    }

    @Nullable
    public static FileChannel getFileReadChannel(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        return fileInputStream == null ? null : fileInputStream.getChannel();
    }

    @Nullable
    public static InputStream getMappedInputStream(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        FileInputStream fileInputStream = FileHelper.getInputStream(file);
        if (fileInputStream == null) {
            return null;
        }
        InputStream inputStream = FileChannelHelper._getMappedInputStream(fileInputStream.getChannel(), file);
        if (inputStream != null) {
            return inputStream;
        }
        s_aLogger.warn("Failed to map file " + file + ". Falling though to regular FileInputStream");
        return fileInputStream;
    }

    @Nullable
    private static OutputStream _getMappedOutputStream(@Nonnull @WillNotClose FileChannel fileChannel, @Nonnull File file) {
        try {
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
            s_aLogger.info("Created memory mapped output stream for " + file);
            return new ByteBufferOutputStream(mappedByteBuffer, false);
        }
        catch (IOException iOException) {
            s_aLogger.warn("Failed to create memory mapped output stream for " + file, (Throwable)iOException);
            return null;
        }
    }

    @Nullable
    public static FileChannel getFileWriteChannel(@Nonnull String string) {
        return FileChannelHelper.getFileWriteChannel(string, EAppend.DEFAULT);
    }

    @Nullable
    public static FileChannel getFileWriteChannel(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileChannelHelper.getFileWriteChannel(new File(string), eAppend);
    }

    @Nullable
    public static FileChannel getFileWriteChannel(@Nonnull File file) {
        return FileChannelHelper.getFileWriteChannel(file, EAppend.DEFAULT);
    }

    @Nullable
    public static FileChannel getFileWriteChannel(@Nonnull File file, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(eAppend, "Append");
        FileOutputStream fileOutputStream = FileHelper.getOutputStream(file, eAppend);
        return fileOutputStream == null ? null : fileOutputStream.getChannel();
    }

    @Nullable
    public static OutputStream getMappedOutputStream(@Nonnull String string) {
        return FileChannelHelper.getMappedOutputStream(new File(string));
    }

    @Nullable
    public static OutputStream getMappedOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileChannelHelper.getMappedOutputStream(new File(string), eAppend);
    }

    @Nullable
    public static OutputStream getMappedOutputStream(@Nonnull File file) {
        return FileChannelHelper.getMappedOutputStream(file, EAppend.DEFAULT);
    }

    @Nullable
    public static OutputStream getMappedOutputStream(@Nonnull File file, @Nonnull EAppend eAppend) {
        ValueEnforcer.notNull(file, "File");
        ValueEnforcer.notNull(eAppend, "Append");
        if (FileHelper.internalCheckParentDirectoryExistanceAndAccess(file).isInvalid()) {
            return null;
        }
        RandomAccessFile randomAccessFile = FileHelper.getRandomAccessFile(file, ERandomAccessFileMode.READ_WRITE);
        if (randomAccessFile == null) {
            s_aLogger.error("Failed to open random access file " + file);
            return null;
        }
        OutputStream outputStream = FileChannelHelper._getMappedOutputStream(randomAccessFile.getChannel(), file);
        if (outputStream != null) {
            return outputStream;
        }
        StreamHelper.close(randomAccessFile);
        s_aLogger.warn("Failed to map file " + file + ". Falling though to regular FileOutputStream");
        return FileHelper.getOutputStream(file, eAppend);
    }
}

