/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>
extends ConcurrentHashMap<KEYTYPE, VALUETYPE>
implements ICommonsMap<KEYTYPE, VALUETYPE> {
    public CommonsConcurrentHashMap() {
    }

    public CommonsConcurrentHashMap(int n) {
        super(n);
    }

    public CommonsConcurrentHashMap(int n, @Nonnegative float f) {
        super(n, f);
    }

    public CommonsConcurrentHashMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(CollectionHelper.getSize(map));
        if (map != null) {
            this.putAll(map);
        }
    }

    public <COLLTYPE> CommonsConcurrentHashMap(@Nullable Collection<? extends COLLTYPE> collection, @Nonnull Function<? super COLLTYPE, ? extends KEYTYPE> function, @Nonnull Function<? super COLLTYPE, ? extends VALUETYPE> function2) {
        super(CollectionHelper.getSize(collection));
        this.putAllMapped(collection, function, function2);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public <K, V> CommonsConcurrentHashMap<K, V> createInstance() {
        return new CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CommonsConcurrentHashMap<KEYTYPE, VALUETYPE> getClone() {
        return new CommonsConcurrentHashMap<KEYTYPE, VALUETYPE>(this);
    }
}

