/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javax.annotation.Nonnull;

public class PDTZoneID {
    private static final ICommonsList<PDTZoneID> ZONES = new CommonsArrayList<PDTZoneID>();
    private final String m_sZoneID;
    private final ZoneId m_aZoneID;

    protected PDTZoneID(@Nonnull @Nonempty String string, @Nonnull ZoneId zoneId) {
        this.m_sZoneID = ValueEnforcer.notEmpty(string, "ZoneIDString");
        this.m_aZoneID = ValueEnforcer.notNull(zoneId, "ZoneID");
    }

    @Nonnull
    @Nonempty
    public String getZoneIDString() {
        return this.m_sZoneID;
    }

    @Nonnull
    public ZoneId getZoneID() {
        return this.m_aZoneID;
    }

    @Nonnull
    public static PDTZoneID of(@Nonnull String string) {
        return new PDTZoneID(string, ZoneId.of(string));
    }

    @Nonnull
    public static PDTZoneID ofHours(@Nonnull String string, int n) {
        return new PDTZoneID(string, ZoneOffset.ofHours(n));
    }

    @Nonnull
    public static ICommonsIterable<PDTZoneID> getDefaultZoneIDs() {
        return ZONES;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<PDTZoneID> getAllDefaultZoneIDs() {
        return (ICommonsList)ZONES.getClone();
    }

    static {
        ZONES.add(PDTZoneID.of("UTC"));
        ZONES.add(PDTZoneID.of("GMT"));
        ZONES.add(PDTZoneID.ofHours("EST", -5));
        ZONES.add(PDTZoneID.ofHours("EDT", -4));
        ZONES.add(PDTZoneID.ofHours("CST", -6));
        ZONES.add(PDTZoneID.ofHours("CDT", -5));
        ZONES.add(PDTZoneID.ofHours("MST", -7));
        ZONES.add(PDTZoneID.ofHours("MDT", -6));
        ZONES.add(PDTZoneID.ofHours("PST", -8));
        ZONES.add(PDTZoneID.ofHours("PDT", -7));
        ZONES.add(PDTZoneID.of("UT"));
        ZONES.add(PDTZoneID.ofHours("A", -1));
        ZONES.add(PDTZoneID.ofHours("B", -2));
        ZONES.add(PDTZoneID.ofHours("C", -3));
        ZONES.add(PDTZoneID.ofHours("D", -4));
        ZONES.add(PDTZoneID.ofHours("E", -5));
        ZONES.add(PDTZoneID.ofHours("F", -6));
        ZONES.add(PDTZoneID.ofHours("G", -7));
        ZONES.add(PDTZoneID.ofHours("H", -8));
        ZONES.add(PDTZoneID.ofHours("I", -9));
        ZONES.add(PDTZoneID.ofHours("K", -10));
        ZONES.add(PDTZoneID.ofHours("L", -11));
        ZONES.add(PDTZoneID.ofHours("M", -12));
        ZONES.add(PDTZoneID.ofHours("N", 1));
        ZONES.add(PDTZoneID.ofHours("O", 2));
        ZONES.add(PDTZoneID.ofHours("P", 3));
        ZONES.add(PDTZoneID.ofHours("Q", 4));
        ZONES.add(PDTZoneID.ofHours("R", 5));
        ZONES.add(PDTZoneID.ofHours("S", 6));
        ZONES.add(PDTZoneID.ofHours("T", 7));
        ZONES.add(PDTZoneID.ofHours("U", 8));
        ZONES.add(PDTZoneID.ofHours("V", 9));
        ZONES.add(PDTZoneID.ofHours("W", 10));
        ZONES.add(PDTZoneID.ofHours("X", 11));
        ZONES.add(PDTZoneID.ofHours("Y", 12));
        ZONES.add(PDTZoneID.of("Z"));
    }
}

