/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.suggest.scorer.lexeme;

import com.hankcs.hanlp.algorithm.ArrayCompare;
import com.hankcs.hanlp.algorithm.ArrayDistance;
import com.hankcs.hanlp.dictionary.CoreSynonymDictionaryEx;
import com.hankcs.hanlp.suggest.scorer.ISentenceKey;
import com.hankcs.hanlp.tokenizer.IndexTokenizer;
import java.util.Iterator;
import java.util.List;

public class IdVector
implements Comparable<IdVector>,
ISentenceKey<IdVector> {
    public List<Long[]> idArrayList;

    public IdVector(String sentence) {
        this(CoreSynonymDictionaryEx.convert(IndexTokenizer.segment(sentence), false));
    }

    public IdVector(List<Long[]> idArrayList) {
        this.idArrayList = idArrayList;
    }

    @Override
    public int compareTo(IdVector o) {
        int len1 = this.idArrayList.size();
        int len2 = o.idArrayList.size();
        int lim = Math.min(len1, len2);
        Iterator<Long[]> iterator1 = this.idArrayList.iterator();
        Iterator<Long[]> iterator2 = o.idArrayList.iterator();
        for (int k = 0; k < lim; ++k) {
            Long[] c2;
            Long[] c1 = iterator1.next();
            if (ArrayDistance.computeMinimumDistance(c1, c2 = iterator2.next()) == 0L) continue;
            return ArrayCompare.compare(c1, c2);
        }
        return len1 - len2;
    }

    @Override
    public Double similarity(IdVector other) {
        Double score = 0.0;
        for (Long[] a : this.idArrayList) {
            for (Long[] b : other.idArrayList) {
                Long distance = ArrayDistance.computeAverageDistance(a, b);
                score = score + 1.0 / (0.1 + (double)distance.longValue());
            }
        }
        return score / (double)other.idArrayList.size();
    }
}

