/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class MaxHeap<E>
implements Iterable<E> {
    private PriorityQueue<E> queue;
    private int maxSize;

    public MaxHeap(int maxSize, Comparator<E> comparator) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
        this.queue = new PriorityQueue<E>(maxSize, comparator);
    }

    public boolean add(E e) {
        if (this.queue.size() < this.maxSize) {
            this.queue.add(e);
            return true;
        }
        E peek = this.queue.peek();
        if (this.queue.comparator().compare(e, peek) > 0) {
            this.queue.poll();
            this.queue.add(e);
            return true;
        }
        return false;
    }

    public MaxHeap<E> addAll(Collection<E> collection) {
        for (E e : collection) {
            this.add(e);
        }
        return this;
    }

    public List<E> toList() {
        ArrayList<E> list = new ArrayList<E>(this.queue.size());
        while (!this.queue.isEmpty()) {
            list.add(0, this.queue.poll());
        }
        return list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    public int size() {
        return this.queue.size();
    }
}

